/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionConfigType
extends ConfigBeanNode {
    String sessionTimeout;

    public SessionConfigType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("session-config");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (!nodeName.equals("session-timeout")) continue;
                this.sessionTimeout = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this.sessionTimeout != null && !this.sessionTimeout.trim().equals("")) {
            XMLUtils.writeTagStart(out, indentation, "session-config");
            XMLUtils.writeTag(out, indentation + "\t", "session-timeout", this.sessionTimeout);
            XMLUtils.writeTagEnd(out, indentation, "session-config");
        }
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }
}

