/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.SerializerType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMappingType
extends ConfigBeanNode {
    String _javaClass = null;
    String _xmlType = null;
    SerializerType[] _serializers = null;

    public TypeMappingType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public TypeMappingType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setJavaClass(String javaClass) {
        String oldValue = this._javaClass;
        this._javaClass = javaClass;
        this.firePropertyChange("javaClass", oldValue, this._javaClass);
    }

    public String getJavaClass() {
        return this._javaClass;
    }

    public String defaultJavaClass() {
        return "";
    }

    public void setXmlType(String xmlType) {
        String oldValue = this._xmlType;
        this._xmlType = xmlType;
        this.firePropertyChange("xmlType", oldValue, this._xmlType);
    }

    public String getXmlType() {
        return this._xmlType;
    }

    public String defaultXmlType() {
        return "";
    }

    public void setSerializers(SerializerType[] serializers) {
        this._serializers = serializers;
    }

    public SerializerType[] getSerializers() {
        return this._serializers;
    }

    public SerializerType[] defaultSerializers() {
        return new SerializerType[0];
    }

    public void addSerializers() throws ConfigurationException {
        if (this._serializers != null) {
            return;
        }
        SerializerType[] serializers = new SerializerType[]{new SerializerType(this, null)};
        this.setSerializers(serializers);
    }

    public void removeSerializers() {
        if (this._serializers == null) {
            return;
        }
        this.setSerializers(null);
    }

    public void addSerializer(SerializerType serializer) {
        serializer.setParent(this);
        int existingSerializersCnt = 0;
        if (this._serializers != null) {
            existingSerializersCnt = this._serializers.length;
        }
        SerializerType[] newSerializers = new SerializerType[existingSerializersCnt + 1];
        for (int n = 0; n < existingSerializersCnt; ++n) {
            newSerializers[n] = this._serializers[n];
        }
        newSerializers[existingSerializersCnt] = serializer;
        SerializerType[] oldValue = this._serializers;
        this._serializers = newSerializers;
        this.firePropertyChange("serializers", oldValue, this._serializers);
    }

    public void removeSerializer(SerializerType serializer) {
        int existingSerializersCnt = 0;
        if (this._serializers != null) {
            existingSerializersCnt = this._serializers.length;
        }
        SerializerType[] newSerializers = new SerializerType[existingSerializersCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingSerializersCnt; ++n) {
            if (serializer.equals(this._serializers[n])) continue;
            newSerializers[newIndex++] = this._serializers[n];
        }
        if (newSerializers.length == 0) {
            newSerializers = null;
        }
        SerializerType[] oldValue = this._serializers;
        this._serializers = newSerializers;
        this.firePropertyChange("serializers", oldValue, this._serializers);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "type-mapping");
        XMLUtils.writeAttribute(out, indentation, "java-class", this._javaClass);
        XMLUtils.writeAttribute(out, indentation, "xml-type", this._xmlType);
        XMLUtils.writeTagAttributeEnd(out, indentation, "type-mapping");
        this.writeSerializersXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "type-mapping");
    }

    public static void writeXML(PrintWriter out, String indentation, TypeMappingType[] typeMappings) throws ExtendedRuntimeException {
        if (typeMappings == null) {
            return;
        }
        for (int n = 0; n < typeMappings.length; ++n) {
            typeMappings[n].writeXML(out, indentation);
        }
    }

    public void writeSerializersXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._serializers != null) {
            TypeMappingType.writeXML(out, indentation + "\t", this._serializers);
        }
    }

    private void init() {
        this.setXpath("type-mapping");
        Vector<SerializerType> serializers = new Vector<SerializerType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "java-class");
            if (val != null && !val.trim().equals("")) {
                this._javaClass = val;
            }
            if ((val = XMLUtils.getAttribute(node, "xml-type")) != null && !val.trim().equals("")) {
                this._xmlType = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("serializer")) continue;
                SerializerType configBean = new SerializerType(this, node);
                serializers.add(configBean);
            }
        }
        if (serializers.size() > 0) {
            this._serializers = serializers.toArray(new SerializerType[0]);
        }
    }
}

