/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.TypeMappingType;
import oracle.oc4j.admin.deploy.spi.xml.TypeNamespaceType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMappingsType
extends ConfigBeanNode {
    TypeMappingType[] _typeMappings = null;
    TypeNamespaceType[] _typeNamespaces = null;

    public TypeMappingsType(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public TypeMappingsType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setTypeMappings(TypeMappingType[] typeMappings) {
        this._typeMappings = typeMappings;
    }

    public TypeMappingType[] getTypeMappings() {
        return this._typeMappings;
    }

    public TypeMappingType[] defaultTypeMappings() {
        return new TypeMappingType[0];
    }

    public void addTypeMappings() throws ConfigurationException {
        if (this._typeMappings != null) {
            return;
        }
        TypeMappingType[] typeMappings = new TypeMappingType[]{new TypeMappingType(this, null)};
        this.setTypeMappings(typeMappings);
    }

    public void removeTypeMappings() {
        if (this._typeMappings == null) {
            return;
        }
        this.setTypeMappings(null);
    }

    public void addTypeMapping(TypeMappingType typeMapping) {
        typeMapping.setParent(this);
        int existingTypeMappingsCnt = 0;
        if (this._typeMappings != null) {
            existingTypeMappingsCnt = this._typeMappings.length;
        }
        TypeMappingType[] newTypeMappings = new TypeMappingType[existingTypeMappingsCnt + 1];
        for (int n = 0; n < existingTypeMappingsCnt; ++n) {
            newTypeMappings[n] = this._typeMappings[n];
        }
        newTypeMappings[existingTypeMappingsCnt] = typeMapping;
        TypeMappingType[] oldValue = this._typeMappings;
        this._typeMappings = newTypeMappings;
        this.firePropertyChange("typeMappings", oldValue, this._typeMappings);
    }

    public void removeTypeMapping(TypeMappingType typeMapping) {
        int existingTypeMappingsCnt = 0;
        if (this._typeMappings != null) {
            existingTypeMappingsCnt = this._typeMappings.length;
        }
        TypeMappingType[] newTypeMappings = new TypeMappingType[existingTypeMappingsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingTypeMappingsCnt; ++n) {
            if (typeMapping.equals(this._typeMappings[n])) continue;
            newTypeMappings[newIndex++] = this._typeMappings[n];
        }
        if (newTypeMappings.length == 0) {
            newTypeMappings = null;
        }
        TypeMappingType[] oldValue = this._typeMappings;
        this._typeMappings = newTypeMappings;
        this.firePropertyChange("typeMappings", oldValue, this._typeMappings);
    }

    public void setTypeNamespaces(TypeNamespaceType[] typeNamespaces) throws ConfigurationException {
        TypeNamespaceType[] oldValue = this._typeNamespaces;
        this._typeNamespaces = typeNamespaces;
        this.firePropertyChange("typeNamespaces", oldValue, this._typeNamespaces);
    }

    public TypeNamespaceType[] getTypeNamespaces() {
        return this._typeNamespaces;
    }

    public TypeNamespaceType[] defaultTypeNamespaces() {
        try {
            return new TypeNamespaceType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addTypeNamespaces() throws ConfigurationException {
        if (this._typeNamespaces != null) {
            return;
        }
        TypeNamespaceType[] typeNamespaces = new TypeNamespaceType[]{new TypeNamespaceType(this)};
        this.setTypeNamespaces(typeNamespaces);
    }

    public void removeTypeNamespaces() throws ConfigurationException {
        if (this._typeNamespaces == null) {
            return;
        }
        this.setTypeNamespaces(null);
    }

    public void addTypeNamespace(TypeNamespaceType typeNamespace) throws ConfigurationException {
        typeNamespace.setParent(this);
        int existingTypeNamespacesCnt = 0;
        if (this._typeNamespaces != null) {
            existingTypeNamespacesCnt = this._typeNamespaces.length;
        }
        TypeNamespaceType[] newTypeNamespaces = new TypeNamespaceType[existingTypeNamespacesCnt + 1];
        for (int n = 0; n < existingTypeNamespacesCnt; ++n) {
            newTypeNamespaces[n] = this._typeNamespaces[n];
        }
        newTypeNamespaces[existingTypeNamespacesCnt] = typeNamespace;
        TypeNamespaceType[] oldValue = this._typeNamespaces;
        this._typeNamespaces = newTypeNamespaces;
        this.firePropertyChange("typeNamespaces", oldValue, this._typeNamespaces);
    }

    public void removeTypeNamespace(TypeNamespaceType typeNamespace) throws ConfigurationException {
        int existingTypeNamespacesCnt = 0;
        if (this._typeNamespaces != null) {
            existingTypeNamespacesCnt = this._typeNamespaces.length;
        }
        TypeNamespaceType[] newTypeNamespaces = new TypeNamespaceType[existingTypeNamespacesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingTypeNamespacesCnt; ++n) {
            if (typeNamespace.equals(this._typeNamespaces[n])) continue;
            newTypeNamespaces[newIndex++] = this._typeNamespaces[n];
        }
        if (newTypeNamespaces.length == 0) {
            newTypeNamespaces = null;
        }
        TypeNamespaceType[] oldValue = this._typeNamespaces;
        this._typeNamespaces = newTypeNamespaces;
        this.firePropertyChange("typeNamespaces", oldValue, this._typeNamespaces);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "type-mappings");
        this.writeTypeNamespacesXML(out, indentation);
        XMLUtils.writeTagAttributeEnd(out, indentation, "type-mappings");
        this.writeTypeMappingsXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "type-mappings");
    }

    public void writeTypeMappingsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._typeMappings != null) {
            TypeMappingsType.writeXML(out, indentation + "\t", this._typeMappings);
        }
    }

    public void writeTypeNamespacesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        TypeNamespaceType.writeXML(out, indentation, this._typeNamespaces);
    }

    private void init() throws ConfigurationException {
        this.setXpath("type-mappings");
        Vector<TypeMappingType> typeMappings = new Vector<TypeMappingType>();
        Vector<TypeNamespaceType> typeNamespaces = new Vector<TypeNamespaceType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            String[] attNames = XMLUtils.getAttributeNames(node);
            if (attNames != null) {
                for (int a = 0; a < attNames.length; ++a) {
                    String attName = attNames[a];
                    val = XMLUtils.getAttribute(node, attName);
                    if (val == null || val.trim().equals("")) continue;
                    TypeNamespaceType typeNamespace = new TypeNamespaceType(this);
                    typeNamespace.setName(attName);
                    typeNamespace.setValue(val);
                    typeNamespaces.add(typeNamespace);
                }
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("type-mapping")) continue;
                TypeMappingType configBean = new TypeMappingType(this, node);
                typeMappings.add(configBean);
            }
        }
        if (typeMappings.size() > 0) {
            this._typeMappings = typeMappings.toArray(new TypeMappingType[0]);
        }
        if (typeNamespaces.size() > 0) {
            this._typeNamespaces = typeNamespaces.toArray(new TypeNamespaceType[0]);
        }
    }
}

