/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UsernameTokenConfigType
extends ConfigBeanNode {
    PropertyConfigBean[] _properties = null;
    String _name = null;
    String _password = null;
    StringType _passwordType = null;
    StringType _oldPasswordType = null;
    String _cbhandlerName = null;
    BooleanType _addNonce = null;
    BooleanType _oldAddNonce = null;
    BooleanType _addCreated = null;
    BooleanType _oldAddCreated = null;

    public UsernameTokenConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public UsernameTokenConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void setName(String name) {
        String oldValue = this._name;
        this._name = name;
        this.firePropertyChange("name", oldValue, this._name);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        return "";
    }

    public void setPassword(String password) {
        String oldValue = this._password;
        this._password = password;
        this.firePropertyChange("password", oldValue, this._password);
    }

    public String getPassword() {
        return this._password;
    }

    public String defaultPassword() {
        return "";
    }

    public void setPasswordType(StringType passwordType) throws ConfigurationException {
        this._passwordType = passwordType;
        this.firePropertyChange("passwordType", this._oldPasswordType, this._passwordType);
        if (this._passwordType != null) {
            if (this._oldPasswordType == null) {
                this._oldPasswordType = this.defaultPasswordType();
            }
            this._oldPasswordType.setValue(this._passwordType.getValue());
        } else {
            this._oldPasswordType = null;
        }
    }

    public StringType getPasswordType() {
        return this._passwordType;
    }

    public StringType defaultPasswordType() {
        String[] tags = new String[]{"PLAINTEXT", "DIGEST"};
        return new StringType(this, tags, "PLAINTEXT");
    }

    public void setCbhandlerName(String cbhandlerName) {
        String oldValue = this._cbhandlerName;
        this._cbhandlerName = cbhandlerName;
        this.firePropertyChange("cbhandlerName", oldValue, this._cbhandlerName);
    }

    public String getCbhandlerName() {
        return this._cbhandlerName;
    }

    public String defaultCbhandlerName() {
        return "";
    }

    public void setAddNonce(BooleanType addNonce) throws ConfigurationException {
        this._addNonce = addNonce;
        this.firePropertyChange("addNonce", this._oldAddNonce, this._addNonce);
        if (this._addNonce != null) {
            if (this._oldAddNonce == null) {
                this._oldAddNonce = this.defaultAddNonce();
            }
            this._oldAddNonce.setValue(this._addNonce.getValue());
        } else {
            this._oldAddNonce = null;
        }
    }

    public BooleanType getAddNonce() {
        return this._addNonce;
    }

    public BooleanType defaultAddNonce() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setAddCreated(BooleanType addCreated) throws ConfigurationException {
        this._addCreated = addCreated;
        this.firePropertyChange("addCreated", this._oldAddCreated, this._addCreated);
        if (this._addCreated != null) {
            if (this._oldAddCreated == null) {
                this._oldAddCreated = this.defaultAddCreated();
            }
            this._oldAddCreated.setValue(this._addCreated.getValue());
        } else {
            this._oldAddCreated = null;
        }
    }

    public BooleanType getAddCreated() {
        return this._addCreated;
    }

    public BooleanType defaultAddCreated() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("name") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "username-token");
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        if (this._password != null && this._password.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "password", this._password);
        }
        XMLUtils.writeAttribute(out, indentation, "password-type", this._passwordType);
        if (this._cbhandlerName != null && this._cbhandlerName.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "cbhandler-name", this._cbhandlerName);
        }
        XMLUtils.writeAttribute(out, indentation, "add-nonce", this._addNonce);
        XMLUtils.writeAttribute(out, indentation, "add-created", this._addCreated);
        XMLUtils.writeTagAttributeEnd(out, indentation, "username-token");
        UsernameTokenConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "username-token");
    }

    private void init() throws ConfigurationException {
        this.setXpath("username-token");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name");
            if (val != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(node, "password")) != null && !val.trim().equals("")) {
                this._password = val;
            }
            if ((val = XMLUtils.getAttribute(node, "password-type")) != null && !val.trim().equals("")) {
                StringType passwordType = this.defaultPasswordType();
                passwordType.setValue(val);
                this.setPasswordType(passwordType);
            }
            if ((val = XMLUtils.getAttribute(node, "cbhandler-name")) != null && !val.trim().equals("")) {
                this._cbhandlerName = val;
            }
            if ((val = XMLUtils.getAttribute(node, "add-nonce")) != null && !val.trim().equals("")) {
                BooleanType addNonce = this.defaultAddNonce();
                addNonce.setValue(val);
                this.setAddNonce(addNonce);
            }
            if ((val = XMLUtils.getAttribute(node, "add-created")) != null && !val.trim().equals("")) {
                BooleanType addCreated = this.defaultAddCreated();
                addCreated.setValue(val);
                this.setAddCreated(addCreated);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

