/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SubjectConfirmationMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SubjectConfirmationMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.VerifySamlTokenConfigType;

public class VerifySamlTokenTreeNode
extends ConfigTreeNode
implements ActionListener {
    private VerifySamlTokenConfigType _bean;
    private static final String ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING = "Add Subject Confirmation Method";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_VERIFY_SAML_TOKEN_CONFIG_MENU_STRING = "Remove Verify Saml Token";
    private JMenuItem _addSubjectConfirmationMethodMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeVerifySamlTokenConfigMenuItem;

    public VerifySamlTokenTreeNode(ConfigTreeNode rootNode, VerifySamlTokenConfigType verifySamlTokenConfig) {
        super(verifySamlTokenConfig);
        this.setRootNode(rootNode);
        this._bean = verifySamlTokenConfig;
        this._addSubjectConfirmationMethodMenuItem = new JMenuItem(ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING);
        this._addSubjectConfirmationMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSubjectConfirmationMethodMenuItem.setFont(VerifySamlTokenTreeNode.getFont());
        this._addSubjectConfirmationMethodMenuItem.addActionListener(this);
        if (this._bean.getSubjectConfirmationMethod() != null) {
            this._addSubjectConfirmationMethodMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(VerifySamlTokenTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeVerifySamlTokenConfigMenuItem = new JMenuItem(REMOVE_VERIFY_SAML_TOKEN_CONFIG_MENU_STRING);
        this._removeVerifySamlTokenConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeVerifySamlTokenConfigMenuItem.setFont(VerifySamlTokenTreeNode.getFont());
        this._removeVerifySamlTokenConfigMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._addSubjectConfirmationMethodMenuItem);
        this._popup.add(this._removeVerifySamlTokenConfigMenuItem);
    }

    public String viewHeaderString() {
        return "Verify Saml Token";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties;
        SubjectConfirmationMethodConfigType subjectConfirmationMethod = this._bean.getSubjectConfirmationMethod();
        if (subjectConfirmationMethod != null) {
            SubjectConfirmationMethodTreeNode subjectConfirmationMethodTreeNode = new SubjectConfirmationMethodTreeNode(this.getRootNode(), subjectConfirmationMethod);
            this.addChild(subjectConfirmationMethodTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING)) {
                SubjectConfirmationMethodConfigType newSubjectConfirmationMethod = this._bean.defaultSubjectConfirmationMethod();
                if (this.showAddDialog(newSubjectConfirmationMethod, ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING)) {
                    this._bean.setSubjectConfirmationMethod(newSubjectConfirmationMethod);
                    SubjectConfirmationMethodTreeNode newNode = new SubjectConfirmationMethodTreeNode(this, newSubjectConfirmationMethod);
                    this.insertNode(newNode);
                    this._addSubjectConfirmationMethodMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_VERIFY_SAML_TOKEN_CONFIG_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SubjectConfirmationMethodTreeNode) {
            this._bean.removeSubjectConfirmationMethod();
            this.removeNode(node);
            this._addSubjectConfirmationMethodMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

