/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyUsernameTokenConfigType
extends ConfigBeanNode {
    PropertyConfigBean[] _properties = null;
    StringType _passwordType = null;
    StringType _oldPasswordType = null;
    BooleanType _requireNonce = null;
    BooleanType _oldRequireNonce = null;
    BooleanType _requireCreated = null;
    BooleanType _oldRequireCreated = null;

    public VerifyUsernameTokenConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public VerifyUsernameTokenConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void setPasswordType(StringType passwordType) throws ConfigurationException {
        this._passwordType = passwordType;
        this.firePropertyChange("passwordType", this._oldPasswordType, this._passwordType);
        if (this._passwordType != null) {
            if (this._oldPasswordType == null) {
                this._oldPasswordType = this.defaultPasswordType();
            }
            this._oldPasswordType.setValue(this._passwordType.getValue());
        } else {
            this._oldPasswordType = null;
        }
    }

    public StringType getPasswordType() {
        return this._passwordType;
    }

    public StringType defaultPasswordType() {
        String[] tags = new String[]{"PLAINTEXT", "DIGEST"};
        return new StringType(this, tags, null);
    }

    public void setRequireNonce(BooleanType requireNonce) throws ConfigurationException {
        this._requireNonce = requireNonce;
        this.firePropertyChange("requireNonce", this._oldRequireNonce, this._requireNonce);
        if (this._requireNonce != null) {
            if (this._oldRequireNonce == null) {
                this._oldRequireNonce = this.defaultRequireNonce();
            }
            this._oldRequireNonce.setValue(this._requireNonce.getValue());
        } else {
            this._oldRequireNonce = null;
        }
    }

    public BooleanType getRequireNonce() {
        return this._requireNonce;
    }

    public BooleanType defaultRequireNonce() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setRequireCreated(BooleanType requireCreated) throws ConfigurationException {
        this._requireCreated = requireCreated;
        this.firePropertyChange("requireCreated", this._oldRequireCreated, this._requireCreated);
        if (this._requireCreated != null) {
            if (this._oldRequireCreated == null) {
                this._oldRequireCreated = this.defaultRequireCreated();
            }
            this._oldRequireCreated.setValue(this._requireCreated.getValue());
        } else {
            this._oldRequireCreated = null;
        }
    }

    public BooleanType getRequireCreated() {
        return this._requireCreated;
    }

    public BooleanType defaultRequireCreated() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "verify-username-token");
        XMLUtils.writeAttribute(out, indentation, "password-type", this._passwordType);
        XMLUtils.writeAttribute(out, indentation, "require-nonce", this._requireNonce);
        XMLUtils.writeAttribute(out, indentation, "require-created", this._requireCreated);
        XMLUtils.writeTagAttributeEnd(out, indentation, "verify-username-token");
        VerifyUsernameTokenConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "verify-username-token");
    }

    private void init() throws ConfigurationException {
        this.setXpath("verify-username-token");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "password-type");
            if (val != null && !val.trim().equals("")) {
                StringType passwordType = this.defaultPasswordType();
                passwordType.setValue(val);
                this.setPasswordType(passwordType);
            }
            if ((val = XMLUtils.getAttribute(node, "require-nonce")) != null && !val.trim().equals("")) {
                BooleanType requireNonce = this.defaultRequireNonce();
                requireNonce.setValue(val);
                this.setRequireNonce(requireNonce);
            }
            if ((val = XMLUtils.getAttribute(node, "require-created")) != null && !val.trim().equals("")) {
                BooleanType requireCreated = this.defaultRequireCreated();
                requireCreated.setValue(val);
                this.setRequireCreated(requireCreated);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

