/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.VirtualDirectoryTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.VirtualDirectoryType;

public class VirtualDirectoriesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_VIRTUAL_DIRECTORY_MENU_STRING = "Add Virtual Directory";
    private JMenuItem _addVirtualDirectoryMenuItem;
    private VirtualDirectoryType[] virtualDirectoryType = new VirtualDirectoryType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public VirtualDirectoriesTreeNode(ConfigTreeNode rootNode, MultipleType virtualDirectories) {
        super(virtualDirectories);
        this.setRootNode(rootNode);
        this._parentBean = virtualDirectories.getConfigParent();
        this._addVirtualDirectoryMenuItem = new JMenuItem(ADD_VIRTUAL_DIRECTORY_MENU_STRING);
        this._addVirtualDirectoryMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addVirtualDirectoryMenuItem.setFont(VirtualDirectoriesTreeNode.getFont());
        this._addVirtualDirectoryMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addVirtualDirectoryMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getVirtualDirectories", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addVirtualDirectory", VirtualDirectoryType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeVirtualDirectory", VirtualDirectoryType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Virtual Directories";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            VirtualDirectoryType[] virtualDirectories = (VirtualDirectoryType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (virtualDirectories != null) {
                for (int i = 0; i < virtualDirectories.length; ++i) {
                    VirtualDirectoryType virtualDirectory = virtualDirectories[i];
                    if (virtualDirectory == null) continue;
                    VirtualDirectoryTreeNode virtualDirectoryTreeNode = new VirtualDirectoryTreeNode(this.getRootNode(), virtualDirectory);
                    this.addChild(virtualDirectoryTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            VirtualDirectoryType newVirtualDirectory;
            if (event.getActionCommand().equals(ADD_VIRTUAL_DIRECTORY_MENU_STRING) && this.showAddDialog(newVirtualDirectory = new VirtualDirectoryType(this._parentBean), ADD_VIRTUAL_DIRECTORY_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newVirtualDirectory);
                VirtualDirectoryTreeNode newNode = new VirtualDirectoryTreeNode(this, newVirtualDirectory);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof VirtualDirectoryTreeNode) {
            try {
                VirtualDirectoryType virtualDirectory = (VirtualDirectoryType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, virtualDirectory);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

