/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualDirectoryType
extends ConfigBeanNode {
    String _realPath = null;
    String _virtualPath = null;

    public VirtualDirectoryType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public VirtualDirectoryType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setRealPath(String realPath) {
        String oldValue = this._realPath;
        this._realPath = realPath;
        this.firePropertyChange("realPath", oldValue, this._realPath);
    }

    public String getRealPath() {
        return this._realPath;
    }

    public String defaultRealPath() {
        return "";
    }

    public void setVirtualPath(String virtualPath) {
        String oldValue = this._virtualPath;
        this._virtualPath = virtualPath;
        this.firePropertyChange("virtualPath", oldValue, this._virtualPath);
    }

    public String getVirtualPath() {
        return this._virtualPath;
    }

    public String defaultVirtualPath() {
        return "";
    }

    public boolean validatePropertyValue(String name, Object value) {
        if (name.equals("realPath") && (value == null || !(value instanceof String) || ((String)value).length() == 0)) {
            return false;
        }
        return !name.equals("virtualPath") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._realPath != null && this._realPath.length() > 0 && this._virtualPath != null && this._virtualPath.length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation, "virtual-directory");
            XMLUtils.writeAttribute(out, indentation, "real-path", this._realPath);
            XMLUtils.writeAttribute(out, indentation, "virtual-path", this._virtualPath);
            XMLUtils.writeTagAttributeEnd(out, indentation, "virtual-directory");
            XMLUtils.writeTagEnd(out, indentation, "virtual-directory");
        }
    }

    public static void writeXML(PrintWriter out, String indentation, VirtualDirectoryType[] virtualDirectories) throws ExtendedRuntimeException {
        if (virtualDirectories == null) {
            return;
        }
        for (int n = 0; n < virtualDirectories.length; ++n) {
            virtualDirectories[n].writeXML(out, indentation);
        }
    }

    private void init() {
        this.setXpath("virtual-directory");
        Vector params = new Vector();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "real-path");
            if (val != null && !val.trim().equals("")) {
                this._realPath = val;
            }
            if ((val = XMLUtils.getAttribute(node, "virtual-path")) != null && !val.trim().equals("")) {
                this._virtualPath = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
            }
        }
    }
}

