/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.client.ConfigurableThread;
import oracle.oc4j.admin.jmx.client.CoreRemoteMBeanServer;
import oracle.oc4j.admin.jmx.client.ThreadPool;
import oracle.oc4j.admin.jmx.ejb.ServerSideJMXEvent;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;

public class EventManager
implements Runnable {
    private static Logger logger_ = TraceLogger.getLogger((Class)EventManager.class);
    public static int interval_ = Integer.getInteger("oc4j.jmx.event.interval") != null ? Integer.getInteger("oc4j.jmx.event.interval") : 500;
    private CoreRemoteMBeanServer coreMBeanServer_ = null;
    private ConfigurableThread thread_ = null;
    private boolean stop_ = false;
    private List events_ = null;
    private List dispatchingEvents_ = null;
    private EventDispatcher eventDispatcher_ = null;
    private long totalEventsProcessed_ = 0L;

    public EventManager(CoreRemoteMBeanServer proxyMBeanServer) {
        this.coreMBeanServer_ = proxyMBeanServer;
        this.events_ = new LinkedList();
        this.dispatchingEvents_ = new LinkedList();
        this.eventDispatcher_ = new EventDispatcher();
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Creating EventManager for: " + this.coreMBeanServer_ + " and domain: " + this.getDomain());
        }
    }

    public final Domain getDomain() {
        return this.coreMBeanServer_.getDomain();
    }

    public final synchronized void start() {
        this.thread_ = ThreadPool.getThread();
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Starting EventManager for: " + this.coreMBeanServer_ + " and domain: " + this.getDomain());
            logger_.fine("Retrieval period: " + interval_);
            logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
        }
        this.thread_.start(this);
        this.stop_ = false;
    }

    public final synchronized void stop() {
        if (this.thread_ != null) {
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Stoping EventManager for: " + this.coreMBeanServer_ + " and domain: " + this.getDomain() + " thread: " + this.thread_ + "-" + this.thread_.hashCode());
            }
            this.stop_ = true;
        }
    }

    public final synchronized void stopAndWait() throws InterruptedException {
        this.stop();
        if (this.thread_ != null) {
            this.thread_.waitForRunnableToComplete();
        }
        this.eventDispatcher_.waitForComplete();
    }

    public final synchronized boolean isStarted() {
        return this.thread_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            Thread.currentThread().setName("EventManager::" + this.getDomain().toString());
            try {
                try {
                    while (!this.stop_) {
                        List events = this.coreMBeanServer_.getEvents();
                        if (events != null) {
                            if (events.size() != 0) {
                                this.totalEventsProcessed_ += (long)events.size();
                                if (logger_.isLoggable(Level.FINER)) {
                                    logger_.finer("Total events processed for: " + this.coreMBeanServer_ + " and domain: " + this.getDomain() + " is: " + this.totalEventsProcessed_);
                                }
                            }
                            if (logger_.isLoggable(Level.FINER) && events.size() > 0) {
                                logger_.finer("Retrieved " + events.size() + " event(s) for: " + this.coreMBeanServer_ + " and domain: " + this.getDomain());
                                if (logger_.isLoggable(Level.FINEST)) {
                                    Iterator itevs = events.iterator();
                                    int cnt = 0;
                                    while (itevs.hasNext()) {
                                        ServerSideJMXEvent event = (ServerSideJMXEvent)itevs.next();
                                        RemoteListenerId listenerId = event.getRemoteListenerId();
                                        Notification jmxEvent = event.getNotification();
                                        logger_.finest("Event #" + ++cnt + " RemoteListenerId   : " + listenerId);
                                        logger_.finest("Event #" + cnt + " Notification Source: " + jmxEvent.getSource());
                                        logger_.finest("Event #" + cnt + " Notification Type  : " + jmxEvent.getType());
                                        logger_.finest("Event #" + cnt + " Notification Seq # : " + jmxEvent.getSequenceNumber());
                                        logger_.finest("Event #" + cnt + " Notification Msg   : " + jmxEvent.getMessage());
                                    }
                                }
                            }
                            if (events.size() > 0) {
                                List list = this.events_;
                                synchronized (list) {
                                    this.events_.addAll(events);
                                    this.eventDispatcher_.start();
                                }
                            }
                        } else if (logger_.isLoggable(Level.FINER) && events.size() > 0) {
                            logger_.finer("Retrieved NULL  event(s) for: " + this.coreMBeanServer_ + " and domain: " + this.getDomain());
                        }
                        Thread.yield();
                        Thread.sleep(interval_);
                    }
                    Object var9_10 = null;
                }
                catch (InterruptedException iex) {
                    Object var9_11 = null;
                    if (logger_.isLoggable(Level.FINE)) {
                        logger_.fine("Exiting EventManager Thread for: " + this);
                        logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                    }
                    this.thread_ = null;
                    this.stop_ = false;
                    break block24;
                }
                catch (RuntimeException e) {
                    if (!this.stop_) {
                        if (logger_.isLoggable(Level.SEVERE)) {
                            logger_.log(Level.SEVERE, e.getMessage(), e);
                        }
                        throw e;
                    }
                    Object var9_12 = null;
                    if (logger_.isLoggable(Level.FINE)) {
                        logger_.fine("Exiting EventManager Thread for: " + this);
                        logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                    }
                    this.thread_ = null;
                    this.stop_ = false;
                }
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Exiting EventManager Thread for: " + this);
                    logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                }
                this.thread_ = null;
                this.stop_ = false;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Exiting EventManager Thread for: " + this);
                    logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                }
                this.thread_ = null;
                this.stop_ = false;
                throw throwable;
            }
        }
    }

    class EventDispatcher
    implements Runnable {
        private ConfigurableThread thread_ = null;

        public EventDispatcher() {
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Creating JMX event dispatcher Thread: " + this);
            }
        }

        public final synchronized void start() {
            block4: {
                try {
                    if (this.thread_ == null) {
                        this.thread_ = ThreadPool.getThread();
                        if (logger_.isLoggable(Level.FINE)) {
                            logger_.fine("Starting JMX event dispatcher Thread: " + this);
                            logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                        }
                        this.thread_.start(this);
                    }
                }
                catch (Throwable t) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block4;
                    logger_.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }

        public void waitForComplete() throws InterruptedException {
            if (this.thread_ != null) {
                this.thread_.waitForRunnableToComplete(10000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Thread.currentThread().setName("EventManager::EventDispatcher::" + EventManager.this.getDomain().toString());
            try {
                try {
                    block7: while (true) {
                        List list = EventManager.this.events_;
                        synchronized (list) {
                            if (EventManager.this.events_.isEmpty()) {
                                break;
                            }
                            EventManager.this.dispatchingEvents_.addAll(EventManager.this.events_);
                            EventManager.this.events_.clear();
                        }
                        if (logger_.isLoggable(Level.FINER) && EventManager.this.dispatchingEvents_.size() > 0) {
                            logger_.finer("" + EventManager.this.dispatchingEvents_.size() + " events to be dispatched " + "for: " + EventManager.this.coreMBeanServer_ + " and domain: " + EventManager.this.getDomain());
                        }
                        Iterator iter = EventManager.this.dispatchingEvents_.iterator();
                        int cnt = 0;
                        while (true) {
                            if (!iter.hasNext()) continue block7;
                            ServerSideJMXEvent event = (ServerSideJMXEvent)iter.next();
                            RemoteListenerId listenerId = event.getRemoteListenerId();
                            Notification jmxEvent = event.getNotification();
                            Object handBack = event.getHandbackObject();
                            if (logger_.isLoggable(Level.FINEST)) {
                                logger_.finest("Dispatching Event #" + ++cnt + " RemoteListenerId   : " + listenerId);
                                logger_.finest("Dispatching Event #" + cnt + " Notification Source: " + jmxEvent.getSource());
                                logger_.finest("Dispatching Event #" + cnt + " Notification Type  : " + jmxEvent.getType());
                                logger_.finest("Dispatching Event #" + cnt + " Notification Seq # : " + jmxEvent.getSequenceNumber());
                                logger_.finest("Dispatching Event #" + cnt + " Notification Msg   : " + jmxEvent.getMessage());
                            }
                            EventManager.this.coreMBeanServer_.fireEvent(listenerId, jmxEvent, handBack);
                            iter.remove();
                            Thread.yield();
                        }
                        break;
                    }
                    Object var8_9 = null;
                }
                catch (RuntimeException e) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                    throw e;
                }
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Exiting JMX event dispatcher Thread: " + this);
                    logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                }
                this.thread_ = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Exiting JMX event dispatcher Thread: " + this);
                    logger_.fine("Thread: " + this.thread_ + "-" + this.thread_.hashCode());
                }
                this.thread_ = null;
                throw throwable;
            }
        }
    }
}

