/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import com.evermind.util.ConsoleObfuscator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import oracle.classloader.util.ArrayUtils;
import oracle.oc4j.admin.jmx.client.ClientMBeanServerProxyFactory;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.client.IasDomainFactory;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class Oc4jQuery {
    private static final String BEAN_NAME = "oc4j:J2EEServer=standalone,j2eeType=ClassLoading,name=singleton";
    private static final String OPERATION_NAME = "executeQuery";
    private static final String[] BUILT_IN_SIGNATURE = new String[]{"java.lang.String", "[Ljava.lang.String;"};
    private static final String[] REMOTE_SIGNATURE = new String[]{"java.lang.String", "[B", "[Ljava.lang.String;"};
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 23791;
    private static final String DEFAULT_USER_NAME = "oc4jadmin";
    private static final String USAGE = "\nUsage: [options] [<queryClass>[<queryArgs>]]\n\nExecute an oracle.classloader.query.Query subclass on a running OC4J instance. If\nno queryClass is specified, a simple interactive mode is entered in which multiple\nqueries may be executed.\n\nQuery subclasses are either built-in to OC4J (pass 'list' as the queryClass to\nview) or custom and uploaded from the local file-system using the -cp option.\nOnly the named custom query class is uploaded, so it may only have dependencies\non classes already visible in the server (e.g. inner classes are not supported).\nPass 'example' as the queryClass for a simple source example.\n\nIf present, queryArgs can either be ' ' separated or ',' separated and enclosed\nin parenthesis -- the following are equivalent:\n\n    LoadClass com.acme.Dynamite -depends\n    LoadClass(com.acme.Dynamite,-depends)\n\nPass '-help' as the sole argument to any query for a description of that class.\n\nOptions:\n\n    -h[ost] <host>   The host to connect to. Defaults to 'localhost'.\n    -p[ort] <port>   The port to connect to. Defaults to '23791'.\n    -u[ser] <user>   The user name to connect as. Defaults to 'oc4jadmin'.\n    -pw <pwd>        The user password. If not supplied, will be prompted.\n    -cp <classpath>  The root(s) to find local query classes.\n    -ias             Connect to an IAS domain rather than an OC4J domain.\n\nInteractive mode supports execution of queries using the syntax specified\nabove -- use 'bye' or 'Ctrl-C' to close.";
    private static final String EXAMPLE = "\nimport com.evermind.server.ApplicationServer;\nimport oracle.classloader.query.ReportQuery;\n\npublic class OC4JVersion extends ReportQuery {\n    public String getDescription() {\n        return \"Reports the version of the OC4J server.\";\n    }\n\n    public void createQueryReport(String[] args) throws Exception {\n        ApplicationServer server = ApplicationServer.getInstance();\n        appendln(server.INFO);\n    }\n}";
    private boolean ias;
    private String host;
    private int port;
    private String userName;
    private String passWord;
    private String classPath;
    private String queryClassName;
    private List queryArgs;
    private ClassLoader loader;
    private Connector connection;
    private ObjectName bean;
    private byte[] classData;
    private boolean exit;
    private boolean debug;
    private PrintStream out = System.out;
    private BufferedReader in;

    public static void main(String[] args) {
        try {
            Oc4jQuery client = new Oc4jQuery(args);
            client.execute();
            client.close();
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    private Oc4jQuery(String[] args) throws Exception {
        this.queryArgs = new ArrayList();
        this.bean = new ObjectName(BEAN_NAME);
        this.parseArgs(args);
    }

    private void execute() {
        if (this.connection != null) {
            if (this.queryClassName != null) {
                this.executeQuery();
            } else {
                this.in = new BufferedReader(new InputStreamReader(System.in));
                while (!this.exit) {
                    this.processLine();
                }
            }
        }
    }

    private void processLine() {
        this.out.print("> ");
        try {
            String command = this.in.readLine().trim();
            if (command.equals("bye")) {
                this.exit = true;
            } else {
                this.parseQuery(command);
                if (this.queryClassName != null) {
                    this.executeQuery();
                }
                if (this.queryClassName.equals("Exit")) {
                    this.exit = true;
                }
                this.queryClassName = null;
                this.queryArgs.clear();
            }
        }
        catch (IOException e) {
            this.println(e);
            this.exit = true;
        }
    }

    private void close() {
        if (this.connection != null) {
            this.connection.release();
            this.connection = null;
        }
    }

    private void print(String message) {
        this.out.print(message);
    }

    private void println(String message) {
        this.out.println(message);
    }

    private void println(Throwable error) {
        this.out.println(error.getMessage());
        if (this.debug) {
            error.printStackTrace(this.out);
        }
    }

    protected void executeQuery() {
        if (this.queryClassName.equals("example")) {
            this.println(EXAMPLE);
        } else {
            try {
                String[] signature;
                Object[] parameters;
                this.setClassData();
                String[] args = new String[this.queryArgs.size()];
                this.queryArgs.toArray(args);
                if (this.classData == null) {
                    parameters = new Object[]{this.queryClassName, args};
                    signature = BUILT_IN_SIGNATURE;
                } else {
                    parameters = new Object[]{this.queryClassName, this.classData, args};
                    signature = REMOTE_SIGNATURE;
                }
                Serializable result = (Serializable)this.connection.invoke(this.bean, OPERATION_NAME, parameters, signature);
                this.println(result.toString());
            }
            catch (Exception e) {
                if (this.queryClassName.equals("Exit")) {
                    this.println("Server stopped.");
                }
                this.println(e);
            }
        }
    }

    private void setClassData() throws IOException {
        String filePath;
        InputStream in;
        this.classData = null;
        if (this.loader != null && (in = this.loader.getResourceAsStream(filePath = this.queryClassName.replace('.', '/') + ".class")) != null) {
            this.classData = ArrayUtils.read((InputStream)in);
        }
    }

    private void reset() {
        this.ias = false;
        this.host = DEFAULT_HOST;
        this.port = 23791;
        this.userName = DEFAULT_USER_NAME;
        this.passWord = null;
        this.classPath = null;
        this.queryClassName = null;
        this.queryArgs.clear();
    }

    private void parseArgs(String[] args) throws IOException {
        this.reset();
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            String arg = args[i];
            if (this.queryClassName != null) {
                this.queryArgs.add(arg);
                continue;
            }
            if (arg.startsWith("-ias")) {
                this.ias = true;
                continue;
            }
            if (arg.startsWith("-debug")) {
                this.debug = true;
                continue;
            }
            if (arg.startsWith("-help")) {
                this.usage(1);
                continue;
            }
            if (arg.startsWith("-")) {
                if (++i >= count) {
                    this.usage(0);
                }
                if (arg.equals("-cp")) {
                    this.classPath = args[i];
                    if (this.loader != null) continue;
                    this.loader = Oc4jQuery.createLoader(this.classPath);
                    continue;
                }
                if (arg.equals("-pw") || arg.equals("-pwd")) {
                    this.passWord = args[i];
                    continue;
                }
                if (arg.startsWith("-h") || arg.equals("-host")) {
                    this.host = args[i];
                    continue;
                }
                if (arg.equals("-p") || arg.equals("-port")) {
                    this.port = Integer.parseInt(args[i]);
                    continue;
                }
                if (arg.startsWith("-u") || arg.equals("-user")) {
                    this.userName = args[i];
                    continue;
                }
                this.println("Unknown option: " + arg);
                this.usage(0);
                continue;
            }
            this.parseQuery(arg);
        }
        this.connect();
    }

    private void connect() throws IOException {
        boolean prompt;
        this.print("Connecting to " + this.host + ":" + this.port + " as " + this.userName + "...");
        boolean bl = prompt = this.passWord == null;
        if (prompt) {
            this.println("");
            this.passWord = Oc4jQuery.getPassWord(this.out, "Password: ");
        }
        Domain domain = null;
        domain = this.ias ? IasDomainFactory.getDomain(this.host, this.port, this.userName, this.passWord) : Oc4jDomainFactory.getDomain(this.host, this.port, this.userName, this.passWord);
        try {
            this.connection = ClientMBeanServerProxyFactory.getMBeanServer(domain);
        }
        catch (JMXRuntimeException jMXRuntimeException) {
            // empty catch block
        }
        if (prompt) {
            this.print("Connection");
        }
        if (this.connection == null) {
            this.println(" failed.");
        } else {
            this.println(" ready.");
        }
    }

    private void usage(int exitCode) {
        this.println(USAGE);
        System.exit(exitCode);
    }

    private void parseQuery(String query) {
        this.queryClassName = null;
        int openParen = (query = query.trim()).indexOf(40);
        if (openParen < 0) {
            if (query.indexOf(32) > 0) {
                StringTokenizer tk = new StringTokenizer(query, " ");
                this.queryClassName = tk.nextToken().trim();
                while (tk.hasMoreTokens()) {
                    String arg = tk.nextToken().trim();
                    this.queryArgs.add(arg);
                }
            } else {
                this.queryClassName = query;
            }
        } else {
            this.queryClassName = query.substring(0, openParen).trim();
            String args = null;
            int closeParen = query.indexOf(41, openParen + 1);
            args = closeParen < 0 ? query.substring(openParen + 1).trim() : query.substring(openParen + 1, closeParen).trim();
            StringTokenizer tk = new StringTokenizer(args, ",");
            while (tk.hasMoreTokens()) {
                String arg = tk.nextToken().trim();
                this.queryArgs.add(arg);
            }
        }
    }

    private static ClassLoader createLoader(String classPath) throws IOException {
        StringTokenizer tk = new StringTokenizer(classPath, ":;");
        URL[] classPathArray = new URL[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.equals(".")) {
                token = System.getProperty("user.dir");
            }
            File file = new File(token);
            classPathArray[index++] = file.toURL();
        }
        return new URLClassLoader(classPathArray);
    }

    /*
     * WARNING - void declaration
     */
    private static String getPassWord(PrintStream out, String prompt) throws IOException {
        char[] lineBuffer;
        ConsoleObfuscator obfuscator = new ConsoleObfuscator(out, prompt);
        obfuscator.start();
        InputStream in = System.in;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    void var8_8;
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)var8_8;
                    continue block4;
                }
            }
            break;
        }
        obfuscator.finishObfuscate();
        if (offset == 0) {
            return null;
        }
        return new String(buf, 0, offset);
    }
}

