/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.client.CoreRemoteMBeanServer;
import oracle.oc4j.admin.jmx.client.HeartBeatListener;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;
import oracle.oc4j.admin.jmx.shared.RmiDomain;
import oracle.oc4j.admin.jmx.shared.exceptions.InternalException;

public class RemoteMBeanServer
extends CoreRemoteMBeanServer
implements Connector {
    private static Logger logger_ = TraceLogger.getLogger((Class)RemoteMBeanServer.class);
    private JMXConnector jmxConnector_ = null;
    private static Hashtable domainToRemoteMBeanServerAssociation_ = new Hashtable();
    private static Hashtable domainToRemoteMBeanServerAssociationRefCount_ = new Hashtable();
    private static String lifeCycleLock_ = "RemoteMBeanServer Life cycle Lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteMBeanServer(RmiDomain domain) {
        super(domain);
        if (domain.isCachingOn()) {
            String string = lifeCycleLock_;
            synchronized (string) {
                domainToRemoteMBeanServerAssociation_.put(domain, this);
                domainToRemoteMBeanServerAssociationRefCount_.put(domain, new Integer(1));
            }
        }
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Create RemoteMBeanServer: " + this + " for domain: " + domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connector getMBeanServer(Domain domain) {
        if (!domain.isCachingOn()) {
            return new RemoteMBeanServer((RmiDomain)domain);
        }
        RemoteMBeanServer serv = null;
        String string = lifeCycleLock_;
        synchronized (string) {
            serv = (RemoteMBeanServer)domainToRemoteMBeanServerAssociation_.get(domain);
            if (serv != null) {
                Integer refCount = (Integer)domainToRemoteMBeanServerAssociationRefCount_.get(domain);
                domainToRemoteMBeanServerAssociationRefCount_.put(domain, new Integer(refCount + 1));
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Get RemoteMBeanServer for domain: " + domain + " Ref count is now: " + (refCount + 1));
                }
            }
        }
        if (serv == null) {
            serv = new RemoteMBeanServer((RmiDomain)domain);
        }
        return serv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (!this.getDomain().isCachingOn()) {
            super.release();
            return;
        }
        boolean release = false;
        String string = lifeCycleLock_;
        synchronized (string) {
            Integer refCount = (Integer)domainToRemoteMBeanServerAssociationRefCount_.get(this.getDomain());
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("release call on RemoteMBeanServer: " + this + " for domain: " + this.getDomain() + " Ref count is: " + refCount);
            }
            if (refCount == null) {
                release = true;
            } else if (refCount == 1) {
                domainToRemoteMBeanServerAssociation_.remove(this.getDomain());
                domainToRemoteMBeanServerAssociationRefCount_.remove(this.getDomain());
                release = true;
            } else {
                domainToRemoteMBeanServerAssociationRefCount_.put(this.getDomain(), new Integer(refCount - 1));
            }
        }
        if (release) {
            super.release();
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        RemoteListenerId id = this.registerListener(listener);
        try {
            this.getMBeanServerProxy().addNotificationListener(name, id, filter, handback);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.getMBeanServerProxy().addNotificationListener(name, listener, filter, handback);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RemoteListenerId id = this.getListenerId(listener);
        try {
            this.getMBeanServerProxy().removeNotificationListener(name, id);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        this.unregisterListener(listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.getMBeanServerProxy().removeNotificationListener(name, listener);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RemoteListenerId id = this.getListenerId(listener);
        try {
            this.getMBeanServerProxy().removeNotificationListener(name, id, filter, handback);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.getMBeanServerProxy().removeNotificationListener(name, listener, filter, handback);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.getMBeanServerProxy().unregisterMBean(name);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        try {
            return this.getMBeanServerProxy().getObjectInstance(name);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public String[] getDomains() throws IOException {
        try {
            return this.getMBeanServerProxy().getDomains();
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        try {
            return this.getMBeanServerProxy().queryMBeans(name, query);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        try {
            return this.getMBeanServerProxy().queryNames(name, query);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        try {
            return this.getMBeanServerProxy().isRegistered(name);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Integer getMBeanCount() throws IOException {
        try {
            return this.getMBeanServerProxy().getMBeanCount();
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().getAttribute(name, attribute);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Object getAttribute(ObjectName name, String attribute, Locale locale) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().getAttribute(name, attribute, locale);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().getAttributes(name, attributes);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes, Locale locale) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().getAttributes(name, attributes, locale);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.getMBeanServerProxy().setAttribute(name, attribute);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().setAttributes(name, attributes);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().invoke(name, operationName, this.checkParametersAreSerializable(params), signature);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature, Locale locale) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().invoke(name, operationName, this.checkParametersAreSerializable(params), signature, locale);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public String getDefaultDomain() throws IOException {
        try {
            return this.getMBeanServerProxy().getDefaultDomain();
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            return this.getMBeanServerProxy().getMBeanInfo(name);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        try {
            return this.getMBeanServerProxy().isInstanceOf(name, className);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
        catch (InternalException e) {
            IOException ioe = new IOException(e.getOriginalException().getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public final boolean supportDisconnectedMode() {
        return false;
    }

    public final void setJMXConnector(JMXConnector jmxcon) {
        this.jmxConnector_ = jmxcon;
        if (jmxcon instanceof HeartBeatListener) {
            this.addHeartBeatListener((HeartBeatListener)((Object)jmxcon));
        }
    }

    public final void setLocale(Locale locale) throws IOException {
        try {
            this.getMBeanServerProxy().setLocale(locale);
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
    }

    public final Locale getLocale() throws IOException {
        try {
            return this.getMBeanServerProxy().getLocale();
        }
        catch (RemoteException re) {
            IOException ioe = new IOException(re.getMessage());
            ioe.initCause(re);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        String string = lifeCycleLock_;
        synchronized (string) {
            domainToRemoteMBeanServerAssociation_ = new Hashtable();
            domainToRemoteMBeanServerAssociationRefCount_ = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCache() {
        String string = lifeCycleLock_;
        synchronized (string) {
            Iterator keys = domainToRemoteMBeanServerAssociationRefCount_.keySet().iterator();
            System.out.println("JMX CONNECTION CACHE DUMP");
            while (keys.hasNext()) {
                Domain domain = (Domain)keys.next();
                Integer refCount = (Integer)domainToRemoteMBeanServerAssociationRefCount_.get(domain);
                System.out.println("DOMAIN: " + domain + " REF-COUNT: " + refCount);
            }
        }
    }
}

