/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.client.ConfigurableThread;

public class ThreadPool {
    private static Logger logger_ = TraceLogger.getLogger((Class)ThreadPool.class);
    public static int MAX_THREADS_IN_POOL = 10;
    private static final ThreadPool singleton_ = new ThreadPool();
    private int createdThreads_ = 0;
    private List freeThreads_ = new LinkedList();

    private ThreadPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isEmpty() {
        List list = this.freeThreads_;
        synchronized (list) {
            return this.freeThreads_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void remove(Thread thread) {
        List list = this.freeThreads_;
        synchronized (list) {
            this.freeThreads_.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Thread getThreadInst() {
        List list = this.freeThreads_;
        synchronized (list) {
            if (this.freeThreads_.isEmpty()) {
                ++this.createdThreads_;
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Create new Thread: " + this.createdThreads_);
                }
                return new ConfigurableThreadImpl();
            }
            return (Thread)this.freeThreads_.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int size() {
        List list = this.freeThreads_;
        synchronized (list) {
            return this.freeThreads_.size();
        }
    }

    protected final int getCreatedThreadsInst() {
        return this.createdThreads_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void returnThread(Thread thread) {
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Return Thread: " + thread + "-" + thread.hashCode());
        }
        if (!ThreadPool.isRunningOnClientSide()) {
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Interupt Thread: " + thread + "-" + thread.hashCode());
            }
            thread.interrupt();
            return;
        }
        boolean cleanThreadUp = true;
        List list = this.freeThreads_;
        synchronized (list) {
            if (this.freeThreads_.size() < MAX_THREADS_IN_POOL) {
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Put back Thread in pool: " + thread + "-" + thread.hashCode());
                }
                this.freeThreads_.add(thread);
                cleanThreadUp = false;
            }
        }
        if (cleanThreadUp) {
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Interupt Thread: " + thread + "-" + thread.hashCode());
            }
            thread.interrupt();
        }
    }

    public static ConfigurableThread getThread() {
        return (ConfigurableThread)((Object)singleton_.getThreadInst());
    }

    public static int getPoolSize() {
        return singleton_.size();
    }

    public static int getCreatedThreads() {
        return singleton_.getCreatedThreadsInst();
    }

    public static boolean isRunningOnClientSide() {
        try {
            Class<?> cl = Class.forName("com.evermind.server.ApplicationServer");
            Method start = cl.getMethod("getInstance", null);
            Object ret = start.invoke(null, null);
            if (ret == null) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    class ConfigurableThreadImpl
    extends Thread
    implements ConfigurableThread {
        private Runnable runnable_;
        private String runnableCompletionMonitor_;

        public ConfigurableThreadImpl() {
            super("ConfigurableThreadImpl::");
            this.runnable_ = null;
            this.runnableCompletionMonitor_ = "Runnable Completion Monitor";
            this.setDaemon(true);
            this.start();
        }

        public final synchronized void start(Runnable runnable) {
            this.runnable_ = runnable;
            this.notify();
        }

        public final boolean isExecutingRunnable() {
            return this.runnable_ != null;
        }

        public final void interruptCurrentRunnable() {
            if (this.isExecutingRunnable()) {
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.fine("Interupt Thread: " + this + "-" + this.hashCode());
                }
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRunnableToComplete(long timeout) throws InterruptedException {
            String string = this.runnableCompletionMonitor_;
            synchronized (string) {
                this.runnableCompletionMonitor_.wait(timeout);
            }
        }

        public void waitForRunnableToComplete() throws InterruptedException {
            this.waitForRunnableToComplete(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                while (true) {
                    if (this.runnable_ != null) {
                        String string;
                        Object var2_1;
                        try {
                            this.runnable_.run();
                            var2_1 = null;
                            this.runnable_ = null;
                            string = this.runnableCompletionMonitor_;
                        }
                        catch (Throwable throwable) {
                            var2_1 = null;
                            this.runnable_ = null;
                            string = this.runnableCompletionMonitor_;
                            synchronized (string) {
                                this.runnableCompletionMonitor_.notify();
                            }
                            this.setName("ConfigurableThreadImpl::");
                            ThreadPool.this.returnThread(this);
                            throw throwable;
                        }
                        synchronized (string) {
                            this.runnableCompletionMonitor_.notify();
                        }
                        this.setName("ConfigurableThreadImpl::");
                        ThreadPool.this.returnThread(this);
                        {
                            continue;
                        }
                    }
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                ThreadPool.this.remove(this);
                return;
            }
        }
    }
}

