/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.remote.jms;

import java.util.Map;
import javax.management.remote.JMXServiceURL;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.client.JMSMBeanServerProxyFactory;
import oracle.oc4j.admin.jmx.remote.JMXConnectorImpl;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jApplicationLevelDomain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jDomain;
import oracle.oc4j.admin.jmx.shared.JMSiASDomain;

public class JMSJMXConnectorImpl
extends JMXConnectorImpl {
    public JMSJMXConnectorImpl(JMXServiceURL url, Map environment) {
        super(url, environment);
    }

    protected final Domain getDomain(Map env) {
        Map credentials = (Map)env.get("jmx.remote.credentials");
        if (credentials == null) {
            throw new SecurityException("Missing credentials");
        }
        String login = (String)credentials.get("login");
        if (login == null) {
            throw new SecurityException("Missing login in credentials");
        }
        String password = (String)credentials.get("password");
        if (password == null) {
            throw new SecurityException("Missing password in credentials");
        }
        if (this.appName_ != null) {
            if (this.domain_ == 1) {
                return new JMSOc4jApplicationLevelDomain(this.jmxUrl_.getHost(), this.jmxUrl_.getPort(), login, password, this.appName_);
            }
        }
        if (this.domain_ == 1) {
            return new JMSOc4jDomain(this.jmxUrl_.getHost(), this.jmxUrl_.getPort(), login, password);
        }
        if (this.appName_ == null) {
            if (this.domain_ == 2) {
                return new JMSiASDomain(this.jmxUrl_.getHost(), this.jmxUrl_.getPort(), login, password);
            }
        }
        throw new IllegalArgumentException("Invalid connection information");
    }

    protected final Connector getConnector(Domain domain) {
        return JMSMBeanServerProxyFactory.getMBeanServer(domain);
    }
}

