/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared.util;

import com.evermind.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.oc4j.admin.internal.InternalUploader;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.shared.util.IdGenerator;
import oracle.oc4j.util.FileUtils;

public class DataSink {
    private byte[] _data;
    private String _filePath;
    private InputStream _in;
    private Integer _uploadId = null;
    private boolean _isTempFile = false;
    private Integer _id = null;
    private Logger _logger = Logger.getLogger(DataSink.class.getName());

    public DataSink(byte[] data) {
        this._data = data;
    }

    public DataSink(String filePath) {
        this._filePath = filePath;
    }

    public DataSink(InputStream in) {
        this._in = in;
    }

    public Integer getId() {
        if (this._id == null) {
            this._id = this._uploadId != null ? this._uploadId : IdGenerator.getId();
        }
        return this._id;
    }

    public void clean() {
        if (this._uploadId != null) {
            try {
                InternalUploader.clean((Integer)this._uploadId);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to clean upload id: " + e.getMessage());
            }
        }
        if (this._isTempFile) {
            try {
                File file = new File(this._filePath);
                File parent = file.getParentFile();
                FileUtils.recursiveRemove((File)parent);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to clean temp file " + this._filePath + " : " + e.getMessage());
            }
        }
    }

    public void setTempFile(boolean isTempFile) {
        this._isTempFile = isTempFile;
    }

    public byte[] getData() {
        return this._data;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public InputStream getInputStream() {
        return this._in;
    }

    public Integer getUploadId() {
        return this._uploadId;
    }

    public void setUploadId(Integer id) {
        this._uploadId = id;
    }

    public byte[] getContent() throws IOException {
        if (this._data != null) {
            return this._data;
        }
        if (this._in != null) {
            return IOUtils.getContent((InputStream)this._in);
        }
        if (this._filePath != null) {
            return IOUtils.getContent((String)this._filePath);
        }
        return null;
    }

    public void copyOrMoveTo(File destFile) throws IOException {
        Notifier notifier = Notifier.getNotifier();
        if (notifier != null) {
            String[] params = new String[]{destFile.getCanonicalPath()};
            notifier.sendNotification("COPY_ARCHIVE_TO", params);
        }
        if (this.isSameFile(destFile)) {
            this._logger.log(Level.INFO, "Source and the destination " + destFile.getCanonicalPath() + " are the same. Skip copy or move");
            return;
        }
        if (this._uploadId != null) {
            try {
                this.move(destFile);
                return;
            }
            catch (IOException ie) {
                this._logger.log(Level.INFO, "Move operation failed: " + ie.getMessage() + ". Try to copy the file then.");
            }
        }
        this.copy(destFile);
    }

    protected void move(File destFile) throws IOException {
        this._logger.log(Level.FINE, "Try to move uploaded file " + this._filePath + " to " + destFile);
        File src = new File(this._filePath);
        boolean result = src.renameTo(destFile);
        if (!result) {
            this._logger.log(Level.INFO, "Can't move uploaded file " + this._filePath + " to " + destFile);
            this._logger.log(Level.INFO, "Maybe the uploaded file is mounted on different disk than the destination. You can try -Djava.io.tmpdir for oc4j.jar.");
            throw new IOException("Can't move uploaded file " + this._filePath + " to " + destFile);
        }
    }

    protected void copy(File destFile) throws IOException {
        FileOutputStream fout = new FileOutputStream(destFile);
        if (this._data != null) {
            this._logger.log(Level.FINE, "Write bytes to file " + destFile.getCanonicalPath());
            fout.write(this._data);
        } else if (this._in != null) {
            this._logger.log(Level.FINE, "Write input stream  to file " + destFile.getCanonicalPath());
            this.doCopy(this._in, fout);
        } else if (this._filePath != null) {
            this._logger.log(Level.FINE, "Copy file " + this._filePath + " to " + destFile.getCanonicalPath());
            FileInputStream fin = new FileInputStream(this._filePath);
            this.doCopy(fin, fout);
            fin.close();
        }
        fout.close();
    }

    private void doCopy(InputStream in, OutputStream out) throws IOException {
        int bytes;
        byte[] buf = new byte[4096];
        while ((bytes = in.read(buf)) != -1) {
            out.write(buf, 0, bytes);
        }
    }

    private boolean isSameFile(File dest) {
        if (this._filePath == null) {
            return false;
        }
        try {
            File src = new File(this._filePath);
            return src.getCanonicalPath().equals(dest.getCanonicalPath());
        }
        catch (Throwable t) {
            return false;
        }
    }
}

