/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared;

import java.io.Serializable;

public class SharedLibraryImport
implements Serializable {
    static final long serialVersionUID = -6816171650883236818L;
    private String name;
    private String minVersion;
    private String maxVersion;
    private boolean inherited;

    public SharedLibraryImport(String name, String minVersion, String maxVersion, boolean inherited) {
        this.setName(name);
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.inherited = inherited;
    }

    public SharedLibraryImport(String name) {
        this(name, null, null, false);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        try {
            SharedLibraryImport left = (SharedLibraryImport)other;
            return this.name.equals(left.name);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Shared library name may not be null");
        }
        this.name = name;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public String toString() {
        String min = this.minVersion == null ? "null" : this.minVersion;
        String max = this.maxVersion == null ? "null" : this.maxVersion;
        return "import-shared-library(" + this.name + ", " + min + ", " + max + ")";
    }
}

