/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.management.j2ee.statistics.JMSConnectionStats;
import javax.management.j2ee.statistics.JMSStats;
import javax.management.j2ee.statistics.RangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSRangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;

public class JMSStatsImpl
extends DMSStatsImpl
implements JMSStats {
    private Set m_connections = new HashSet();
    static final long serialVersionUID = 827452345875814939L;

    public JMSStatsImpl(String metricPath) {
        this(Locale.getDefault(), metricPath, null);
    }

    public JMSStatsImpl(Locale loc, String metricPath, JMSStatsImpl copyStats) {
        if (copyStats != null) {
            this.m_connections = copyStats.m_connections;
        }
        StatsLocalizationHelper localizer = new StatsLocalizationHelper(loc);
        this.addDMSStats(new DMSStatistic[]{new DMSRangeStatistic(new DMSMetric(metricPath + "/" + "activeConnections", 1, "activeConnections", localizer.getLocalizedMessage("stats_jmsstatsimpl_activeconnections"), "Connections", null, null, null, null)), new DMSRangeStatistic(new DMSMetric(metricPath + "/" + "activeHandlers", 1, "activeHandlers", localizer.getLocalizedMessage("stats_jmsstatsimpl_activehandlers"), "Handlers", null, null, null, null)), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageCommitted", 2, "messageCommitted", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagecommitted"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageRolledBack", 2, "messageRolledBack", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagerolledback"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageCount", 2, "messageCount", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagecount"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageDequeued", 2, "messageDequeued", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagedequeued"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageEnqueued", 2, "messageEnqueued", localizer.getLocalizedMessage("stats_jmsstatsimpl_messageenqueued"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageDiscarded", 2, "messageDiscarded", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagediscarded"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageExpired", 2, "messageExpired", localizer.getLocalizedMessage("stats_jmsstatsimpl_messageexpired"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messagePagedIn", 2, "messagePagedIn", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagepagedin"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messagePagedOut", 2, "messagePagedOut", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagepagedout"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageRecovered", 2, "messageRecovered", localizer.getLocalizedMessage("stats_jmsstatsimpl_messagerecovered"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "pendingMessageCount", 2, "pendingMessageCount", localizer.getLocalizedMessage("stats_jmsstatsimpl_pendingmessagecount"), "Messages"))});
        this.initStats();
    }

    public synchronized JMSConnectionStats[] getConnections() {
        return this.m_connections.toArray(new JMSConnectionStats[0]);
    }

    public synchronized void add(JMSConnectionStats stats) {
        this.m_connections.add(stats);
    }

    public synchronized void remove(JMSConnectionStats stats) {
        this.m_connections.remove(stats);
    }

    public final RangeStatistic getMessageCount() {
        return (RangeStatistic)this.getStatistic("messageCount");
    }
}

