/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic.dms;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.management.j2ee.statistics.Statistic;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Spy;
import oracle.oc4j.admin.management.shared.statistic.BoundedRangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.CountStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.RangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.StatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.StatsImpl;
import oracle.oc4j.admin.management.shared.statistic.TimeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSBoundedRangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSRangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSTimeStatistic;

public class DMSStatsImpl
extends StatsImpl
implements Serializable {
    static final long serialVersionUID = -2868140022890792725L;
    protected Vector allStatistics = new Vector();

    public DMSStatsImpl() {
    }

    public DMSStatsImpl(DMSStatistic[] statistics) {
        this.addDMSStats(statistics);
        this.initStats();
    }

    public DMSStatsImpl(Statistic[] statistics) {
        this.addJSR77Stats(statistics);
        this.initStats();
    }

    public void addDMSStats(DMSStatistic[] dmsStatistics) {
        if (dmsStatistics != null) {
            for (int i = 0; i < dmsStatistics.length; ++i) {
                DMSStatistic dmsStat = dmsStatistics[i];
                Statistic[] statistics = this.getJSR77Statistics(dmsStat);
                if (statistics == null) continue;
                for (int j = 0; j < statistics.length; ++j) {
                    Statistic stat = statistics[j];
                    if (stat == null) continue;
                    this.allStatistics.addElement(stat);
                }
            }
        }
    }

    public void addJSR77Stats(Statistic[] statistics) {
        if (statistics != null) {
            for (int i = 0; i < statistics.length; ++i) {
                Statistic stat = statistics[i];
                if (stat == null) continue;
                this.allStatistics.addElement(stat);
            }
        }
    }

    public void removeStats() {
        this.allStatistics = new Vector();
    }

    public void removeStat(String key) {
        if (this.allStatistics != null && key != null) {
            for (int i = 0; i < this.allStatistics.size(); ++i) {
                String statName;
                Statistic stat = (Statistic)this.allStatistics.elementAt(i);
                if (stat == null || (statName = stat.getName()) == null || !statName.equals(key)) continue;
                this.allStatistics.removeElementAt(i);
                this.removeStat(statName);
                break;
            }
        }
    }

    public void initStats() {
        Vector<String> statNames = new Vector<String>();
        HashMap<String, Statistic> map = new HashMap<String, Statistic>();
        if (this.allStatistics != null) {
            for (int i = 0; i < this.allStatistics.size(); ++i) {
                String statName;
                Statistic stat = (Statistic)this.allStatistics.elementAt(i);
                if (stat == null || (statName = stat.getName()) == null) continue;
                int index = 1;
                String uniqueStatName = statName;
                while (map.containsKey(uniqueStatName)) {
                    uniqueStatName = statName + "/" + index++;
                }
                statNames.add(uniqueStatName);
                map.put(uniqueStatName, stat);
            }
            Object[] statNamesArray = new String[statNames.size()];
            statNames.copyInto(statNamesArray);
            this.init((String[])statNamesArray, map);
        }
    }

    private Statistic[] getJSR77Statistics(DMSStatistic dmsStat) {
        Vector<StatisticImpl> sensorStatistics = new Vector<StatisticImpl>();
        if (dmsStat != null) {
            Sensor dmsSensor = dmsStat.getSensor();
            String statName = dmsStat.getStatName();
            String statDesc = dmsStat.getStatDesc();
            String units = dmsStat.getUnits();
            int derivation = dmsStat.getDerivation();
            if (dmsSensor != null) {
                long upTime = 0L;
                Object val = Spy.getMetricValue((String)"/JVM/upTime.value");
                if (val != null && val instanceof Long) {
                    upTime = (Long)val;
                }
                long lastSampleTime = new Date().getTime();
                if (dmsSensor instanceof PhaseEvent) {
                    if (dmsStat instanceof DMSTimeStatistic) {
                        sensorStatistics.addElement(this.createTimeStatisticImpl(dmsSensor, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime));
                    } else if (dmsStat instanceof DMSRangeStatistic) {
                        sensorStatistics.addElement(this.createRangeStatisticImpl(dmsSensor, 64, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime, ((DMSRangeStatistic)dmsStat).getHighWaterMarkMetricName(), ((DMSRangeStatistic)dmsStat).getLowWaterMarkMetricName()));
                    } else if (dmsStat instanceof DMSCountStatistic) {
                        sensorStatistics.addElement(this.createCountStatisticImpl(dmsSensor, 2, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime));
                    } else {
                        sensorStatistics.addElement(this.createTimeStatisticImpl(dmsSensor, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime));
                        sensorStatistics.addElement(this.createRangeStatisticImpl(dmsSensor, 64, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime, null, null));
                    }
                    Object[] statistics = new Statistic[sensorStatistics.size()];
                    sensorStatistics.copyInto(statistics);
                    return statistics;
                }
                if (dmsSensor instanceof Event) {
                    Statistic[] statistics = new Statistic[]{this.createCountStatisticImpl(dmsSensor, 2, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime)};
                    return statistics;
                }
                if (dmsSensor instanceof State) {
                    Statistic[] statistics = new Statistic[]{dmsStat instanceof DMSBoundedRangeStatistic ? this.createBoundedRangeStatisticImpl(dmsSensor, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime, ((DMSBoundedRangeStatistic)dmsStat).getHighWaterMarkMetricName(), ((DMSBoundedRangeStatistic)dmsStat).getLowWaterMarkMetricName(), ((DMSBoundedRangeStatistic)dmsStat).getUpperBoundMetricName(), ((DMSBoundedRangeStatistic)dmsStat).getLowerBoundMetricName()) : (dmsStat instanceof DMSRangeStatistic ? this.createRangeStatisticImpl(dmsSensor, 1, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime, ((DMSRangeStatistic)dmsStat).getHighWaterMarkMetricName(), ((DMSRangeStatistic)dmsStat).getLowWaterMarkMetricName()) : this.createCountStatisticImpl(dmsSensor, 1, statName, units, statDesc, lastSampleTime - upTime, lastSampleTime))};
                    return statistics;
                }
            }
        }
        return null;
    }

    private RangeStatisticImpl createRangeStatisticImpl(Sensor s, int derivation, String statName, String units, String statDesc, long startTime, long lastSampleTime, String highWaterMarkMetricName, String lowWaterMarkMetricName) {
        Metric m = s.getMetric(derivation);
        if (m != null) {
            long currValue = 0L;
            long highWaterMark = 0L;
            long lowWaterMark = 0L;
            Object val = m.getValue();
            if (val != null && val instanceof Number) {
                currValue = ((Number)val).longValue();
            }
            if (highWaterMarkMetricName == null) {
                if (derivation == 64) {
                    val = s.getValue(128);
                    if (val != null && val instanceof Number) {
                        highWaterMark = ((Number)val).longValue();
                    }
                } else if (derivation == 1 && (val = s.getValue(8)) != null && val instanceof Number) {
                    highWaterMark = ((Number)val).longValue();
                }
            } else {
                Object hval = Spy.getMetricValue((String)highWaterMarkMetricName);
                if (hval != null && hval instanceof Number) {
                    highWaterMark = ((Number)hval).longValue();
                }
            }
            if (lowWaterMarkMetricName == null) {
                if (derivation == 1 && (val = s.getValue(4)) != null && val instanceof Number) {
                    lowWaterMark = ((Number)val).longValue();
                }
            } else {
                Object lval = Spy.getMetricValue((String)lowWaterMarkMetricName);
                if (lval != null && lval instanceof Number) {
                    lowWaterMark = ((Number)lval).longValue();
                }
            }
            if (statName == null || statName.length() == 0) {
                statName = m.toString();
            }
            if (statDesc == null || statDesc.length() == 0) {
                statDesc = m.getDescription();
            }
            if (units == null || units.length() == 0) {
                units = this.DMSunitToJSR77unit(m.getUnits());
            }
            return new RangeStatisticImpl(statName, units, statDesc, startTime, lastSampleTime, highWaterMark, lowWaterMark, currValue);
        }
        return null;
    }

    private TimeStatisticImpl createTimeStatisticImpl(Sensor s, String statName, String units, String statDesc, long startTime, long lastSampleTime) {
        Metric m = s.getMetric(1);
        if (m != null) {
            long time = 0L;
            long numberOfOps = 0L;
            long minTime = 0L;
            long maxTime = 0L;
            Object val = s.getValue(2);
            if (val != null && val instanceof Integer) {
                numberOfOps = ((Integer)val).intValue();
            }
            if ((val = s.getValue(4)) != null && val instanceof Long) {
                minTime = (Long)val;
            }
            if ((val = s.getValue(8)) != null && val instanceof Long) {
                maxTime = (Long)val;
            }
            if ((val = m.getValue()) != null && val instanceof Long) {
                time = (Long)val;
            }
            if (statName == null || statName.length() == 0) {
                statName = m.toString();
            }
            if (statDesc == null || statDesc.length() == 0) {
                statDesc = m.getDescription();
            }
            if (units == null || units.length() == 0) {
                units = this.DMSunitToJSR77unit(m.getUnits());
            }
            return new TimeStatisticImpl(statName, units, statDesc, startTime, lastSampleTime, numberOfOps, maxTime, minTime, time);
        }
        return null;
    }

    private CountStatisticImpl createCountStatisticImpl(Sensor s, int derivation, String statName, String units, String statDesc, long startTime, long lastSampleTime) {
        long count = 0L;
        if (s != null) {
            Object val;
            Metric m = s.getMetric(derivation);
            if (m != null && (val = m.getValue()) != null && val instanceof Number) {
                count = ((Number)val).longValue();
            }
            if (statName == null || statName.length() == 0) {
                statName = m.toString();
            }
            if (statDesc == null || statDesc.length() == 0) {
                statDesc = m.getDescription();
            }
            if (units == null || statDesc.length() == 0) {
                units = this.DMSunitToJSR77unit(m.getUnits());
            }
            return new CountStatisticImpl(statName, units, statDesc, startTime, lastSampleTime, count);
        }
        return null;
    }

    private BoundedRangeStatisticImpl createBoundedRangeStatisticImpl(Sensor s, String statName, String units, String statDesc, long startTime, long lastSampleTime, String highWaterMarkMetricName, String lowWaterMarkMetricName, String upperBoundMetricName, String lowerBoundMetricName) {
        long currValue = 0L;
        long highWaterMark = 0L;
        long lowWaterMark = 0L;
        if (s != null) {
            Object val;
            Metric m = s.getMetric(1);
            if (m != null) {
                Object val2 = m.getValue();
                if (val2 != null && val2 instanceof Number) {
                    currValue = ((Number)val2).longValue();
                }
                if (highWaterMarkMetricName == null) {
                    val2 = s.getValue(8);
                    if (val2 != null && val2 instanceof Number) {
                        highWaterMark = ((Number)val2).longValue();
                    }
                } else {
                    Object hval = Spy.getMetricValue((String)highWaterMarkMetricName);
                    if (hval != null && hval instanceof Number) {
                        highWaterMark = ((Number)hval).longValue();
                    }
                }
                if (lowWaterMarkMetricName == null) {
                    val2 = s.getValue(4);
                    if (val2 != null && val2 instanceof Number) {
                        lowWaterMark = ((Number)val2).longValue();
                    }
                } else {
                    Object lval = Spy.getMetricValue((String)lowWaterMarkMetricName);
                    if (lval != null && lval instanceof Number) {
                        lowWaterMark = ((Number)lval).longValue();
                    }
                }
            }
            if (statName == null || statName.length() == 0) {
                statName = m.toString();
            }
            if (statDesc == null || statDesc.length() == 0) {
                statDesc = m.getDescription();
            }
            if (units == null || statDesc.length() == 0) {
                units = this.DMSunitToJSR77unit(m.getUnits());
            }
            if (statDesc == null || statDesc.length() == 0) {
                statDesc = "Number of operations";
            }
            if (units == null) {
                units = "OPS";
            }
            long upperBoundMetricValue = 0L;
            long lowerBoundMetricValue = 0L;
            if (upperBoundMetricName != null && (val = Spy.getMetricValue((String)upperBoundMetricName)) != null && val instanceof Number) {
                upperBoundMetricValue = ((Number)val).longValue();
            }
            if (lowerBoundMetricName != null && (val = Spy.getMetricValue((String)lowerBoundMetricName)) != null && val instanceof Number) {
                lowerBoundMetricValue = ((Number)val).longValue();
            }
            return new BoundedRangeStatisticImpl(statName, units, statDesc, startTime, lastSampleTime, highWaterMark, lowWaterMark, currValue, upperBoundMetricValue, lowerBoundMetricValue);
        }
        return null;
    }

    protected String DMSunitToJSR77unit(String unit) {
        String newUnit = unit;
        if (unit != null && unit.equalsIgnoreCase("msecs")) {
            newUnit = "MILLISECOND";
        }
        return newUnit;
    }
}

