/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Escape;
import com.sybase.jdbc2.jdbc.SybStatement;
import java.sql.SQLException;

class EscapeTokenizer {
    static final int START = 1;
    static final int IN_SINGLE_QUOTES = 2;
    static final int IN_DOUBLE_QUOTES = 3;
    private StringBuffer _text;
    private char[] _textCharBuf;
    private int _nextIndex;
    private SybStatement _stmt;
    private int _mark;
    private boolean _openCursor = false;
    private static final String SQL_DELIMITERS = " %&'()*+,-./:;<=>?[|\t\n";

    EscapeTokenizer(SybStatement sybStatement, String string) {
        this.updateText(new StringBuffer(string));
        this._stmt = sybStatement;
        this._nextIndex = 0;
        this._stmt._type = 0;
        this._stmt._setEnd = 0;
    }

    /*
     * Unable to fully structure code
     */
    protected Object next() throws SQLException {
        block43: {
            block44: {
                block42: {
                    var2_1 = 1;
                    if (this._nextIndex == 0) {
                        var4_2 = this.nextWord(0);
                        if ("exec".equalsIgnoreCase(var4_2)) {
                            this._nextIndex = this._text.length();
                            this._stmt._type = 1;
                            return new Escape(this._text.toString(), 1);
                        }
                        if ("select".equalsIgnoreCase(var4_2)) {
                            this._stmt._type = 2;
                        } else if ("delete".equalsIgnoreCase(var4_2)) {
                            this._stmt._type = 4;
                            var4_2 = this.nextWord(-1);
                            if (var4_2 != null && var4_2.equalsIgnoreCase("from")) {
                                var4_2 = this.nextWord(-1);
                            }
                            this._stmt._table = this.completeTableName(var4_2);
                        } else if ("update".equalsIgnoreCase(var4_2)) {
                            this._stmt._type = 8;
                            var4_2 = this.nextWord(-1);
                            if ((var4_2 = this.completeTableName(var4_2)) != null) {
                                this._stmt._setStart = this._mark - 1;
                            }
                            this._stmt._table = var4_2;
                        }
                    }
                    if (this._nextIndex < this._text.length()) break block42;
                    var1_5 = null;
                    break block43;
                }
                if (this._text.charAt(this._nextIndex) != '{') break block44;
                var4_3 = -1;
                var5_6 = this._nextIndex + 1;
                block15: while (var5_6 < this._text.length()) {
                    var3_8 = this._text.charAt(var5_6);
                    switch (var3_8) {
                        case '\"': 
                        case '\'': {
                            var2_1 = EscapeTokenizer.nextState(var2_1, var3_8);
                            ** GOTO lbl59
                        }
                        case '}': {
                            if (var2_1 == 1) {
                                var4_3 = var5_6;
                                break block15;
                            }
                            ** GOTO lbl59
                        }
                        case '{': {
                            if (var2_1 == 1) {
                                var6_10 = EscapeTokenizer.matchClosingChar(var3_8, this._text, var5_6) + 1;
                                if (var6_10 == 0) {
                                    ErrorMessage.raiseError("JZ0S8", this._text.toString());
                                }
                                var7_13 = this._stmt.processEscapes(new String(this._textCharBuf, var5_6, var6_10 - var5_6));
                                var8_14 = var7_13.length();
                                var9_15 = var5_6 + var8_14 + this._textCharBuf.length - var6_10;
                                var10_16 = new StringBuffer(var9_15);
                                var10_16.append(this._textCharBuf, 0, var5_6);
                                var10_16.append((String)var7_13);
                                var10_16.append(this._textCharBuf, var6_10, this._textCharBuf.length - var6_10);
                                var5_6 += var8_14 - 1;
                                this.updateText(var10_16);
                            }
                        }
lbl59:
                        // 6 sources

                        default: {
                            ++var5_6;
                        }
                    }
                }
                if (var4_3 == -1) {
                    ErrorMessage.raiseError("JZ0S8", this._text.toString());
                }
                var6_11 = new String(this._textCharBuf, this._nextIndex, var4_3 + 1 - this._nextIndex);
                var1_5 = var7_13 = new Escape(var6_11);
                this._stmt._setEnd -= var6_11.length() - var7_13.getBody().length();
                switch (var7_13.getType()) {
                    case 4: {
                        if (this._stmt._context._conn._props.getBoolean(49)) break;
                        this._stmt._setEnd += "1970-1-1 ".length();
                        break;
                    }
                    case 3: {
                        this._stmt._setEnd += "00:00:00 ".length();
                    }
                }
                this._nextIndex = var4_3 + 1;
                break block43;
            }
            var4_4 = -1;
            var5_7 = this._nextIndex;
            block16: while (var5_7 < this._text.length()) {
                var3_9 = this._text.charAt(var5_7);
                switch (var3_9) {
                    case '\"': 
                    case '\'': {
                        var2_1 = EscapeTokenizer.nextState(var2_1, var3_9);
                        ** GOTO lbl114
                    }
                    case '{': {
                        if (var2_1 == 1) {
                            var4_4 = var5_7;
                            break block16;
                        }
                        ** GOTO lbl114
                    }
                    case 'F': 
                    case 'f': {
                        if (var2_1 == 1 && this._stmt._type == 2) {
                            var6_12 = this.nextWord(var5_7);
                            if ("from".equalsIgnoreCase(var6_12)) {
                                var6_12 = this.nextWord(-1);
                                this._stmt._table = this.completeTableName(var6_12);
                                if (this._stmt._cursor != null) {
                                    this._stmt._cursor.setTable(this._stmt._table);
                                }
                                if (!this._stmt._context._conn._props.getBoolean(33) || this._stmt._cursor != null) {
                                    this._stmt._type |= 4096;
                                }
                            } else if (this._stmt._context._conn._props.getBoolean(33) && "for".equalsIgnoreCase(var6_12)) {
                                var6_12 = this.nextWord(-1);
                                if ("update".equalsIgnoreCase(var6_12)) {
                                    this._openCursor = true;
                                }
                                this._stmt._type |= 4096;
                            }
                        }
                        ** GOTO lbl114
                    }
                    case 'W': 
                    case 'w': {
                        if (var2_1 == 1) {
                            if ((this._stmt._type & (4 | 8)) != 0 && "where".equalsIgnoreCase(var6_12 = this.nextWord(var5_7)) && "current".equalsIgnoreCase(var6_12 = this.nextWord(-1)) && "of".equalsIgnoreCase(var6_12 = this.nextWord(-1))) {
                                this._stmt._type |= 4096;
                                this._stmt._setEnd += var5_7 - 1;
                            }
                        }
                    }
lbl114:
                    // 10 sources

                    default: {
                        ++var5_7;
                    }
                }
            }
            if (var4_4 == -1) {
                var4_4 = this._text.length();
            }
            var1_5 = new String(this._textCharBuf, this._nextIndex, var4_4 - this._nextIndex);
            this._nextIndex = var4_4;
        }
        if (this._openCursor) {
            this._stmt.checkCursor(false);
            this._stmt._cursor.getName();
            this._openCursor = false;
        }
        return var1_5;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int matchClosingChar(char c, StringBuffer stringBuffer, int n) {
        int n2 = 1;
        int n3 = -1;
        int n4 = n + 1;
        while (n4 < stringBuffer.length()) {
            char c2 = stringBuffer.charAt(n4);
            switch (c2) {
                case '\"': 
                case '\'': {
                    n2 = EscapeTokenizer.nextState(n2, c2);
                    break;
                }
                case ')': 
                case '}': {
                    if (n2 != 1) break;
                    if (c2 == '}') {
                        if (c == '{') return n4;
                    }
                    if (c2 != ')' || c != '(') break;
                    return n4;
                }
                case '(': 
                case '{': {
                    if (n2 != 1 || c2 != c) break;
                    n4 = EscapeTokenizer.matchClosingChar(c2, stringBuffer, n4);
                }
            }
            ++n4;
        }
        return n3;
    }

    protected static int nextState(int n, char c) {
        int n2 = n;
        switch (c) {
            case '\'': {
                if (n == 2) {
                    n2 = 1;
                    break;
                }
                if (n != 1) break;
                n2 = 2;
                break;
            }
            case '\"': {
                if (n == 3) {
                    n2 = 1;
                    break;
                }
                if (n != 1) break;
                n2 = 3;
                break;
            }
        }
        return n2;
    }

    private void updateText(StringBuffer stringBuffer) {
        this._text = stringBuffer;
        int n = stringBuffer.length();
        this._textCharBuf = new char[n];
        if (n > 0) {
            this._text.getChars(0, n, this._textCharBuf, 0);
        }
    }

    private String nextWord(int n) {
        if (n >= 0) {
            this._mark = n;
        }
        String string = null;
        int n2 = this._text.length();
        while (this._mark < n2 && SQL_DELIMITERS.indexOf(this._text.charAt(this._mark)) != -1) {
            ++this._mark;
        }
        if (this._mark >= n2) {
            string = null;
        } else {
            if (this._mark > 0 && this._text.charAt(this._mark) == '\"') {
                n2 = this._text.toString().indexOf(34, this._mark + 1) + 1;
            } else {
                int n3 = this._mark;
                while (n3 < n2) {
                    if (SQL_DELIMITERS.indexOf(this._text.charAt(n3)) != -1) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            if (n2 > this._mark) {
                string = String.copyValueOf(this._textCharBuf, this._mark, n2 - this._mark);
                this._mark = n2 + 1;
                n2 = this._text.length();
            }
        }
        return string;
    }

    private String completeTableName(String string) {
        String string2 = string;
        int n = 0;
        while (n < 2) {
            if (this._mark < this._text.length()) {
                if (this._text.charAt(this._mark - 1) != '.') break;
                if (this._text.charAt(this._mark) == '.') {
                    string2 = string2 + ".";
                    ++n;
                }
                string2 = string2 + "." + this.nextWord(-1);
            }
            ++n;
        }
        return string2;
    }
}

