/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MdaManager;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybCallableStatementCopy;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.jdbc.SybPreparedStatementCopy;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SybConnection
implements com.sybase.jdbcx.SybConnection {
    static final int TRANSACTION_NONE = 0;
    static final int TRANSACTION_READ_UNCOMMITTED = 1;
    static final int TRANSACTION_READ_COMMITTED = 2;
    static final int TRANSACTION_REPEATABLE_READ = 4;
    static final int TRANSACTION_SERIALIZABLE = 8;
    private MdaManager _mda = null;
    protected SybDatabaseMetaData _sybDBMD = null;
    private SQLWarning _warning = null;
    protected Protocol _protocol;
    protected ProtocolContext _pc;
    private ProtocolContext _sharedPc;
    private CacheManager _sharedCm;
    protected SybProperty _props;
    protected boolean _dynamicPrepare;
    protected String _dbName;
    protected String _dbProductName;
    protected String _dbProductVersion;
    protected String _url = null;
    private int _loginTimeout;
    private long _loginStartTime;
    private int _state = 0;
    private int _dynStmtNum = 100;
    private Hashtable _cursors;
    private Vector _hostPortList = null;
    private Vector _secondaryHostPortList = null;
    private int _haLoginStatus = 0;
    private int _haState = -1;
    private boolean _wasConnected = false;
    private String _currentHostPort;
    private boolean _inClose = false;
    private boolean _duringConnect = false;

    public SybConnection(SybUrlProvider sybUrlProvider, String string) throws SQLException {
        this(sybUrlProvider, string, DriverManager.getLoginTimeout());
    }

    protected SybConnection(SybUrlProvider sybUrlProvider, String string, int n) throws SQLException {
        this._url = string;
        this._protocol = sybUrlProvider.getProtocol();
        this._props = sybUrlProvider.getSybProperty();
        this._hostPortList = sybUrlProvider.getHostPortList();
        this._dbName = sybUrlProvider.getDatabaseName();
        this._dynamicPrepare = this._props.getBoolean(25);
        this._loginTimeout = n * 1000;
        this._haState = -1;
        this._duringConnect = true;
        try {
            block8: {
                try {
                    if (this._props.getBoolean(34)) {
                        String string2 = this._props.getString(45);
                        if (string2 != null) {
                            this._secondaryHostPortList = new Vector();
                            this._secondaryHostPortList.addElement(string2);
                        } else {
                            this._secondaryHostPortList = sybUrlProvider.getSecondaryHostPortList();
                        }
                        if (this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) {
                            ErrorMessage.raiseError("JZ0F1");
                        }
                        this.setHALoginStatus(1);
                        this.handleHAFailover();
                        break block8;
                    }
                    this.regularConnect();
                }
                catch (SQLException sQLException) {
                    this._protocol.abort();
                    throw sQLException;
                }
            }
            Object var6_6 = null;
            this._duringConnect = false;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._duringConnect = false;
            throw throwable;
        }
    }

    private void regularConnect() throws SQLException {
        if (this._dynamicPrepare && this._props.getBoolean(15)) {
            this.handleSQLE(ErrorMessage.createWarning("010PO"));
        }
        this.tryLogin(this._hostPortList);
    }

    private void tryLogin(Vector vector) throws SQLException {
        boolean bl = true;
        boolean bl2 = this._props.getBoolean(26);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this._loginStartTime = System.currentTimeMillis();
            try {
                String string;
                this._currentHostPort = string = (String)enumeration.nextElement();
                this._protocol.login(string, this._props, this, true);
                break;
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
                break;
            }
            catch (SQLException sQLException) {
                if (bl2 && enumeration.hasMoreElements()) {
                    this.chainWarnings(sQLException);
                    try {
                        ErrorMessage.raiseWarning("010SQ");
                    }
                    catch (SQLWarning sQLWarning) {
                        this.chainWarnings(sQLWarning);
                    }
                    continue;
                }
                if (this._props.getBoolean(34) && ("JZ006".equals(sQLException.getSQLState()) || "JZ00L".equals(sQLException.getSQLState())) && this.getHAState() != 1 && this.getHAState() != 6) {
                    this.handleHAFailover();
                    bl = false;
                    break;
                }
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    this.handleSQLE(sQLException);
                    continue;
                }
                this.markDead(false);
                this.handleSQLE(sQLException);
            }
        }
        if (bl) {
            this._state = 1;
            this._pc = this.initProtocol();
            long l = this.getLoginTimeRemaining();
            if (l < 0L) {
                ErrorMessage.raiseError("JZ00M");
            }
            try {
                this.init();
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void init() throws SQLException {
        block65: {
            block63: {
                var1_1 = null;
                var2_2 = this._props;
                var3_3 = this._dbName;
                var4_4 = false;
                if (var2_2.getBoolean(6)) {
                    try {
                        this.checkMDA(this._pc);
                        this.determineCharset();
                        var4_4 = true;
                        this._protocol.setOption(null, 11, false);
                        if (var3_3 == null || var3_3.length() <= 0) ** GOTO lbl153
                        try {
                            this.setCatalog(var3_3);
                        }
                        catch (SQLException var5_5) {
                            this.checkForHAException(var5_5);
                            this.handleSQLE(ErrorMessage.createWarning("010DF", var5_5.getMessage()));
                        }
                    }
                    catch (Exception var5_6) {
                        this.checkForHAException(var5_6);
                        this.checkUnsupportedCharsetException(var5_6);
                        this.checkForLoginTimeout(var5_6);
                        if (!var4_4) {
                            try {
                                this.determineCharset();
                            }
                            catch (SQLException var6_9) {
                                this.checkUnsupportedCharsetException(var6_9);
                                this.checkForHAException(var6_9);
                            }
                        }
                        try {
                            ErrorMessage.raiseWarning("010MX", var5_6.toString());
                        }
                        catch (SQLWarning var6_10) {
                            block59: {
                                block58: {
                                    if (var3_3 == null || var3_3.length() <= 0) break block58;
                                    var1_1 = this.createStatement();
                                    var1_1.executeUpdate("use " + var3_3);
                                }
                                var9_13 = null;
                                if (var1_1 == null) break block59;
                                try {
                                    var1_1.close();
                                    var1_1 = null;
                                }
                                catch (SQLException var10_16) {
                                    var1_1 = null;
                                    this.handleSQLE(var10_16);
                                }
                                catch (RuntimeException var11_19) {
                                    var1_1 = null;
                                    throw var11_19;
                                }
                            }
                            this.handleSQLE(var6_10);
                            {
                                catch (SQLException var7_22) {
                                    this.checkForHAException(var7_22);
                                    this.handleSQLE(ErrorMessage.createWarning("010UF", var7_22.getMessage()));
                                    var9_13 = null;
                                    if (var1_1 != null) {
                                        try {
                                            var1_1.close();
                                            var1_1 = null;
                                        }
                                        catch (SQLException var10_17) {
                                            var1_1 = null;
                                            this.handleSQLE(var10_17);
                                        }
                                        catch (RuntimeException var11_20) {
                                            var1_1 = null;
                                            throw var11_20;
                                        }
                                    }
                                    this.handleSQLE(var6_10);
                                }
                            }
                            catch (Throwable var8_24) {
                                var9_14 = null;
                                if (var1_1 != null) {
                                    try {
                                        var1_1.close();
                                        var1_1 = null;
                                    }
                                    catch (SQLException var10_18) {
                                        var1_1 = null;
                                        this.handleSQLE(var10_18);
                                    }
                                    catch (RuntimeException var11_21) {
                                        var1_1 = null;
                                        throw var11_21;
                                    }
                                }
                                this.handleSQLE(var6_10);
                                throw var8_24;
                            }
                        }
                    }
                } else {
                    this.determineCharset();
                    try {
                        block62: {
                            if (var3_3 == null || var3_3.length() <= 0) break block62;
                            var1_1 = this.createStatement();
                            var1_1.executeUpdate("use " + var3_3);
                        }
                        var13_26 = null;
                        ** if (var1_1 == null) goto lbl-1000
                    }
                    catch (Throwable var12_35) {
                        var13_28 = null;
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                                var1_1 = null;
                            }
                            catch (SQLException var14_31) {
                                var1_1 = null;
                                this.handleSQLE(var14_31);
                            }
                            catch (RuntimeException var15_34) {
                                var1_1 = null;
                                throw var15_34;
                            }
                        }
                        throw var12_35;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var1_1.close();
                            var1_1 = null;
                        }
                        catch (SQLException var14_29) {
                            var1_1 = null;
                            this.handleSQLE(var14_29);
                        }
                        catch (RuntimeException var15_32) {
                            var1_1 = null;
                            throw var15_32;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block63;
                        catch (SQLException var5_7) {
                            this.checkForHAException(var5_7);
                            this.handleSQLE(ErrorMessage.createWarning("010SK", var5_7.getMessage()));
                            var13_27 = null;
                            if (var1_1 == null) break block63;
                            try {
                                var1_1.close();
                                var1_1 = null;
                            }
                            catch (SQLException var14_30) {
                                var1_1 = null;
                                this.handleSQLE(var14_30);
                            }
                            catch (RuntimeException var15_33) {
                                var1_1 = null;
                                throw var15_33;
                            }
                        }
                    }
                }
            }
            var5_8 = var2_2.getString(18);
            if (var5_8 != null && var5_8.length() > 0) {
                try {
                    var1_1 = this.createStatement();
                    var1_1.executeUpdate(var5_8);
                    var17_36 = null;
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (Throwable var16_45) {
                    var17_38 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                            var1_1 = null;
                        }
                        catch (SQLException var18_41) {
                            var1_1 = null;
                            this.handleSQLE(var18_41);
                        }
                        catch (RuntimeException var19_44) {
                            var1_1 = null;
                            throw var19_44;
                        }
                    }
                    throw var16_45;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                        var1_1 = null;
                    }
                    catch (SQLException var18_39) {
                        var1_1 = null;
                        this.handleSQLE(var18_39);
                    }
                    catch (RuntimeException var19_42) {
                        var1_1 = null;
                        throw var19_42;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    break block65;
                    catch (SQLException var6_12) {
                        this.handleSQLE(var6_12);
                        var17_37 = null;
                        if (var1_1 == null) break block65;
                        try {
                            var1_1.close();
                            var1_1 = null;
                        }
                        catch (SQLException var18_40) {
                            var1_1 = null;
                            this.handleSQLE(var18_40);
                        }
                        catch (RuntimeException var19_43) {
                            var1_1 = null;
                            throw var19_43;
                        }
                    }
                }
            }
        }
        this._state = 0;
        var6_11 = (String[])this._props.getObject(38);
        if (var6_11 != null) {
            var7_23 = this._protocol.getClassLoader();
            if (var7_23 == null) {
                ErrorMessage.raiseError("JZ0CL");
            } else {
                try {
                    var7_23.preloadJars(var6_11);
                }
                catch (SQLException var8_25) {
                    this.chainWarnings(var8_25);
                    try {
                        ErrorMessage.raiseWarning("010PF");
                    }
                    catch (SQLWarning var9_15) {
                        this.chainWarnings(var9_15);
                    }
                }
            }
        }
    }

    public boolean okToThrowLoginTimeoutException() {
        switch (this._haState) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        return this._duringConnect;
    }

    protected long getLoginTimeRemaining() {
        if (this._loginTimeout == 0) {
            return 0L;
        }
        long l = 0L;
        switch (this._haState) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 0L;
            }
        }
        l = (long)this._loginTimeout - (System.currentTimeMillis() - this._loginStartTime);
        if (l == 0L) {
            l = -1L;
        }
        return l;
    }

    private void determineCharset() throws SQLException {
        String string = null;
        if (this._props.getString(8) == null) {
            string = this.getDefaultServerCharset();
            if (string == null) {
                string = "ascii_7";
                try {
                    ErrorMessage.raiseWarning("010TQ");
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
            this._protocol.setOption(null, 6, string);
        }
    }

    public void checkForHAException(Exception exception) throws SQLException {
        SQLException sQLException;
        if (exception instanceof SQLException && "JZ0F2".equals((sQLException = (SQLException)exception).getSQLState())) {
            throw sQLException;
        }
    }

    public void checkForLoginTimeout(Exception exception) throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        if (exception instanceof SQLException) {
            sQLException = (SQLException)exception;
            while (sQLException != null) {
                if ("JZ00M".equals(sQLException.getSQLState())) {
                    bl = true;
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException2) {}
                    break;
                }
                sQLException = sQLException.getNextException();
            }
            if (bl) {
                throw sQLException;
            }
        }
    }

    public void checkUnsupportedCharsetException(Exception exception) throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        if (exception instanceof SQLException) {
            sQLException = (SQLException)exception;
            while (sQLException != null) {
                if ("JZ0IB".equals(sQLException.getSQLState())) {
                    bl = true;
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException2) {}
                    break;
                }
                sQLException = sQLException.getNextException();
            }
            if (bl) {
                throw sQLException;
            }
        }
    }

    public Statement createStatement() throws SQLException {
        this.checkConnection();
        SybStatement sybStatement = new SybStatement(this.initProtocol());
        return sybStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.prepareStatement(string, this._dynamicPrepare);
        }
        catch (SQLException sQLException) {
            if (this._dynamicPrepare) {
                return this.prepareStatement(string, false);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        this.checkConnection();
        SybPreparedStatement sybPreparedStatement = bl ? new SybPreparedStatement(this.initProtocol(), string, this._dynStmtNum++) : new SybPreparedStatement(this.initProtocol(), string);
        return sybPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkConnection();
        SybCallableStatement sybCallableStatement = new SybCallableStatement(this.initProtocol(), string);
        return sybCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkConnection();
        SybStatement sybStatement = (SybStatement)this.createStatement();
        return sybStatement.processEscapes(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 1, bl);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        boolean bl = false;
        try {
            bl = this._protocol.getBoolOption(null, 1);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return bl;
    }

    public void commit() throws SQLException {
        this.checkConnection();
        try {
            this._protocol.endTransaction(true);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void rollback() throws SQLException {
        this.checkConnection();
        try {
            this._protocol.endTransaction(false);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void close() throws SQLException {
        this._inClose = true;
        this.checkConnection();
        if (this._cursors != null) {
            Enumeration enumeration = this._cursors.keys();
            try {
                while (true) {
                    String string = (String)enumeration.nextElement();
                    this._cursors.remove(string);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.markDead(false);
        try {
            try {
                this._protocol.logout();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                Object var4_6 = null;
                this._pc.drop();
                if (this._sharedPc != null) {
                    this._sharedPc.drop();
                }
                this._inClose = false;
            }
            Object var4_5 = null;
            this._pc.drop();
            if (this._sharedPc != null) {
                this._sharedPc.drop();
            }
            this._inClose = false;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this._pc.drop();
            if (this._sharedPc != null) {
                this._sharedPc.drop();
            }
            this._inClose = false;
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public boolean isClosed() throws SQLException {
        block18: {
            String string = this._props.getString(36);
            if (this._state != 4 && !"INTERNAL".equals(string)) {
                Statement statement;
                CallableStatement callableStatement;
                block17: {
                    callableStatement = null;
                    statement = null;
                    if (string == null) {
                        callableStatement = this.prepareCall("{call sp_mda(?,?)}");
                        callableStatement.setInt(1, 0);
                        callableStatement.setInt(2, 7);
                        callableStatement.executeQuery();
                        break block17;
                    }
                    statement = this.createStatement();
                    statement.executeQuery(string);
                }
                Object var6_4 = null;
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                        callableStatement = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    break block18;
                }
                catch (SQLException sQLException) {}
                break block18;
                {
                    catch (SQLException sQLException) {
                        if ("JZ0F2".equals(sQLException.getSQLState())) {
                            throw sQLException;
                        }
                        Object var6_5 = null;
                        try {
                            if (callableStatement != null) {
                                callableStatement.close();
                                callableStatement = null;
                            }
                            if (statement != null) {
                                statement.close();
                                statement = null;
                            }
                            break block18;
                        }
                        catch (SQLException sQLException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        if (callableStatement != null) {
                            callableStatement.close();
                            callableStatement = null;
                        }
                        if (statement != null) {
                            statement.close();
                            statement = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return this._state == 4;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkConnection();
        this.checkDBMD();
        return this._sybDBMD;
    }

    protected String getDatabaseProductName() throws SQLException {
        return this._dbProductName;
    }

    protected synchronized void setDatabaseProductName(String string) throws SQLException {
        this._dbProductName = string;
    }

    protected String getDatabaseProductVersion() throws SQLException {
        return this._dbProductVersion;
    }

    protected synchronized void setDatabaseProductVersion(String string) throws SQLException {
        this._dbProductVersion = string;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 3, bl);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkConnection();
        boolean bl = false;
        try {
            bl = this._protocol.getBoolOption(null, 3);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return bl;
    }

    public void setCatalog(String string) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 9, string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public String getCatalog() throws SQLException {
        this.checkConnection();
        String string = null;
        try {
            string = this._protocol.getStringOption(null, 9, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 2, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkConnection();
        int n = -1;
        try {
            n = this._protocol.getIntOption(null, 2);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    public SQLWarning getWarningsNoCheckConnection() throws SQLException {
        return this._warning;
    }

    public void clearWarnings() throws SQLException {
        this.checkConnection();
        this._warning = null;
    }

    public String getSessionID() throws SQLException {
        return this._protocol.getStringOption(null, 5, null);
    }

    public void regWatch(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.makeEventContext(string, sybEventHandler, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void regNoWatch(String string) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.killEventContext(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public Capture createCapture() throws SQLException {
        return (Capture)this._protocol.getObjectOption(this._pc, 8);
    }

    public Object getEndpoint() throws SQLException {
        return this._protocol.getObjectOption(this._pc, 7);
    }

    public void cancel() throws SQLException {
        this._protocol.cancel(this._pc, true);
    }

    public void markDead() {
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void markDead(boolean bl) throws SQLException {
        this._state = 4;
        if (bl) {
            this.checkConnection();
        }
    }

    public void markDeadTryHA() throws IOException {
        boolean bl = false;
        try {
            bl = this._props.getBoolean(34);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                ErrorMessage.raiseHAException("JZ0F2");
            }
            IOException iOException = new IOException(sQLException.getMessage());
            ErrorMessage.raiseSybConnectionDeadException(iOException);
        }
        if (bl) {
            ErrorMessage.raiseHAException("JZ0F2");
        }
    }

    public String getDefaultServerCharset() throws SQLException {
        this.checkConnection();
        String string = null;
        try {
            string = this._protocol.getStringOption(null, 6, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        sQLWarning = !bl ? (SQLWarning)sQLException : SybConnection.getAllTheWarnings(sQLException);
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl && this._props != null) {
            throw sQLException;
        }
    }

    public int getHALoginStatus() {
        return this._haLoginStatus;
    }

    protected int getHAState() {
        return this._haState;
    }

    protected void setHAState(int n) {
        this._haState = n;
    }

    protected void setHALoginStatus(int n) {
        this._haLoginStatus = n;
    }

    protected boolean isDead() {
        return this._state == 4;
    }

    public static SQLWarning getAllTheWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            if (sQLException2 instanceof SQLWarning) {
                if (sQLWarning == null) {
                    sQLWarning = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
                } else {
                    sQLWarning.setNextWarning(new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode()));
                }
            }
            sQLException2 = sQLException2.getNextException();
        }
        return sQLWarning;
    }

    public static SQLWarning convertToWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            SQLWarning sQLWarning2 = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
            } else {
                sQLWarning.setNextWarning(sQLWarning2);
            }
            sQLException2 = sQLException2.getNextException();
        }
        return sQLWarning;
    }

    public void chainWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = SybConnection.convertToWarnings(sQLException);
        if (this._warning == null) {
            this._warning = sQLWarning;
        } else {
            this._warning.setNextWarning(sQLWarning);
        }
    }

    public static boolean thisChainHasAnException(SQLException sQLException) {
        boolean bl = false;
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            if (!(sQLException2 instanceof SQLWarning)) {
                bl = true;
                break;
            }
            sQLException2 = sQLException2.getNextException();
        }
        return bl;
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._pc.setMessageHandler(sybMessageHandler);
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._pc.getMessageHandler();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        SybStatement sybStatement = (SybStatement)this.createStatement();
        sybStatement.setResultSetParams(n, n2);
        return sybStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this.prepareStatement(string);
        sybPreparedStatement.setResultSetParams(n, n2);
        return sybPreparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        SybCallableStatement sybCallableStatement = (SybCallableStatement)this.prepareCall(string);
        sybCallableStatement.setResultSetParams(n, n2);
        return sybCallableStatement;
    }

    public Map getTypeMap() throws SQLException {
        Debug.notImplemented(this, "getTypeMap()");
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        Debug.notImplemented(this, "setTypeMap(java.util.Map)");
    }

    protected ProtocolContext initProtocol() throws SQLException {
        ProtocolContext protocolContext = this._protocol.getProtocolContext(this._props);
        protocolContext._protocol = this._protocol;
        protocolContext._conn = this;
        if (this._pc != null) {
            protocolContext._msgHandler = this._pc._msgHandler;
        }
        return protocolContext;
    }

    public MdaManager getMDA(ProtocolContext protocolContext) throws SQLException {
        this.checkMDA(protocolContext);
        return this._mda;
    }

    protected void handleHAFailover() throws SQLException {
        this.nextHAState();
        switch (this.getHAState()) {
            case 0: {
                this.setHALoginStatus(1);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 4: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 5: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 1: {
                this.setHALoginStatus(5);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 6: {
                this.setHALoginStatus(7);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
        }
    }

    private void nextHAState() {
        if (!this._wasConnected) {
            switch (this._haState) {
                case -1: {
                    this._haState = 0;
                    break;
                }
                case 0: {
                    this._haState = 1;
                    break;
                }
            }
        } else {
            switch (this._haState) {
                case 2: {
                    this._haState = 4;
                    break;
                }
                case 4: 
                case 5: {
                    this._haState = 6;
                    break;
                }
                case 3: {
                    this._haState = 5;
                    break;
                }
            }
        }
    }

    protected void checkConnection() throws SQLException {
        if (this._state == 4) {
            if (this._props.getBoolean(34) && !this._inClose && this.getHAState() != 1 && this.getHAState() != 6) {
                this._state = 0;
                this.handleHAFailover();
            } else {
                this._protocol.abort();
                ErrorMessage.raiseError("JZ0C0");
            }
        }
    }

    protected ResultSet getCursorResultSet(String string) {
        if (this._cursors == null) {
            return null;
        }
        return (ResultSet)this._cursors.get(string);
    }

    protected void addCursorResultSet(String string, ResultSet resultSet) {
        if (this._cursors == null) {
            this._cursors = new Hashtable();
        }
        this._cursors.put(string, resultSet);
    }

    public void removeCursorResultSet(String string) {
        if (this._cursors == null) {
            return;
        }
        try {
            this._cursors.remove(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public com.sybase.jdbcx.SybPreparedStatement copyPreparedStatement(com.sybase.jdbcx.SybPreparedStatement sybPreparedStatement) throws SQLException {
        SybPreparedStatementCopy sybPreparedStatementCopy = new SybPreparedStatementCopy(this.getSharedProtocolContext(), (SybPreparedStatement)sybPreparedStatement);
        sybPreparedStatementCopy.setMaxRows(0);
        return sybPreparedStatementCopy;
    }

    public com.sybase.jdbcx.SybCallableStatement copyCallableStatement(com.sybase.jdbcx.SybCallableStatement sybCallableStatement) throws SQLException {
        SybCallableStatementCopy sybCallableStatementCopy = new SybCallableStatementCopy(this.getSharedProtocolContext(), (SybCallableStatement)sybCallableStatement);
        sybCallableStatementCopy.setMaxRows(0);
        return sybCallableStatementCopy;
    }

    protected synchronized ProtocolContext getSharedProtocolContext() throws SQLException {
        if (this._sharedPc == null) {
            this._sharedPc = this.initProtocol();
        }
        return this._sharedPc;
    }

    protected synchronized CacheManager getSharedCacheManager() {
        return this._sharedCm;
    }

    protected synchronized void setSharedCacheManager(CacheManager cacheManager) {
        this._sharedCm = cacheManager;
    }

    private void checkMDA(ProtocolContext protocolContext) throws SQLException {
        block7: {
            if (this._mda == null) {
                try {
                    if (protocolContext == null) {
                        SybConnection sybConnection = this;
                        synchronized (sybConnection) {
                            this._mda = new MdaManager(this, this._pc);
                            break block7;
                        }
                    }
                    this._mda = new MdaManager(this, protocolContext);
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
        }
    }

    private void checkDBMD() throws SQLException {
        this.checkMDA(null);
        if (this._sybDBMD == null) {
            this._sybDBMD = new SybDatabaseMetaData(this);
        }
    }
}

