/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import java.io.IOException;
import java.io.InputStream;

public class UnicharToAsciiInputStream
extends RawInputStream {
    private int _bytesRemainingInStream;
    private int[] _bytes;
    private int _returnVal;
    private boolean _isBigEndian;

    public UnicharToAsciiInputStream(InputStream inputStream, int n, int n2, boolean bl, CacheManager cacheManager) throws IOException {
        super(inputStream, n, n2, cacheManager);
        this._bytesRemainingInStream = n2;
        this._bytes = new int[2];
        this._isBigEndian = bl;
    }

    public int read() throws IOException {
        if (this._bytesRemainingInStream == 0) {
            return -1;
        }
        if (this._isBigEndian) {
            this._bytes[0] = super.read();
            this._bytes[1] = super.read();
            this._returnVal = this._bytes[1];
        } else {
            this._bytes[0] = super.read();
            this._bytes[1] = super.read();
            this._returnVal = this._bytes[0];
        }
        this._bytesRemainingInStream -= 2;
        return this._returnVal;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._bytesRemainingInStream == 0) {
            return -1;
        }
        n2 = n2 < this._bytesRemainingInStream / 2 ? n2 : this._bytesRemainingInStream / 2;
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = (byte)this.read();
            ++n3;
        }
        return n2;
    }

    public int available() throws IOException {
        int n = super.available() / 2;
        return n;
    }

    public long skip(long l) throws IOException {
        l = l < (long)(this._bytesRemainingInStream / 2) ? l : (long)(this._bytesRemainingInStream / 2);
        int n = 0;
        while ((long)n < l) {
            this.read();
            ++n;
        }
        return l;
    }
}

