/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.BlobOutputStream;
import com.sybase.jdbc2.tds.PduOutputFormatter;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsDateTime;
import com.sybase.jdbc2.tds.TdsInputStreamIOException;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsDataOutputStream
extends TdsOutputStream {
    Tds _tds;
    protected static final int BUF_SIZE = 2048;
    protected static final int TDS_TYPE = 0;
    protected static final int LENGTH = 1;
    protected static final int PRECISION = 2;
    protected static final int SCALE = 3;
    protected static final int INFO_LENGTH = 4;

    public TdsDataOutputStream(Tds tds, PduOutputFormatter pduOutputFormatter) throws IOException {
        super(pduOutputFormatter);
        this._tds = tds;
    }

    public void writeParam(TdsParam tdsParam, int n) throws IOException {
        int[] nArray = new int[4];
        this.dataTypeInfo(tdsParam, nArray);
        this.checkColStatus(tdsParam);
        if (tdsParam._inValue == null && tdsParam._inDataFmt._colStatusBytePresent) {
            return;
        }
        if (tdsParam._inValue == null) {
            switch (nArray[0]) {
                case 50: {
                    this.writeByte(0);
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 108: 
                case 109: 
                case 111: 
                case 123: 
                case 147: {
                    this.writeByte(0);
                    break;
                }
                case 175: 
                case 225: {
                    this.writeInt(0);
                    break;
                }
                case 36: 
                case 9217: {
                    this.writeByte(1);
                    this.writeShort(0);
                    this.writeInt(0);
                    break;
                }
                case 9219: 
                case 9220: {
                    this.writeByte(0);
                    this.writeShort(0);
                    this.writeInt(0);
                    break;
                }
            }
            return;
        }
        block12 : switch (nArray[0]) {
            case 50: {
                this.writeByte((Boolean)tdsParam._inValue != false ? 1 : 0);
                break;
            }
            case 38: {
                this.writeByte(nArray[1]);
                switch (nArray[1]) {
                    case 0: {
                        break block12;
                    }
                    case 1: {
                        this.writeByte((Integer)tdsParam._inValue);
                        break block12;
                    }
                    case 2: {
                        this.writeShort((Integer)tdsParam._inValue);
                        break block12;
                    }
                    case 4: {
                        this.writeInt((Integer)tdsParam._inValue);
                        break block12;
                    }
                    case 8: {
                        this.writeLong((Long)tdsParam._inValue);
                        break block12;
                    }
                }
                break;
            }
            case 109: {
                this.writeByte(nArray[1]);
                switch (nArray[1]) {
                    case 0: {
                        break block12;
                    }
                    case 4: {
                        this.writeFloat(((Float)tdsParam._inValue).floatValue());
                        break block12;
                    }
                    case 8: {
                        this.writeDouble((Double)tdsParam._inValue);
                        break block12;
                    }
                }
                break;
            }
            case 39: 
            case 175: {
                int n2 = nArray[1];
                if (nArray[0] == 39) {
                    this.writeByte(n2);
                } else {
                    this.writeInt(n2);
                }
                if (n2 <= 0) break;
                this.write(tdsParam._cvtString, 0, n2);
                break;
            }
            case 37: {
                int n3 = nArray[1];
                this.writeByte(n3);
                if (n3 <= 0) break;
                this.write((byte[])tdsParam._inValue, 0, n3);
                break;
            }
            case 225: {
                int n4 = nArray[1];
                this.writeInt(n4);
                if (n4 <= 0) break;
                if (tdsParam._inValue instanceof byte[]) {
                    this.write((byte[])tdsParam._inValue, 0, n4);
                    break;
                }
                if (!(tdsParam._inValue instanceof InputStream)) break;
                InputStream inputStream = (InputStream)tdsParam._inValue;
                int n5 = n4 < 2048 ? n4 : 2048;
                byte[] byArray = new byte[n5];
                while (n4 > 0) {
                    int n6 = 0;
                    try {
                        n6 = inputStream.read(byArray, 0, n4 > n5 ? n5 : n4);
                    }
                    catch (IOException iOException) {
                        throw new TdsInputStreamIOException(iOException.toString());
                    }
                    if (n6 < 0) break block12;
                    this.write(byArray, 0, n6);
                    n4 -= n6;
                }
                break;
            }
            case 108: {
                byte[] byArray = TdsNumeric.tdsNumeric((BigDecimal)tdsParam._inValue, tdsParam._scale, nArray);
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                this.write(byArray);
                break;
            }
            case 111: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                int[] nArray2 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray2[0]);
                this.writeInt(nArray2[1]);
                break;
            }
            case 123: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                int[] nArray3 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray3[0]);
                break;
            }
            case 147: {
                this.writeByte(nArray[1]);
                if (nArray[1] <= 0) break;
                int[] nArray4 = TdsDateTime.tdsDateTime((DateObject)tdsParam._inValue);
                this.writeInt(nArray4[1]);
                break;
            }
            case 9217: {
                this.writeByte(1);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(blobOutputStream);
                objectOutputStream.writeObject(tdsParam._inValue);
                objectOutputStream.close();
                break;
            }
            case 9219: {
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                if (tdsParam._parameterAsAString != null) {
                    tdsParam.convertParamToUnicodeInputStream();
                }
                if (tdsParam._inValue instanceof InputStream) {
                    InputStream inputStream = (InputStream)tdsParam._inValue;
                    byte[] byArray = new byte[2048];
                    int n7 = nArray[1];
                    if (n7 > 0) {
                        n7 *= 2;
                    }
                    char[] cArray = new char[1024];
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, this._tds._charsetName);
                    while (n7 != 0) {
                        int n8;
                        int n9;
                        int n10 = 2048;
                        if (n7 > 0 && n7 < n10) {
                            n10 = n7;
                        }
                        int n11 = 0;
                        try {
                            n11 = inputStream.read(byArray, 0, n10);
                        }
                        catch (IOException iOException) {
                            blobOutputStream.close();
                            throw new TdsInputStreamIOException(iOException.toString());
                        }
                        if (n11 < 0) break;
                        if (n11 % 2 != 0) {
                            n9 = 0;
                            try {
                                n9 = inputStream.read();
                            }
                            catch (IOException iOException) {
                                blobOutputStream.close();
                                throw new TdsInputStreamIOException(iOException.toString());
                            }
                            if (n9 == -1) break;
                            byArray[n11++] = (byte)n9;
                        }
                        if (n7 > 0) {
                            n7 -= n11;
                        }
                        n9 = n11 / 2;
                        if (!tdsParam._paramIsLittleEndian) {
                            n8 = 0;
                            while (n8 < n9) {
                                cArray[n8] = (char)(byArray[n8 * 2] << 8 | byArray[n8 * 2 + 1] & 0xFF);
                                ++n8;
                            }
                        } else {
                            n8 = 0;
                            while (n8 < n9) {
                                cArray[n8] = (char)(byArray[n8 * 2 + 1] << 8 | byArray[n8 * 2] & 0xFF);
                                ++n8;
                            }
                        }
                        outputStreamWriter.write(cArray, 0, n9);
                    }
                    outputStreamWriter.flush();
                } else if (tdsParam._inValue instanceof Reader) {
                    Reader reader = (Reader)tdsParam._inValue;
                    int n12 = nArray[1];
                    char[] cArray = new char[2048];
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)blobOutputStream, this._tds._charsetName);
                    while (n12 != 0) {
                        int n13 = 2048;
                        if (n12 > 0 && n12 < n13) {
                            n13 = n12;
                        }
                        int n14 = 0;
                        try {
                            n14 = reader.read(cArray, 0, n13);
                        }
                        catch (IOException iOException) {
                            blobOutputStream.close();
                            throw new TdsInputStreamIOException(iOException.toString());
                        }
                        if (n14 < 0) break;
                        if (n12 > 0) {
                            n12 -= n14;
                        }
                        outputStreamWriter.write(cArray, 0, n14);
                    }
                    outputStreamWriter.flush();
                }
                blobOutputStream.close();
                break;
            }
            case 9220: {
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream blobOutputStream = new BlobOutputStream(this);
                InputStream inputStream = (InputStream)tdsParam._inValue;
                byte[] byArray = new byte[2048];
                int n15 = nArray[1];
                while (n15 != 0) {
                    int n16 = 2048;
                    if (n15 > 0 && n15 < n16) {
                        n16 = n15;
                    }
                    int n17 = 0;
                    try {
                        n17 = inputStream.read(byArray, 0, n16);
                    }
                    catch (IOException iOException) {
                        blobOutputStream.close();
                        throw new TdsInputStreamIOException(iOException.toString());
                    }
                    if (n17 < 0) break;
                    if (n15 > 0) {
                        n15 -= n17;
                    }
                    blobOutputStream.write(byArray, 0, n17);
                }
                blobOutputStream.close();
                break;
            }
        }
    }

    protected void dataTypeInfo(TdsParam tdsParam, int[] nArray) throws IOException {
        switch (tdsParam._sqlType) {
            case -7: {
                nArray[0] = 50;
                break;
            }
            case -6: {
                nArray[0] = 38;
                nArray[1] = 1;
                break;
            }
            case 5: {
                nArray[0] = 38;
                nArray[1] = 2;
                break;
            }
            case -998: {
                nArray[0] = 56;
                nArray[1] = 4;
                break;
            }
            case 4: {
                nArray[0] = 38;
                nArray[1] = 4;
                break;
            }
            case -5: {
                nArray[0] = 38;
                nArray[1] = 8;
                break;
            }
            case 7: {
                nArray[0] = 109;
                nArray[1] = 4;
                break;
            }
            case 6: 
            case 8: {
                nArray[0] = 109;
                nArray[1] = 8;
                break;
            }
            case 2: 
            case 3: {
                nArray[0] = 108;
                if (tdsParam == null) break;
                TdsNumeric.tdsNumeric((BigDecimal)tdsParam._inValue, tdsParam._scale, nArray);
                break;
            }
            case 9219: 
            case 9220: {
                nArray[0] = tdsParam._sqlType;
                nArray[1] = tdsParam._scale;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                nArray[0] = tdsParam._sqlType == -1 ? 175 : 39;
                this.convertString(tdsParam, nArray);
                if (!tdsParam._parameterHoldsUnicharData) break;
                nArray[0] = 225;
                break;
            }
            case 91: {
                if (this._tds.serverAcceptsDateData()) {
                    nArray[0] = 123;
                    nArray[1] = 4;
                    break;
                }
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case 92: {
                boolean bl = false;
                try {
                    bl = this._tds.getSybProperty().getBoolean(49);
                }
                catch (SQLException sQLException) {
                    ErrorMessage.raiseIOECheckDead(sQLException);
                }
                if (this._tds.serverAcceptsTimeData() && bl) {
                    nArray[0] = 147;
                    nArray[1] = 4;
                    break;
                }
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case 93: {
                nArray[0] = 111;
                nArray[1] = 8;
                break;
            }
            case -3: 
            case -2: {
                nArray[0] = 37;
                if (tdsParam._inValue == null) break;
                nArray[1] = ((byte[])tdsParam._inValue).length;
                break;
            }
            case -4: {
                nArray[0] = 225;
                if (tdsParam._inValue == null) break;
                if (tdsParam._inValue instanceof byte[]) {
                    nArray[1] = ((byte[])tdsParam._inValue).length;
                    break;
                }
                if (!(tdsParam._inValue instanceof InputStream)) break;
                if (tdsParam._scale == -1) {
                    InputStream inputStream = (InputStream)tdsParam._inValue;
                    nArray[1] = inputStream.available();
                    break;
                }
                nArray[1] = tdsParam._scale;
                break;
            }
            case 2000: {
                nArray[0] = 9217;
                nArray[1] = -1;
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0SL", "" + tdsParam._sqlType);
            }
        }
        if (tdsParam._inValue == null) {
            nArray[1] = 0;
        }
    }

    protected void convertString(TdsParam tdsParam, int[] nArray) throws IOException {
        if (tdsParam._inValue != null) {
            if (tdsParam._inValue instanceof String) {
                if (tdsParam._cvtString == null) {
                    tdsParam._parameterAsAString = (String)tdsParam._inValue;
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte((String)tdsParam._inValue);
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else if (tdsParam._inValue instanceof InputStream) {
                if (tdsParam._cvtString == null) {
                    String string = null;
                    tdsParam._parameterAsAString = string = tdsParam.getStringFromStream(0);
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(string);
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else if (tdsParam._inValue instanceof Reader) {
                if (tdsParam._cvtString == null) {
                    char[] cArray = new char[2048];
                    StringBuffer stringBuffer = new StringBuffer(2048);
                    int n = 0;
                    while (true) {
                        int n2;
                        int n3 = 2048;
                        if (tdsParam._scale >= 0 && tdsParam._scale < 2048) {
                            n3 = tdsParam._scale - n;
                        }
                        if (n3 <= 0 || (n2 = ((Reader)tdsParam._inValue).read(cArray, 0, n3)) <= 0) break;
                        stringBuffer.append(cArray, 0, n2);
                        n += n2;
                    }
                    tdsParam._parameterAsAString = stringBuffer.toString();
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(stringBuffer.toString());
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            } else {
                if (tdsParam._cvtString == null) {
                    tdsParam._parameterAsAString = tdsParam._inValue.toString();
                    this.check0LNNString(tdsParam);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(tdsParam);
                    } else {
                        tdsParam._cvtString = this.stringToByte(tdsParam._inValue.toString());
                    }
                }
                nArray[1] = tdsParam._cvtString.length;
            }
        }
    }

    private void setUnicharParameter(TdsParam tdsParam) throws IOException {
        tdsParam._cvtString = this.stringToByte(tdsParam._parameterAsAString);
        String string = this._tds._charsetConverter.toUnicode(tdsParam._cvtString);
        if (!tdsParam._parameterAsAString.equals(string)) {
            tdsParam._cvtString = tdsParam.stringToUnicodeBytes(tdsParam._parameterAsAString);
            tdsParam._inValue = tdsParam._cvtString;
            tdsParam._sqlType = -4;
            tdsParam._parameterHoldsUnicharData = true;
        }
    }

    protected void check0LNNString(TdsParam tdsParam) {
        if (tdsParam._parameterAsAString.length() == 0 && !this._tds.serverAcceptsColumnStatusByte()) {
            tdsParam._inValue = " ";
            tdsParam._parameterAsAString = " ";
        }
    }

    private void checkColStatus(TdsParam tdsParam) throws IOException {
        if (tdsParam._inDataFmt._colStatusBytePresent) {
            int n = 0;
            if (tdsParam._inValue == null) {
                n = 1;
            }
            this.writeByte(n);
        }
    }

    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        return this._tds._charsetConverter.fromUnicode(string);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void send(TdsDataObject var1_1) throws SQLException {
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            try {
                                                block45: {
                                                    try {
                                                        var1_1.beginRead();
                                                        if (!var1_1._isNull) {
                                                            var2_2 = var1_1._dataLength;
                                                            switch (var1_1._dataFmt._datatype) {
                                                                case 48: {
                                                                    this.writeByte(var1_1.getByte());
                                                                    var14_4 = null;
                                                                    break block36;
                                                                }
                                                                case 52: {
                                                                    this.writeShort(var1_1.getShort());
                                                                    break block37;
                                                                }
                                                                case 56: {
                                                                    this.writeInt(var1_1.getInt());
                                                                    break block38;
                                                                }
                                                                case 191: {
                                                                    this.writeLong(var1_1.getLong());
                                                                    break block39;
                                                                }
                                                                case 38: {
                                                                    this.writeByte(var2_2);
                                                                    var3_16 = var1_1.getLong();
                                                                    switch (var2_2) {
                                                                        case 1: {
                                                                            this.writeByte((byte)var3_16);
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            this.writeShort((short)var3_16);
                                                                            break;
                                                                        }
                                                                        case 4: {
                                                                            this.writeInt((int)var3_16);
                                                                            break;
                                                                        }
                                                                        case 8: {
                                                                            this.writeLong(var3_16);
                                                                            break block40;
                                                                        }
                                                                    }
                                                                    break block40;
                                                                }
                                                                case 59: {
                                                                    this.writeFloat(var1_1.getFloat());
                                                                    break block41;
                                                                }
                                                                case 62: {
                                                                    this.writeDouble(var1_1.getDouble());
                                                                    break block42;
                                                                }
                                                                case 109: {
                                                                    this.writeByte(var2_2);
                                                                    var5_17 = var1_1.getDouble();
                                                                    switch (var2_2) {
                                                                        case 4: {
                                                                            this.writeFloat((float)var5_17);
                                                                            break;
                                                                        }
                                                                        case 8: {
                                                                            this.writeDouble(var5_17);
                                                                            break block43;
                                                                        }
                                                                    }
                                                                    break block43;
                                                                }
                                                                case 49: 
                                                                case 50: 
                                                                case 51: 
                                                                case 58: 
                                                                case 60: 
                                                                case 61: 
                                                                case 122: {
                                                                    break;
                                                                }
                                                                case 37: 
                                                                case 39: 
                                                                case 45: 
                                                                case 47: 
                                                                case 103: 
                                                                case 104: 
                                                                case 106: 
                                                                case 108: 
                                                                case 110: 
                                                                case 111: 
                                                                case 123: 
                                                                case 147: {
                                                                    this.writeByte(var2_2);
                                                                    break;
                                                                }
                                                                case 34: 
                                                                case 35: 
                                                                case 175: 
                                                                case 225: {
                                                                    this.writeInt(var2_2);
                                                                    break;
                                                                }
                                                                case 36: {
                                                                    var1_1.reset();
                                                                    var7_18 = ((TdsJdbcInputStream)var1_1).makeNewRIS(4);
                                                                    var8_19 = new byte[2048];
                                                                    while ((var9_20 = var7_18.read(var8_19)) >= 0) {
                                                                        this.write(var8_19, 0, var9_20);
                                                                    }
                                                                    break block44;
                                                                }
                                                                default: {
                                                                    ErrorMessage.raiseError("JZ0TC");
                                                                }
                                                            }
                                                            var9_21 = new byte[var2_2 < 2048 ? var2_2 : 2048];
                                                            var10_22 = var9_21.length;
                                                            var11_23 = 0;
                                                            while (var11_23 < var2_2 && (var12_24 = var1_1.read(var9_21, 0, var10_22)) >= 0) {
                                                                this.write(var9_21, 0, var12_24);
                                                                var10_22 = var2_2 - (var11_23 += var12_24) > 2048 ? 2048 : var2_2 - var11_23;
                                                            }
                                                            break block45;
                                                        }
                                                        if ((var1_1._dataFmt._status & 32) == 0) break block45;
                                                        switch (var1_1._dataFmt._datatype) {
                                                            case 37: 
                                                            case 38: 
                                                            case 39: 
                                                            case 45: 
                                                            case 47: 
                                                            case 103: 
                                                            case 104: 
                                                            case 106: 
                                                            case 108: 
                                                            case 109: 
                                                            case 110: 
                                                            case 111: 
                                                            case 123: 
                                                            case 147: {
                                                                this.writeByte(0);
                                                                ** break;
                                                            }
                                                            case 34: 
                                                            case 35: 
                                                            case 36: 
                                                            case 175: 
                                                            case 225: {
                                                                this.writeInt(0);
                                                                ** break;
                                                            }
                                                        }
                                                        ErrorMessage.raiseError("JZ0TC");
                                                    }
                                                    catch (IOException var2_3) {
                                                        ErrorMessage.raiseErrorCheckDead(var2_3);
                                                        var14_14 = null;
                                                        var1_1.endRead();
                                                        return;
                                                    }
                                                }
lbl98:
                                                // 2 sources

                                                while (true) {
                                                    var14_13 = null;
                                                    var1_1.endRead();
                                                    return;
                                                }
lbl108:
                                                // 2 sources

                                                ** continue;
                                            }
                                            catch (Throwable var13_25) {
                                                var14_15 = null;
                                                var1_1.endRead();
                                                throw var13_25;
                                            }
                                        }
                                        var1_1.endRead();
                                        return;
                                    }
                                    var14_5 = null;
                                    var1_1.endRead();
                                    return;
                                }
                                var14_6 = null;
                                var1_1.endRead();
                                return;
                            }
                            var14_7 = null;
                            var1_1.endRead();
                            return;
                        }
                        var14_8 = null;
                        var1_1.endRead();
                        return;
                    }
                    var14_9 = null;
                    var1_1.endRead();
                    return;
                }
                var14_10 = null;
                var1_1.endRead();
                return;
            }
            var14_11 = null;
            var1_1.endRead();
            return;
        }
        var14_12 = null;
        var1_1.endRead();
    }

    public String getCharset() {
        return this._tds._charsetName;
    }
}

