/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.Capture;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.timedio.Dbio;
import com.sybase.jdbc2.timedio.OutStreamMgr;
import com.sybase.jdbc2.timedio.ResponseQueue;
import com.sybase.jdbc2.timedio.StreamContext;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.BufferPool;
import com.sybase.jdbc2.utils.SyncObj;
import com.sybase.jdbc2.utils.SyncQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.EmptyStackException;

public class InStreamMgr {
    public static final int RESPONSE_DONE = 0;
    public static final int RESPONSE_MORE = 1;
    public static final int PARTIAL_PACKET = 2;
    public static final int EVENT = 3;
    public static final int ERROR = 4;
    public static final int RESPONSE_OPEN = 5;
    public static final int EVENT_DONE = 6;
    private Dbio _dbio = null;
    private OutStreamMgr _outMgr;
    private BufferPool _pool;
    private StreamContext _currentCtx;
    private StreamContext _eventCtx;
    private boolean _closing;
    private int _cacheSize;
    private boolean _cancelling = false;
    private boolean _serialize = false;
    BufferInterval _partialBI = null;
    private SyncQueue _readList;
    private SyncObj _readerThd;
    private boolean _readAhead = false;
    private SQLWarning _capSqw;
    public Tds _tds;
    public boolean _tracing = false;

    public InStreamMgr(String string, int n, SybProperty sybProperty) throws IOException, SQLException {
        int n2 = 1000 * DriverManager.getLoginTimeout();
        this._readList = new SyncQueue(6, 6);
        this._readerThd = new SyncObj(this._readList);
        this._cacheSize = sybProperty.getInteger(13);
        int n3 = sybProperty.getInteger(12);
        this._serialize = sybProperty.getBoolean(29);
        this._pool = new BufferPool(this, this._cacheSize, n3);
        this._dbio = Dbio.connect(string, n, this, sybProperty);
        this._dbio.doConnect(n2);
        this._closing = false;
        try {
            this._dbio.createCapture(sybProperty);
        }
        catch (SQLWarning sQLWarning) {
            this._capSqw = sQLWarning;
        }
    }

    public SQLWarning getCaptureWarnings() {
        return this._capSqw;
    }

    public OutputStream getOutputStream() throws IOException {
        return this._dbio.getOutputStream();
    }

    public void setNetBufSize(int n) {
        this._pool.setNetBufSize(n);
    }

    public InputStream getInputStream() throws IOException {
        return this._dbio.getInputStream();
    }

    public void closing() {
        this._dbio.closing();
    }

    public void markDead() throws IOException {
        StreamContext streamContext = this.getCurrentContext();
        if (streamContext != null) {
            streamContext._conn.markDeadTryHA();
        } else {
            this._eventCtx._conn.markDeadTryHA();
        }
    }

    public String getSessionID() {
        return this._dbio.getSessionID();
    }

    public void setEventContext(StreamContext streamContext) {
        this._eventCtx = streamContext;
    }

    public void close() {
        if (!this._closing) {
            this._closing = true;
            this._dbio.stopAsync();
            if (this._eventCtx != null) {
                this._eventCtx.drop();
            }
            this._dbio.close();
        }
    }

    protected StreamContext currentContext() {
        return this._currentCtx;
    }

    public void cancelling(boolean bl) {
        InStreamMgr inStreamMgr = this;
        synchronized (inStreamMgr) {
            this._cancelling = bl;
        }
        if (this._cancelling) {
            StreamContext streamContext = this.getCurrentContext();
            if (streamContext != null) {
                streamContext.cancelled();
            }
        } else {
            this.setCurrentContextNull();
        }
    }

    public boolean startAsync() {
        if (this._readAhead) {
            return true;
        }
        if (13 == this._readerThd.giveToMe(0L)) {
            this._readAhead = this._dbio.startAsync();
            if (!this._readAhead) {
                this._readerThd.giveToNext();
            }
        }
        return this._readAhead;
    }

    public Capture getCapture() {
        return this._dbio.getCapture();
    }

    protected SyncQueue getReadQueue() {
        return this._readList;
    }

    public void doRead(StreamContext streamContext) throws IOException {
        this.readIfOwner(this.takeIfNoReadAhead(streamContext), streamContext);
    }

    protected SyncObj dump() {
        SyncObj syncObj = null;
        return syncObj;
    }

    public void setSerialize() {
        this._serialize = true;
        this._outMgr.setSerialize(this._serialize);
    }

    public BufferInterval getBI() {
        return this._pool.getBI(true);
    }

    protected void setOutStreamMgr(OutStreamMgr outStreamMgr) {
        this._outMgr = outStreamMgr;
        this._outMgr.setSerialize(this._serialize);
    }

    protected void moreData(BufferInterval bufferInterval, int n) {
        int n2 = bufferInterval._length - n;
        if (this._closing) {
            return;
        }
        BufferInterval bufferInterval2 = null;
        if (n2 > 0) {
            bufferInterval2 = bufferInterval.divide(n);
            this._pool.put(bufferInterval);
        } else {
            bufferInterval2 = bufferInterval;
        }
        bufferInterval = null;
        int n3 = 0;
        do {
            StreamContext streamContext;
            if ((streamContext = this.getCurrentContext()) != null) {
                bufferInterval2 = streamContext.queueData(bufferInterval2);
                n3 = streamContext.responseState();
            } else {
                bufferInterval2 = this._eventCtx.queueData(bufferInterval2);
                n3 = this._eventCtx.responseState();
            }
            switch (n3) {
                case 0: {
                    this.setCurrentContextNull();
                    break;
                }
                case 2: {
                    this.partialPacket(bufferInterval2);
                    return;
                }
                case 3: {
                    bufferInterval2 = this._eventCtx.queueData(bufferInterval2);
                    n3 = this._eventCtx.responseState();
                }
            }
            if (n3 != 4) continue;
            this._pool.put(bufferInterval2);
            bufferInterval2 = null;
            this._dbio._lastEx = null;
            this.reportError("JZ0T8");
            break;
        } while (bufferInterval2 != null);
    }

    private void partialPacket(BufferInterval bufferInterval) {
        this._partialBI = bufferInterval;
    }

    protected void setBuffer(long l) throws IOException {
        BufferInterval bufferInterval = null;
        InStreamMgr inStreamMgr = this;
        synchronized (inStreamMgr) {
            bufferInterval = this._pool.getBI(this._cancelling);
            if (bufferInterval == null) {
                try {
                    this.wait((int)l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                bufferInterval = this._pool.getBI(this._cacheSize == -1);
            }
        }
        if (bufferInterval == null) {
            ErrorMessage.raiseIOException("JZ0T5");
        }
        int n = 0;
        if (this._partialBI != null) {
            System.arraycopy(this._partialBI._buf, this._partialBI._offset, bufferInterval._buf, bufferInterval._offset, this._partialBI._length);
            n = this._partialBI._length;
            this._pool.put(this._partialBI);
            this._partialBI = null;
        }
        this._dbio.setBufferInfo(bufferInterval, n);
    }

    public void reportError(String string) {
        StreamContext streamContext = this.getCurrentContext();
        if (streamContext == null) {
            try {
                streamContext = this._outMgr.peekNextContext();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        SQLException sQLException = ErrorMessage.makeIOReportableException(string, this._dbio._lastEx);
        if (streamContext != null) {
            streamContext.chainException(sQLException);
        } else {
            this._eventCtx._conn.chainWarnings(sQLException);
        }
        if (null != this._dbio._lastEx) {
            this._dbio._lastEx = null;
            this.close();
        }
    }

    private void readIfOwner(int n, StreamContext streamContext) throws IOException {
        switch (n) {
            case 13: {
                try {
                    this._dbio.doRead(streamContext.getTimeUntilTimeout());
                    Object var5_3 = null;
                    streamContext._responseQue.giveToNext();
                    break;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    streamContext._responseQue.giveToNext();
                    throw throwable;
                }
            }
            case 12: {
                break;
            }
            case 14: {
                ErrorMessage.raiseIOException("JZ0T3");
            }
        }
    }

    protected void cacheResponses(StreamContext streamContext) throws IOException {
        StreamContext streamContext2;
        while ((streamContext2 = this.getCurrentContext()) != null) {
            int n;
            if (!this._readAhead) {
                streamContext._responseQue.setNeed();
            }
            if ((n = this.takeIfNoReadAhead(streamContext)) != 13) continue;
            streamContext2 = this.getCurrentContext();
            if (streamContext2 != null) {
                this.readIfOwner(n, streamContext2);
            }
            streamContext._responseQue.giveToNext();
        }
    }

    private synchronized StreamContext getCurrentContext() {
        if (this._currentCtx == null) {
            this._currentCtx = this._outMgr.getNextContext();
            if (this._currentCtx == null) {
                // empty if block
            }
        }
        return this._currentCtx;
    }

    public synchronized void setCurrentContextNull() {
        this._currentCtx = null;
    }

    private int takeIfNoReadAhead(StreamContext streamContext) {
        if (this._readAhead) {
            ResponseQueue responseQueue = streamContext._responseQue;
            synchronized (responseQueue) {
                if (streamContext._responseQue.available(0) > 0) {
                    int n = 12;
                    return n;
                }
                try {
                    streamContext._responseQue.wait(streamContext._timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (streamContext._responseQue.available(0) > 0) {
                return 12;
            }
            return 14;
        }
        return streamContext._responseQue.giveToMe(streamContext._timeout);
    }
}

