'use strict'
var Queue = require('./queue')
var log = require('./../logger');
var appendMsg = 'Collector :'

/**
 * Collector is reponsible for storing data
 * temporarly and pushing the data periodically to the agent 
 * via socket server
 * @param {Object} agent 
 */
function Collector(agent) {
    this.agent = agent;
    this.config = agent.config;
    this.queue = new Queue(agent);
    this.socket = agent.socket;
    var that = this;

    this.timer = setInterval(function () {
        if (that.queue.size() > 0) {
            log.debug(appendMsg,"payload sending from queue to socket periodically, queue size:", that.queue.size())
            var payload = that.queue.getAll();
            that.queue.reset();
            that.socket.write(payload);
        }
    }, this.config.flushInterval || 15000)

    this.timer.unref();
}

/**
 * To add the new data into the collector
 */
Collector.prototype.add = function (data) {
    this.queue.enqueue(data);
    
    //If queue size reached max size then send it to agent
    if (this.queue.size() >= this.agent.config.maxQueueSize) {
        log.debug(appendMsg, "Queue size exceeded, so data sending from queue to socket...");
        var payload = this.queue.getAll();
        this.queue.reset();
        this.socket.write(payload);
    }
}

module.exports = Collector;