var log = require('./../logger');
/**
 * copied from open source
 * Measures Node.js event loop lag.
 *https://www.npmjs.com/package/event-loop-lag
 * 
 */

module.exports = exports = function eventLoopLag(ms){
    if ('number' != typeof ms) {
     // throw new TypeError('ms must be a number');
      log.error("Event-loop-lag ms must be a number");
      return;
    }
  
    var start = time();
    var delay = 0;
  
    var timeout = setTimeout(check, ms);
    timeout.unref();
  
    function check(){

      clearTimeout(timeout);
      
      var t = time();
      delay = Math.max(0, t - start - ms);
      start = t;
  
      timeout = setTimeout(check, ms)
      timeout.unref();
    }
  
    // return the loop delay in milliseconds
    return function() {
      return delay;
    }
  }
  
  function time() {
    var t = process.hrtime();
    return (t[0] * 1e3) + (t[1] / 1e6);
  }