'use strict'
var cluster = require('cluster');
var log = require('../../../logger');
var INTERVAL = 5000;
var appendMsg = 'core-cluster :'

module.exports = function (agent) {


    var _agent = agent._agent;

    if(_agent){
        var interval = setInterval(() => {
            if (cluster.isMaster) {
    
                _agent.config.isMaster = true;
    
                if (_agent.config.workerCount !== Object.keys(cluster.workers || {}).length) {
                    _agent.config.workerCount = Object.keys(cluster.workers || {}).length;
                    log.debug(appendMsg, 'cluster worker count changed :', _agent.config.workerCount)
                   // agent.socket.write( JSON.stringify({'workerCount' :  agent.config.workerCount }));
                }
            }
    
        }, INTERVAL);
    
        interval.unref();
    }


}