'use strict'
var semver = require('semver')
var shimmer = require('../shimmer')
var logger = require('../../logger')
var appendMsg = 'Express :'

module.exports = function wrapExpress(express, agent, version) {


    if (!semver.satisfies(version, '^4.0.0')) {
        log.error(appendMsg, 'express version not supported', version)
        return express
    }

    function wrap(fn) {
        if (fn.length === 4) {
            return function Wrapped4Arg(err, req, res, next) {
                if (err) {
                    //If its error store this error 
                    log.debug(appendMsg, "express error handler", err);
                }

                return fn.apply(this, arguments)
            }
        } else if (fn.length === 3) {
            return function Wrapped3Arg(req, res, next) {

                var span = agent.buildSpan()

                if (!span) {
                    return fn.apply(this, arguments)
                }

                span.start(fn.name ? fn.name : 'Anonymous', 'Middleware')

                fn(req, res, function () {
                    span.end()
                    return next.apply(this, arguments);
                });

            };
        } else {
            //note:- Do we need final else here????
            return fn.apply(this, arguments)
        }
    }


    shimmer.wrap(express.Router, 'use', function (orig) {
        return function (fn) {

            var lastArg = arguments.length - 1;

            if (typeof arguments[lastArg] === 'function') {
                arguments[lastArg] = wrap(arguments[lastArg])
            }

            return orig.apply(this, arguments)
        }
    });

    //Wrap params

    //Res render have arguments with or without callback
    //http://expressjs.com/en/api.html#res.render
    //Some times render is not stored in the transaction because it stored in cache (F5)
    shimmer.wrap(express.response, 'render', function (RENDER) {
        return function () {

            var span = agent.buildSpan()

            if (!span) return RENDER.apply(this, arguments)

            span.start(arguments[0], 'Middleware:RENDER')
            var result = RENDER.apply(this, arguments)
            span.end()
            return result;
        }
    })

    log.info(appendMsg, 'wrapped express module')


    //NOT yet tested
    //https://expressjs.com/en/api.html#app.param refer

    function wrapParam(fn) {
        return function (req, res, next, id) {

            var span = agent.buildSpan()

            if (!span) {
                return fn.apply(this, arguments)
            }
            
            log.info(appendMsg, "express Param req.route", req.route)

            span.start(fn.name ? fn.name : 'Anonymous', 'Params:> :Middleware')

            fn(req, res, function () {

                span.end();
                return next.apply(this, arguments);

            });
        }
    }

    shimmer.wrap(express.Router, 'param', function (orig) {
        return function () {

            var lastArg = arguments.length - 1;

            if (typeof arguments[lastArg] === 'function') {
                arguments[lastArg] = wrapParam(arguments[lastArg])
            }

            return orig.apply(this, arguments)
        }
    })

    return express;
}