'use strict'

var semver = require('semver')
var logger = require('../../logger')
var shimmer = require('../shimmer')
var symbols = require('../../symbols')
var appendMsg = 'Memcached :' 
//POOL also working fine here

module.exports = function (memcached, agent, version, enabled) {

    if (!semver.satisfies(version, '>=1.0.0')) {
        logger.debug(appendMsg ,'version ', version, ' not supported - aborting...')
        return pg
    }


    var proto = memcached && memcached.prototype

    if (proto.command) {
        logger.debug(appendMsg ,'shimming memcached.prototype.command')
        shimmer.wrap(proto, 'command', wrapMemcache)
    } else {
        logger.debug(appendMsg ,'memcached failed to wrap memcached.prototype.command')
    }

    function wrapMemcache(original) {
        return function wrappedMemcache() {


            var span = agent.buildSpan()
            var id = span && span.transaction.id

            logger.debug(appendMsg ,'intercepted call to memcached.prototype.command ', {
                id: id
            })

            if (span) {

                var metacall = arguments[0]()
                var server = arguments[1]

                var params = {}

                // Capture connection info for datastore instance metric.
                var location = null
            

                if (typeof server === 'string') {
                    location = server
                  } else if (this.HashRing && this.HashRing.get && metacall.key) {
                    location = this.HashRing.get(metacall.key)
                 }
               
                if (location) {
                    location = location.split(':')
                    params.host = location[0]
                    params.port = location[1]
                   // console.log("host", params.host ,':',  params.port , "call :" , metacall.command)
                }else{
                    //If port host not available set default as temp
                    params.host = 'localhost'
                    params.port = '11211'
                }
              
          

                //Wrap call back
                if (metacall.callback) {
                    shimmer.wrap(metacall, 'callback', function (origCB) {
                        return function (err) {
                            span.end()
                            return origCB.apply(this, arguments)
                        };
                    });
                }

                // rewrap the metacall for the command object
                arguments[0] = function rewrapped() {
                    return metacall
                }



                span.start(String( metacall.command).toUpperCase(), 'redis')
                params.serverType = 'redis'
                params.command ='-#' +  String( metacall.type).toUpperCase()  , // metacall.type  // +  ":" + JSON.stringify(metacall.key);
                params.error = ''
                params.resTime = ''
                span.options = params

            }

            var returned = original.apply(this, arguments)

            return returned;
        };
    }


    /**
         if (sqlObj.config) {
      params.host = sqlObj.config.host
      params.port = sqlObj.config.port
      params.dbName = sqlObj.config.database
      params.resTime = ''
      params.serverType = 'mysql'
      params.error = '',
        params.nodeOrder = ''
    }
     */

    return memcached

}