'use strict'

var semver = require('semver')
var sqlSummary = require('sql-summary')

var shimmer = require('../shimmer')
var symbols = require('../../symbols')
var log = require('../../logger')
var appendMsg = 'Mysql2 :'
module.exports = function (mysql2, agent, version, enabled) {

  var ins = agent._instrumentation
  if (!semver.satisfies(version, '^1.0.0')) {
    log.debug(appendMsg ,'mysql2 version is not supported - aborting...', version)
    return mysql2
  }else{
    log.debug(appendMsg ,'mysql2 version is supported - v : ', version)
  }

  shimmer.wrap(mysql2.Connection.prototype, 'query', wrapQuery)
  shimmer.wrap(mysql2.Connection.prototype, 'execute', wrapQuery)

  return mysql2

  function wrapQuery (original) {
    return function wrappedQuery (sql, values, cb) {
      var span = enabled && agent.buildSpan()
      var id = span && span.transaction.id
      var hasCallback = false
      var sqlStr = sql

      if (span) {
        span.type = 'db.mysql.query'

        var params = getParameters(this);

        if (sqlStr) params.query = sqlStr;

        span.options = params;
      }

      switch (typeof sql) {
        case 'string':
          sqlStr = sql
          break
        case 'object':
          if (typeof sql.onResult === 'function') {
            sql.onResult = wrapCallback(sql.onResult)
          }
          sqlStr = sql.sql
          break
        case 'function':
          arguments[0] = wrapCallback(sql)
          break
      }

      if (span && sqlStr) {
        log.debug(appendMsg ,'extracted sql from mysql2 query ', { id: id, sql: sqlStr })
        span.name = sqlStr
      }

      if (typeof values === 'function') {
        arguments[1] = wrapCallback(values)
      } else if (typeof cb === 'function') {
        arguments[2] = wrapCallback(cb)
      }

      var result = original.apply(this, arguments)
      if (result && !hasCallback) {
        ins.bindEmitter(result)
        if (span) {
          var started = false
          shimmer.wrap(result, 'emit', function (original) {
            return function (event) {
              if (!started) {
                started = true
                span.start()
              }
              switch (event) {
                case 'error':
                case 'close':
                case 'end':
                  span.end()
              }
              return original.apply(this, arguments)
            }
          })
        }
      }

      return result

      function wrapCallback (cb) {
        hasCallback = true
        if (span) span.start()
        return agent._instrumentation.bindFunction(span ? wrappedCallback : cb)
        function wrappedCallback () {
          span.end()
          return cb.apply(this, arguments)
        }
      }
    }
  }

  /**
 * Note:- need to test this in UNIX platform 
 * So that we can go with confidence
 * 
 * Mostly in two variables connection object is exists .config OR connectionConfig
 * 
 * Note:- 
 * 
 *If its unix system it will connected with name => obj.socketPath
 Now Im skipping to implement this...

 database_name : nodejs
 host 192.168.8.246
 port : 3306
 Instance  192.168.8.246:3306

 */
function getParameters(sqlObj) {

  var params = {}
  /**
    host: '',
    port: '',
    databaseName: '',
    resTime: '',
    serverType: 'oracle | mysql |  ms'
    query: '',
    'error': '',
    nodeOrder: '-',
   */
  //connectionConfig
  if (sqlObj.config) {
    params.host = sqlObj.config.host
    params.port = sqlObj.config.port
    params.dbName = sqlObj.config.database
    params.resTime = ''
    params.serverType = 'mysql'
    params.error = '',
      params.nodeOrder = ''
  }

  return params;
}


}
