'use strict'
var path = require('path');
var log = require('../logger')

var CWD = process.cwd()

module.exports = function getBusinessContext(req, param, paramType, functionName) {

    if (paramType === 'params') {
        
        if (req.query && req.query[param]) return req.query[param]

    } else if (paramType === 'session') {
        if (req.session) return req.session[param]
    }

    
    if (paramType === 'static') {

        requireFilePath = path.resolve(CWD + param);

        try {
            var requiredFunc = require(requireFilePath)

            if (functionName) {
                return requiredFunc[functionName](req)
            } else if (typeof requiredFunc === 'function') {
                return requiredFunc(req)
            }

        } catch (e) {
            console.log("error", e)
        }
    }
}





