/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

public class ADServerTest
extends GenericTest {
    ADSvrTestHelper AdHelper = null;
    double availability = 0.0;
    double responseTime = -1.0;
    int adportNo;
    String userName = this.getValueForParam("user");
    String password = this.getValueForParam("password");
    String domainName = this.getValueForParam("domain");
    boolean noneFound = false;
    String os;
    int defValue = -5;
    int connectTimeOut = 5000;
    String connectTimeOutStr = this.getValueForParam("ConnectTimeout");
    String ssl = this.getValueForParam("ssl");
    boolean sslEnabled = false;
    boolean useExecCmd = false;
    String javaVersion = "";

    public ADServerTest(String[] stringArray) {
        super(stringArray);
        try {
            if (this.connectTimeOutStr != null && this.connectTimeOutStr.length() > 0) {
                this.connectTimeOut = Integer.parseInt(this.connectTimeOutStr);
                this.connectTimeOut *= 1000;
            } else {
                this.connectTimeOut = 5000;
            }
        }
        catch (Exception exception) {
            this.connectTimeOut = 5000;
        }
        try {
            this.adportNo = Integer.parseInt(this.portNo);
        }
        catch (Exception exception) {
            this.adportNo = 389;
        }
        if (this.ssl != null && (this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes"))) {
            this.adportNo = 636;
            this.sslEnabled = true;
        }
        this.javaVersion = System.getProperty("java.version");
        if (this.javaVersion == null) {
            this.javaVersion = "";
        }
        if (this.sslEnabled && this.javaVersion.compareTo("1.8") >= 0) {
            this.useExecCmd = true;
        } else {
            this.noneFound = this.domainName.equalsIgnoreCase("none") || this.userName.equalsIgnoreCase("none") || this.password.equalsIgnoreCase("none");
            this.AdHelper = !this.noneFound ? new ADSvrTestHelper(this.targetHost, this.adportNo, this.domainName, this.userName, this.password, this.sslEnabled) : new ADSvrTestHelper(this.targetHost, this.adportNo, this.sslEnabled);
            this.AdHelper.setConnectionTimeOut(this.connectTimeOut);
        }
        this.setMeasureCount(2);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.useExecCmd) {
            this.getMeasureUsingExecCmd();
        } else {
            boolean bl = this.AdHelper.executeDiscovery();
            if (bl) {
                this.availability = 100.0;
                this.responseTime = this.AdHelper.getResponseTime();
            } else {
                this.availability = 0.0;
                this.responseTime = -1.0;
            }
        }
        if (this.isPassive) {
            if (this.availability <= 0.0) {
                this.availability = -5.0;
            }
            if (this.responseTime <= 0.0) {
                this.responseTime = -5.0;
            }
        }
        arrayList.add(new Double(this.availability));
        arrayList.add(new Double(this.responseTime));
        this.addNewMeasure(arrayList);
        arrayList = null;
    }

    private void getMeasureUsingExecCmd() {
        try {
            Object object;
            String string = "java ";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = EgInstallInfo.getInstallDir();
            String string6 = string5 + "/jre/bin/";
            boolean bl = false;
            String string7 = System.getProperty("os.name");
            if (string7 == null) {
                string7 = "";
            }
            if ((string7 = string7.trim().toLowerCase()).indexOf("win") > -1) {
                bl = true;
            }
            String string8 = null;
            if (this.javaVersion.compareTo("10.0") > 0) {
                string8 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                if (bl) {
                    string8 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                }
            } else if (this.javaVersion.compareTo("1.7") > 0) {
                string8 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                if (bl) {
                    string8 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
            }
            if (string8 != null) {
                string = string + string8 + " ";
            }
            String string9 = ";";
            if (!bl) {
                string9 = ":";
            }
            String string10 = string5 + "/lib/eg_agent.jar" + string9 + string5 + "/lib/eg_util.jar" + string9;
            string2 = bl ? " -cp \"" + string10 + "\"" : " -cp " + string10 + " ";
            boolean bl2 = false;
            string3 = string6 + string;
            if (bl) {
                bl2 = true;
                object = new File(string5 + "/jre/bin/client");
                if (!((File)object).exists()) {
                    bl2 = false;
                }
                if (bl2) {
                    string3 = "cmd.exe /c " + string6 + string;
                    string4 = " -client ";
                } else {
                    string3 = "cmd.exe /c " + string6 + string;
                }
            } else {
                string4 = " -client ";
            }
            object = "-Dcom.sun.jndi.ldap.object.disableEndpointIdentification=true";
            String string11 = (String)object + " " + string4;
            String string12 = string3 + string11 + " " + string2 + " ADSvrTestHelper " + this.targetHost + " " + this.portNo + " " + this.domainName + " " + this.userName + " " + this.password + " " + this.sslEnabled + " " + this.connectTimeOut;
            System.out.println("[" + this.entity + "] execCmd =" + string12);
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string12);
            ArrayList arrayList2 = new ArrayList();
            if (arrayList != null && arrayList.size() > 1) {
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    String string13 = arrayList3.toString();
                    this.logToErrorFile("ERROR", this.entity, string13);
                }
                arrayList2 = (ArrayList)arrayList.get(0);
            }
            if (arrayList2 == null || arrayList2.size() == 0) {
                this.availability = 0.0;
                this.responseTime = -1.0;
                return;
            }
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string14 = (String)arrayList2.get(i);
                if (string14 == null || (string14 = string14.trim()).length() == 0 || (n2 = string14.indexOf("=")) == -1) continue;
                String string15 = string14.substring(n2 + 1);
                if (string14.startsWith("Availability")) {
                    if (string15 != null && string15.trim().equalsIgnoreCase("true")) {
                        this.availability = 100.0;
                        continue;
                    }
                    this.availability = 0.0;
                    continue;
                }
                if (!string14.startsWith("ResponseTime")) continue;
                this.responseTime = EgLangInfo.getDoubleValue(string15);
            }
            if (this.responseTime < 0.0) {
                this.responseTime = -1.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ADServerTest aDServerTest = new ADServerTest(stringArray);
        aDServerTest.computeMeasures(new Hashtable());
    }
}

