/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class ADSvrTestHelper {
    private String targetHost;
    private int portNo;
    private Hashtable env = new Hashtable();
    private NamingEnumeration ee;
    private StringTokenizer token1;
    private StringTokenizer token2;
    private Object obj;
    private String rootDomainNCStr;
    private String str = "";
    int port;
    public boolean found = false;
    double startTime;
    double endTime;
    double responseTime;
    String connectTimeOut;
    private boolean discovered = false;
    private boolean isRootAuthentication = true;
    String user;
    String domain;

    public void setConnectionTimeOut(int n) {
        this.connectTimeOut = "" + n;
        this.env.put("com.sun.jndi.ldap.connect.timeout", this.connectTimeOut);
    }

    public ADSvrTestHelper(String string, int n, String string2, String string3, String string4, boolean bl) {
        this.user = string3;
        this.domain = string2;
        String string5 = null;
        this.responseTime = -1.0;
        this.targetHost = string;
        this.portNo = n;
        this.targetHost = this.targetHost.trim();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String string6 = "ldap://" + this.targetHost + ":" + this.portNo;
        if (bl) {
            string6 = "ldaps://" + this.targetHost + ":" + this.portNo;
            String string7 = System.getProperty("java.home");
            String string8 = string7 + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", string8);
            this.env.put("java.naming.security.protocol", "ssl");
            this.env.put("java.naming.ldap.factory.socket", "com.eg.MySSLSocketFactory");
        }
        this.env.put("java.naming.provider.url", string6);
        string5 = string3 + "@" + string2;
        this.env.put("java.naming.security.principal", string5);
        this.env.put("java.naming.security.credentials", string4);
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.referral", "follow");
    }

    public ADSvrTestHelper(String string, int n, boolean bl) {
        this.responseTime = -1.0;
        this.targetHost = string;
        this.portNo = n;
        this.targetHost = this.targetHost.trim();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String string2 = "ldap://" + this.targetHost + ":" + this.portNo;
        if (bl) {
            string2 = "ldaps://" + this.targetHost + ":" + this.portNo;
            String string3 = System.getProperty("java.home");
            String string4 = string3 + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", string4);
            this.env.put("java.naming.security.protocol", "ssl");
            this.env.put("java.naming.ldap.factory.socket", "com.eg.MySSLSocketFactory");
        }
        this.env.put("java.naming.provider.url", string2);
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.referral", "follow");
    }

    public boolean executeDiscovery() {
        if (this.discovered) {
            if (this.isRootAuthentication) {
                return this.executeDiscovery("rootDomainNamingContext");
            }
            return this.executeDiscovery("defaultNamingContext");
        }
        boolean bl = this.executeDiscovery("rootDomainNamingContext");
        if (bl) {
            this.discovered = true;
            this.isRootAuthentication = true;
        } else {
            bl = this.executeDiscovery("defaultNamingContext");
            if (bl) {
                this.discovered = true;
                this.isRootAuthentication = false;
            }
        }
        return bl;
    }

    public boolean executeDiscovery(String string) {
        InitialDirContext initialDirContext = null;
        this.found = false;
        try {
            this.startTime = System.currentTimeMillis();
            initialDirContext = new InitialDirContext(this.env);
            Attributes attributes = initialDirContext.getAttributes("");
            this.rootDomainNCStr = attributes.get(string).toString();
            if (this.rootDomainNCStr != null && this.rootDomainNCStr.length() != 0) {
                this.token1 = new StringTokenizer(this.rootDomainNCStr, ":");
                this.token1.nextToken();
                this.rootDomainNCStr = this.token1.nextToken().trim();
                Attributes attributes2 = initialDirContext.getAttributes(this.rootDomainNCStr);
                this.found = true;
            }
            this.endTime = System.currentTimeMillis();
            initialDirContext.close();
        }
        catch (PartialResultException partialResultException) {
            this.endTime = System.currentTimeMillis();
            partialResultException.printStackTrace();
            try {
                if (initialDirContext != null) {
                    initialDirContext.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.found = true;
            initialDirContext = null;
            return this.found;
        }
        catch (Exception exception) {
            System.out.println("UserPrincipalName = " + this.user + "@" + this.domain);
            exception.printStackTrace();
            try {
                if (initialDirContext != null) {
                    initialDirContext.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            initialDirContext = null;
            this.found = false;
            return this.found;
        }
        initialDirContext = null;
        return this.found;
    }

    private double getTimeDiff() {
        if (this.found) {
            this.responseTime = this.endTime - this.startTime;
            this.responseTime /= 1000.0;
        } else {
            return -1.0;
        }
        if (this.responseTime > 0.0) {
            this.responseTime = this.responseTime;
        }
        return this.responseTime;
    }

    public double getResponseTime() {
        return this.getTimeDiff();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 6) {
            System.out.println("java ADSvrTestHelper <host> <ldap-port> <domain name> <username> <password> <ssl> <timeout>");
            return;
        }
        String string = stringArray[0];
        int n = 389;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            n = 389;
        }
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        String string4 = stringArray[4];
        boolean bl = false;
        String string5 = stringArray[5];
        if (string5 != null && (string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("yes"))) {
            bl = true;
        }
        ADSvrTestHelper aDSvrTestHelper = null;
        aDSvrTestHelper = string2.equals("none") || string3.equals("none") || string4.equals("none") ? new ADSvrTestHelper(string, n, bl) : new ADSvrTestHelper(string, n, string2, string3, string4, bl);
        int n2 = 5000;
        if (stringArray.length >= 7) {
            String string6 = stringArray[6];
            try {
                if (string6 != null && string6.length() > 0) {
                    n2 = Integer.parseInt(string6);
                    n2 *= 1000;
                }
            }
            catch (Exception exception) {
                n2 = 5000;
            }
        }
        aDSvrTestHelper.setConnectionTimeOut(n2);
        System.out.println("Availability=" + aDSvrTestHelper.executeDiscovery());
        System.out.println("ResponseTime=" + aDSvrTestHelper.getResponseTime());
    }
}

