/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.list.SpooledFileListItem;
import com.ibm.as400.access.list.SpooledFileOpenList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class AS400SpFileTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;
    private int num_Measures = 4;
    private Hashtable timeHash = new Hashtable();
    public Hashtable ddHash = new Hashtable();
    public static final long ONE_MINUTE_IN_MILLIS = 60000L;
    boolean isFirst = true;
    private static final String[] spoolFileInTypes = new String[]{"Warning", "Clear", "Critical"};

    public AS400SpFileTest(String[] stringArray) {
        super(stringArray);
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        this.setMeasureCount(this.measureCount);
    }

    public static void main(String[] stringArray) {
        AS400SpFileTest aS400SpFileTest = new AS400SpFileTest(stringArray);
        aS400SpFileTest.computeMeasures(new Hashtable());
    }

    public void freeTest() {
        this.ddHash = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        block19: {
            ArrayList<Double> arrayList = null;
            this.ddHash = new Hashtable();
            String string = "";
            AS400 aS400 = null;
            try {
                Object object;
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                SpooledFileOpenList spooledFileOpenList = new SpooledFileOpenList(aS400);
                Date date = Calendar.getInstance().getTime();
                Date date2 = this.getGMTFormatTime(date);
                if (this.isFirst) {
                    if (debug) {
                        System.out.println("[AS400SpFileTest] current_GMT--> " + date2);
                    }
                    this.timeHash.put(this.reportingName + ":GMT", date2);
                    this.isFirst = false;
                    return;
                }
                Object object2 = (Date)this.timeHash.get(this.reportingName + ":GMT");
                if (debug) {
                    System.out.println("[AS400SpFileTest] previous_GMT--> " + object2);
                    System.out.println("[AS400SpFileTest] current_GMT--> " + date2);
                }
                if (object2 == null) {
                    long l = date2.getTime();
                    object2 = new Date(l - 300000L);
                }
                this.timeHash.put(this.reportingName + ":GMT", date2);
                spooledFileOpenList.setFilterUsers(new String[]{"*ALL"});
                spooledFileOpenList.setFilterCreationDate((Date)object2, date2);
                spooledFileOpenList.addSortField(2, false);
                spooledFileOpenList.open();
                object2 = spooledFileOpenList.getItems();
                while (object2.hasMoreElements()) {
                    ArrayList<Object> arrayList2;
                    string = "";
                    SpooledFileListItem spooledFileListItem = (SpooledFileListItem)object2.nextElement();
                    if (spooledFileListItem == null) continue;
                    String string2 = spooledFileListItem.getName();
                    int n = spooledFileListItem.getNumber();
                    String string3 = spooledFileListItem.getJobName();
                    String string4 = spooledFileListItem.getJobNumber();
                    String string5 = spooledFileListItem.getJobUser();
                    String string6 = spooledFileListItem.getStatus();
                    String string7 = spooledFileListItem.getPrinterName();
                    int n2 = spooledFileListItem.getTotalPages();
                    object = string2 + "~!~" + n + "~!~" + string3 + "~!~" + string4 + "~!~" + string5 + "~!~" + string6 + "~!~" + string7 + "~!~" + n2;
                    if (debug) {
                        System.err.println("[AS400SpFileTest] line--> " + (String)object);
                    }
                    if (string6 == null || string6.trim().length() == 0) continue;
                    if (string6.equalsIgnoreCase("*READY") || string6.equalsIgnoreCase("*OPEN") || string6.equalsIgnoreCase("*CLOSED") || string6.equalsIgnoreCase("*SAVED") || string6.equalsIgnoreCase("*MESSAGE") || string6.equalsIgnoreCase("*PENDING") || string6.equalsIgnoreCase("*PRINTER")) {
                        string = "Clear";
                    } else if (string6.equalsIgnoreCase("*WRITING")) {
                        string = "Warning";
                    } else if (string6.equalsIgnoreCase("*HELD")) {
                        string = "Critical";
                    }
                    if (this.ddHash != null && this.ddHash.containsKey(string)) {
                        arrayList2 = (ArrayList<Object>)this.ddHash.get(string);
                        if (arrayList2 == null || arrayList2.size() == 0) {
                            arrayList2 = new ArrayList<Object>();
                        }
                        arrayList2.add(object);
                        this.ddHash.put(string, arrayList2);
                        continue;
                    }
                    arrayList2 = new ArrayList<Object>();
                    arrayList2.add(object);
                    this.ddHash.put(string, arrayList2);
                }
                spooledFileOpenList.close();
                int n = spoolFileInTypes.length;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i = 0; i < n; ++i) {
                    String string8 = spoolFileInTypes[i];
                    if (string8 == null || string8.length() == 0 || this.ddHash == null || !this.ddHash.containsKey(string8) || (object = (ArrayList)this.ddHash.get(string8)) == null || ((ArrayList)object).size() == 0) continue;
                    int n3 = ((ArrayList)object).size();
                    if (string8.equalsIgnoreCase("Warning")) {
                        d2 = n3;
                        continue;
                    }
                    if (string8.equalsIgnoreCase("Clear")) {
                        d = n3;
                        continue;
                    }
                    if (!string8.equalsIgnoreCase("Critical")) continue;
                    d3 = n3;
                }
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                if (debug) {
                    System.out.println("[AS400SpFileTest] ddHash--> " + this.ddHash);
                    System.out.println("MeasureList for AS400SpFileTest == " + arrayList);
                }
                this.addNewMeasure(arrayList);
                aS400.disconnectService(2);
            }
            catch (Exception exception) {
                String string9 = EgInstallInfo.getStackTraceAsString(exception);
                this.logToErrorFile(this.entity, "Error", string9);
                if (aS400 == null) break block19;
                aS400.disconnectService(2);
            }
        }
    }

    private Date getGMTFormatTime(Date date) {
        Date date2 = null;
        try {
            Date date3;
            TimeZone timeZone = TimeZone.getDefault();
            date2 = new Date(date.getTime() - (long)timeZone.getRawOffset());
            if (timeZone.inDaylightTime(date2) && timeZone.inDaylightTime(date3 = new Date(date2.getTime() - (long)timeZone.getDSTSavings()))) {
                date2 = date3;
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile(this.entity, "Error", string);
        }
        return date2;
    }
}

