/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemStatus;
import java.util.ArrayList;
import java.util.Hashtable;

public class AS400StorageTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;

    public AS400StorageTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        this.setMeasureCount(this.measureCount);
    }

    public static void main(String[] stringArray) {
        AS400StorageTest aS400StorageTest = new AS400StorageTest(stringArray);
        aS400StorageTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block7: {
            ArrayList<Double> arrayList = null;
            double d = 0.0;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            long l = 0L;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            AS400 aS400 = null;
            try {
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null) {
                    return;
                }
                SystemStatus systemStatus = new SystemStatus(aS400);
                systemStatus.setCaching(true);
                if (systemStatus.isCaching()) {
                    double d2 = systemStatus.getTotalAuxiliaryStorage() / 1024;
                    double d3 = systemStatus.getSystemASP() / 1024;
                    double d4 = systemStatus.getPercentSystemASPUsed();
                    double d5 = systemStatus.getCurrentUnprotectedStorageUsed();
                    double d6 = systemStatus.getMaximumUnprotectedStorageUsed();
                    double d7 = systemStatus.getPercentPermanentAddresses();
                    d = systemStatus.getPercentTemporaryAddresses();
                    f5 = systemStatus.getPercentProcessingUnitUsed();
                    l = systemStatus.getMainStorageSize();
                    n = systemStatus.getNumberOfProcessors();
                    n2 = systemStatus.getPoolsNumber();
                    n3 = systemStatus.getNumberOfPartitions();
                    n4 = systemStatus.getActiveThreadsInSystem();
                    f6 = systemStatus.getCurrentProcessingCapacity();
                    f7 = systemStatus.getPercentCurrentInteractivePerformance();
                    f = systemStatus.getPercentSharedProcessorPoolUsed();
                    f2 = systemStatus.getPercentUncappedCPUCapacityUsed();
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    if (f2 < 0.0f) {
                        f2 = 0.0f;
                    }
                    arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d));
                    if (this.measureCount > 7) {
                        arrayList.add(new Double(f5));
                        arrayList.add(new Double(l));
                        arrayList.add(new Double(n));
                        arrayList.add(new Double(n2));
                        arrayList.add(new Double(n3));
                        arrayList.add(new Double(n4));
                        arrayList.add(new Double(f6));
                        arrayList.add(new Double(f7));
                        arrayList.add(new Double(f));
                        arrayList.add(new Double(f2));
                    }
                    this.addNewMeasure(arrayList);
                }
                systemStatus.setCaching(false);
                aS400.disconnectService(2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (aS400 == null) break block7;
                aS400.disconnectService(2);
            }
        }
    }
}

