/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.EgTesterInfo;
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class AsAbapJco2Base
extends GenericTest {
    protected boolean isBapiLoggedIn;
    private String clientName;
    protected String sapUser;
    private String sapPass;
    protected String hostName;
    private String router;
    private String sysNo;
    protected String instanceName;
    private String unknown_inst;
    public final SimpleDateFormat timestampSDF;
    public final SimpleDateFormat dateOnlySDF;
    public final SimpleDateFormat timeOnlySDF;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    public final SimpleDateFormat mySDF;
    public static final int NaInt = -5;
    private static final String def_IdleTimeout = "120";
    private long comm_Timeout;
    private static final long comm_Timeout_Chk = 50L;
    private static final long oneDayMillis = 86400000L;
    protected static final Double NaDbl = new Double(-5.0);
    protected static final Double zeroDbl = new Double(0.0);
    protected static final Integer oneInt = new Integer(1);
    protected final String timeOnlyFormat = "yyyyMMdd_HHmmss";
    protected final String timeFormat = "yyyyMMdd_HHmmss";
    protected final String dateOnlyFormat = "yyyyMMdd";
    protected final String eGTimeFormat = "MM/dd/yyyy HH:mm:ss";
    private final String eGDateOnlyFormat = "MM/dd/yyyy";
    private final String eGTimeOnlyFormat = "HH:mm ss";
    private static final String syncString = new String("SAP_R3_SERVER");
    public static final String TCodeMapSync = new String("TCODE_MAP");
    private static final String instanceSyncString1 = new String("SAP_R3_SERVER");
    private static Hashtable instanceSyncHashtable = new Hashtable();
    static Hashtable ht_TCodeMap = new Hashtable();
    private EgUtilities egutil;
    protected static Hashtable errCodeTbl;
    protected static Hashtable ht_CoreProps;
    protected static Hashtable ht_SapTimeCal;
    protected static Hashtable ht_GetTimeMillis;
    protected static Hashtable ht_QueryTimeMillis;
    protected static Hashtable ht_dbg_connTracker;
    private IRepository rep;
    private String XMIAuditLevel;
    private int AuditLevel;
    protected String sessID;
    protected boolean isDebugOn;
    protected String eGSapXMIUser;
    private Properties connProps;
    protected static String fieldSep;
    protected String thisServer;
    private String targetOS;
    protected static final Hashtable ht_NumCPUs;
    private String errorMsgForValidation;
    private String instanceNameForValidation;
    String appSrvr;

    public void setXMIAuditLevel(String string, JCO.Client client) {
        if (string == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.printOut("Exception while parsing audit level " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while parsing audit level " + string + " : " + exception.toString());
            return;
        }
        if (n == 0) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_XMI_SET_AUDITLEVEL");
        if (function == null) {
            return;
        }
        function.getImportParameterList().setValue(this.XMIAuditLevel, "AUDITLEVEL");
        try {
            this.executeFunction(function, client, true);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while setting XMI audit level to " + string + " : " + exception.toString());
            this.printOut("ERROR : " + EgInstallInfo.getStackTraceAsString(exception));
            this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Exception while setting XMI audit level to " + string + " : " + exception.toString());
            return;
        }
        this.printOut("INFO : Set XMI Audit level to " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCO.Client getConnection() {
        try {
            JCO.Client client = JCO.getClient((String)this.thisServer);
            if (client == null) {
                this.printOut("Error : Could not get client");
                this.logToErrorFile("ERROR", this.entity, "Could not get client");
                return null;
            }
            if (!client.isAlive() || !client.isValid()) {
                this.printOut("ERROR : Connection obtained from pool has issues. isAlive? " + client.isAlive() + " isValid? " + client.isValid());
                this.logToErrorFile("ERROR", this.entity, "Connection obtained from pool has issues. isAlive? " + client.isAlive() + " isValid? " + client.isValid());
                return null;
            }
            this.printOut("Got client at timestamp = " + System.currentTimeMillis());
            String string = this.thisServer;
            synchronized (string) {
                Integer n = null;
                n = (Integer)ht_dbg_connTracker.get(this.entity);
                n = n == null ? oneInt : new Integer(n + 1);
                ht_dbg_connTracker.put(this.entity, n);
                this.printOut("DEBUG : OBTAIN : debug conn tracker is " + ht_dbg_connTracker.toString());
            }
            string = JCO.getClientPoolManager().getPool(this.thisServer);
            if (string != null) {
                this.printOut("Pool stats : Num Used : " + string.getNumUsed() + ", Num waiting threads : " + string.getNumWaitingThreads() + ", Max used : " + string.getMaxUsed());
            }
            return client;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception while creating client or connecting with created client to SAP R/3 at " + this.router + this.hostName + ":" + exception.toString());
            this.setErrorMsgForValidation(exception.toString());
            exception.printStackTrace();
            this.printOut("Error: Exception while creating client or connecting with created client to SAP R/3 at " + this.router + this.hostName + ":" + exception.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AsAbapJco2Base(String[] stringArray) {
        String string;
        Object object;
        block22: {
            super(stringArray);
            this.isBapiLoggedIn = false;
            this.unknown_inst = "UNKNOWN";
            this.timestampSDF = new SimpleDateFormat("yyyyMMdd HHmmss");
            this.dateOnlySDF = new SimpleDateFormat("yyyyMMdd");
            this.timeOnlySDF = new SimpleDateFormat("HHmmss");
            this.mySDF = new SimpleDateFormat(myDatePattern);
            this.timeOnlyFormat = "yyyyMMdd_HHmmss";
            this.timeFormat = "yyyyMMdd_HHmmss";
            this.dateOnlyFormat = "yyyyMMdd";
            this.eGTimeFormat = "MM/dd/yyyy HH:mm:ss";
            this.eGDateOnlyFormat = "MM/dd/yyyy";
            this.eGTimeOnlyFormat = "HH:mm ss";
            this.egutil = null;
            this.XMIAuditLevel = "";
            this.AuditLevel = 0;
            this.sessID = null;
            this.isDebugOn = true;
            this.eGSapXMIUser = null;
            this.thisServer = null;
            this.targetOS = "";
            this.errorMsgForValidation = new String("SUCCESS");
            this.instanceNameForValidation = new String("none");
            this.appSrvr = null;
            this.fixedTestPeriod = true;
            this.needAgentlessDD = true;
            this.clientName = this.getValueForParam("clientname");
            this.printOut("clientName ==> " + this.clientName);
            this.sapUser = this.getValueForParam("sapuser");
            this.sapPass = this.getValueForParam("password");
            this.hostName = this.targetHost;
            this.targetOS = this.getValueForParam("os");
            this.router = this.getValueForParam("router");
            this.sysNo = this.getValueForParam("sysno");
            if (this.router == null || this.router.equalsIgnoreCase("none")) {
                this.router = "";
            }
            this.appSrvr = this.getValueForParam("Application_server");
            if (this.appSrvr == null || this.appSrvr.length() == 0) {
                this.appSrvr = this.targetHost;
            }
            this.printOut("appSrvr = " + this.appSrvr);
            this.thisServer = this.reportingName + "#" + this.clientName + "#" + this.sapUser + "#" + this.sysNo;
            this.eGSapXMIUser = "eGAgt" + this.sysNo + "#" + this.sapUser + "#" + this.clientName;
            this.printOut("INFO : SAP connection identifying string, thisServer = " + this.thisServer);
            this.printOut("INFO : Log name of eG user in SAP, eGSapXMIUser = " + this.eGSapXMIUser);
            this.egutil = EgUtilities.createInstance();
            this.printOut("INFO : targethost is " + this.targetHost);
            try {
                object = (Integer)ht_NumCPUs.get(this.reportingName);
                if (object != null) break block22;
                string = "FINDCPU";
                // MONITORENTER : "FINDCPU"
                if (object == null) {
                    try {
                        object = new Integer(this.findNumProcessors());
                    }
                    catch (Exception exception) {
                        object = oneInt;
                    }
                    ht_NumCPUs.put(this.thisServer, object);
                }
                // MONITOREXIT : string
            }
            catch (Exception exception) {
                ht_NumCPUs.put(this.thisServer, oneInt);
            }
        }
        object = this.getValueForParam("timeout");
        if (object == null) {
            object = def_IdleTimeout;
        }
        try {
            this.comm_Timeout = Long.parseLong((String)object) * 800L;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.comm_Timeout = Long.parseLong(def_IdleTimeout) * 800L;
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        string = syncString;
        // MONITORENTER : string
        this.createNewPool();
        // MONITOREXIT : string
        string = this.getValueForParam("instancename");
        this.printOut("tempInstance Name = " + string);
        this.printOut("reportingName = " + this.reportingName);
        if (string == null || string.trim().length() == 0) {
            this.printOut("Instance param value is null.So calling setInstance method to set the instance name");
            this.setInstanceName();
        } else if (string.equalsIgnoreCase("none") || string.equalsIgnoreCase("default")) {
            this.printOut("Instance param is none or default ,So calling setInstance method to set the instance name");
            this.setInstanceName();
        } else {
            String string2 = instanceSyncString1;
            // MONITORENTER : string2
            instanceSyncHashtable.put(this.reportingName, new String(string));
            // MONITOREXIT : string2
        }
        this.printOut("INSTANCE is " + this.getInstanceName() + " for " + this.entity);
    }

    private void createNewPool() {
        int n;
        int n2;
        long l;
        long l2;
        long l3;
        long l4;
        int n3;
        int n4;
        long l5;
        long l6;
        this.printOut("Going to create pool");
        Hashtable hashtable = this.readJCOiniParams();
        boolean bl = false;
        this.connProps = new Properties();
        this.connProps.setProperty("jco.client.client", this.clientName);
        this.connProps.setProperty("jco.client.user", this.sapUser);
        this.connProps.setProperty("jco.client.passwd", this.sapPass);
        this.connProps.setProperty("jco.client.sysnr", this.sysNo);
        this.connProps.setProperty("jco.client.lang", "en");
        this.connProps.setProperty("jco.client.ashost", this.router + this.appSrvr);
        JCO.PoolManager poolManager = null;
        JCO.Pool pool = null;
        try {
            try {
                poolManager = JCO.getClientPoolManager();
            }
            catch (Exception exception) {
                this.printOut("Exception while getting pool manager : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Exception while getting pool manager : " + exception.toString());
                exception.printStackTrace();
            }
            pool = poolManager.getPool(this.thisServer);
        }
        catch (Exception exception) {
            this.printOut("Error : Exception while trying to get pool " + this.thisServer + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Error : Exception while trying to get pool " + this.thisServer + " : " + exception.toString());
        }
        if (pool != null) {
            this.printOut("Pool " + this.thisServer + " exists while trying to create a new pool. Checking for changes in pool's core properties.");
            if (this.corePropsChanged()) {
                try {
                    JCO.removeClientPool((String)this.thisServer);
                    bl = true;
                }
                catch (Exception exception) {
                    this.printOut("Error : Could not remove client pool for " + this.thisServer);
                }
            }
        } else {
            this.printOut("myConnPool   is null ");
            bl = true;
        }
        if (bl) {
            this.printOut("Creating pool for " + this.thisServer);
            try {
                JCO.addClientPool((String)this.thisServer, (int)((Long)hashtable.get("JCOMaxConns")).intValue(), (Properties)this.connProps);
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("clientName", this.clientName);
                hashtable2.put("sapUser", this.sapUser);
                hashtable2.put("sapPass", this.sapPass);
                hashtable2.put("sysNo", this.sysNo);
                hashtable2.put("ashost", this.router + this.appSrvr);
                ht_CoreProps.put(this.thisServer, hashtable2);
            }
            catch (Exception exception) {
                this.printOut("Error : Could not add new client pool for " + this.thisServer + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Could not add new client pool for " + this.thisServer + " : " + exception.toString());
                exception.printStackTrace();
            }
        }
        if ((l6 = (pool = JCO.getClientPoolManager().getPool(this.thisServer)).getConnectionTimeout()) != (l5 = ((Long)hashtable.get("JCOConnTimeout")).longValue())) {
            this.printOut("Setting connection timeout to " + l5 + " ms.");
            pool.setConnectionTimeout(l5);
        }
        if ((n4 = pool.getMaxConnections()) != (n3 = ((Long)hashtable.get("JCOMaxConns")).intValue())) {
            this.printOut("Setting max connections to " + n3);
            pool.setMaxConnections(n3);
        }
        if ((l4 = pool.getMaxWaitTime()) != (l3 = ((Long)hashtable.get("JCOMaxWaitTime")).longValue())) {
            this.printOut("Setting max wait time to " + l3 + " ms.");
            pool.setMaxWaitTime(l3);
        }
        if ((l2 = pool.getTimeoutCheckPeriod()) != (l = ((Long)hashtable.get("JCOTimeoutCheckPeriod")).longValue())) {
            this.printOut("Setting timeout check period to " + l + " ms.");
            pool.setTimeoutCheckPeriod(l);
        }
        if ((n2 = pool.getMaxPoolSize()) != (n = ((Long)hashtable.get("JCOMaxIdleConns")).intValue())) {
            this.printOut("Setting max idle connections (a.k.a max pool size) to " + n);
            pool.setMaxPoolSize(n);
        }
        this.rep = JCO.createRepository((String)this.thisServer, (String)this.thisServer);
    }

    protected String removeString(String string, String string2) {
        int n = string.indexOf(string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 1;
            n = string.indexOf(string2, n + 1);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decryptPassword() {
        String string = syncString;
        synchronized (string) {
            this.sapPass = EgCrypt.decrypt(this.sapPass);
            this.createNewPool();
        }
        this.printOut("Password decrypted and pool updated");
    }

    protected Double getDblFromTable(JCO.Table table, String string) {
        double d = -5.0;
        try {
            d = table.getDouble(string);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from table " + table.getMetaData().getName() + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Could not obtain field " + string + " from table " + table.getMetaData().getName() + " : " + exception.toString());
            d = -5.0;
        }
        return new Double(d);
    }

    protected int getIntFromStruct(JCO.Structure structure, String string) {
        int n = -5;
        try {
            n = structure.getInt(string);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from structure " + structure.getMetaData().getName());
            n = -5;
        }
        return n;
    }

    private boolean corePropsChanged() {
        Hashtable hashtable = (Hashtable)ht_CoreProps.get(this.thisServer);
        if (hashtable == null) {
            this.printOut("Error : Could not find core props changes table for " + this.thisServer);
            return true;
        }
        boolean bl = false;
        String string = null;
        Object var4_4 = null;
        string = (String)hashtable.get("clientName");
        if (!string.equals(this.clientName)) {
            bl = true;
        }
        if (!(string = (String)hashtable.get("sapUser")).equals(this.sapUser)) {
            bl = true;
        }
        if (!(string = (String)hashtable.get("sapPass")).equals(this.sapPass)) {
            bl = true;
        }
        if (!(string = (String)hashtable.get("sysNo")).equals(this.sysNo)) {
            bl = true;
        }
        if (!(string = (String)hashtable.get("ashost")).equals(this.router + this.appSrvr)) {
            bl = true;
        }
        if (!bl) {
            this.printOut("Core properties for pool not changed. Existing pool will be modified if necessary");
        }
        return bl;
    }

    protected Double getDblFromStruct(JCO.Structure structure, String string) {
        Double d = NaDbl;
        String string2 = null;
        try {
            string2 = structure.getString(string);
            try {
                d = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.printOut("Exception while parsing double value " + string2 + " for field " + string + " : " + numberFormatException.toString());
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while parsing double value " + string2 + " for field " + string + " : " + numberFormatException.toString());
                d = NaDbl;
            }
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from structure " + structure.getMetaData().getName());
            d = NaDbl;
        }
        return d;
    }

    private Hashtable readJCOiniParams() {
        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        String string = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOMaxConns");
        hashtable.put("JCOMaxConns", this.parseIniParam("JCOMaxConns", string, 25L, 1));
        String string2 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOMaxIdleConns");
        hashtable.put("JCOMaxIdleConns", this.parseIniParam("JCOMaxIdleConns", string2, 14L, 1));
        String string3 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOConnTimeout");
        hashtable.put("JCOConnTimeout", this.parseIniParam("JCOConnTimeout", string3, 30L, 1000));
        String string4 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOTimeoutCheckPeriod");
        hashtable.put("JCOTimeoutCheckPeriod", this.parseIniParam("JCOTimeoutCheckPeriod", string4, 5L, 1000));
        String string5 = egTesterInfo.getValueFor("AGENT_SETTINGS", "JCOMaxWaitTime");
        hashtable.put("JCOMaxWaitTime", this.parseIniParam("JCOMaxWaitTime", string5, 30L, 1000));
        return hashtable;
    }

    private Long parseIniParam(String string, String string2, long l, int n) {
        if (string2 == null) {
            this.printOut("Warning : Could not find " + string + " in agent eg_tests.ini. Defaulting to " + l);
            return new Long(l);
        }
        Long l2 = null;
        try {
            long l3 = Long.parseLong(string2);
            l2 = new Long(l3 * (long)n);
            this.printOut("JCO connection parameter " + string + " = " + l2);
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            this.printOut("Error : Could not parse " + string + " value " + string2 + " in agent eg_tests.ini. Defaulting to " + l * (long)n);
            return new Long(l * (long)n);
        }
    }

    protected boolean logonToXMI(String string, String string2, JCO.Client client) {
        JCO.Function function = this.createFunction("BAPI_XMI_LOGON");
        if (function == null) {
            return false;
        }
        try {
            function.getImportParameterList().setValue("eGInnovations", "EXTCOMPANY");
            function.getImportParameterList().setValue("eG", "EXTPRODUCT");
            function.getImportParameterList().setValue(string, "INTERFACE");
            function.getImportParameterList().setValue(string2, "VERSION");
            this.executeFunction(function, client, true);
            this.printOut("INFO : Logged onto " + string2 + " version of the " + string + " interface");
            return true;
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to logon to " + string2 + " version of the " + string + " interface: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while trying to logon to " + string2 + " version of the " + string + " interface: " + exception.toString());
            this.printOut(EgInstallInfo.getStackTraceAsString(exception));
            return false;
        }
    }

    protected boolean logonToXMI(JCO.Client client) {
        JCO.Function function = this.createFunction("BAPI_XMI_LOGON");
        if (function == null) {
            return false;
        }
        try {
            function.getImportParameterList().setValue("eGInnovations", "EXTCOMPANY");
            function.getImportParameterList().setValue("eG", "EXTPRODUCT");
            function.getImportParameterList().setValue("XAL", "INTERFACE");
            function.getImportParameterList().setValue("1.0", "VERSION");
            this.executeFunction(function, client, true);
            return true;
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to logon to XMI interface : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to logon to XMI interface : " + exception.toString());
            this.printOut(EgInstallInfo.getStackTraceAsString(exception));
            return false;
        }
    }

    protected void logoffAndReleaseClient(JCO.Client client) {
        JCO.Function function;
        long l = System.currentTimeMillis();
        if (this.rep != null && (function = this.createFunction("BAPI_XMI_LOGOFF")) != null) {
            try {
                this.executeFunction(function, client, true);
                this.printOut("Executed XMI Logoff");
            }
            catch (Exception exception) {
                this.printOut("Exception while executing XMI Logoff! : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Exception while Logging off from XMI : " + exception.toString());
            }
        }
        this.releaseClient(client);
        this.printOut("releaseConnect took " + (System.currentTimeMillis() - l) + "ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseClient(JCO.Client client) {
        if (client != null) {
            try {
                JCO.releaseClient((JCO.Client)client);
                this.printOut("Released the client connection. Timestamp = " + System.currentTimeMillis());
            }
            catch (Exception exception) {
                this.printOut("Exception while disconnecting client " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Error disconnecting client : " + exception.toString());
            }
            String string = this.thisServer;
            synchronized (string) {
                Integer n = null;
                n = (Integer)ht_dbg_connTracker.get(this.entity);
                if (n == null) {
                    this.printOut("Error :  Should not occur. While releasing conn, # conn null for entity " + this.entity);
                } else {
                    n = new Integer(n - 1);
                }
                ht_dbg_connTracker.put(this.entity, n);
                this.printOut("DEBUG : RELEASE : debug conn tracker is " + ht_dbg_connTracker.toString());
            }
        }
    }

    protected JCO.Function createFunction(String string) {
        JCO.Function function = null;
        try {
            function = this.createFunction(string, this.rep);
        }
        catch (Exception exception) {
            this.printOut("ERROR : IFunctionTemplate is null. Could not create function " + string);
            this.logToErrorFile("ERROR", this.entity, "ERROR : IFunctionTemplate is null. Could not create function " + string);
            exception.printStackTrace();
            return null;
        }
        return function;
    }

    protected JCO.Function createFunction(String string, IRepository iRepository) {
        try {
            JCO.Function function = null;
            IFunctionTemplate iFunctionTemplate = iRepository.getFunctionTemplate(string.toUpperCase());
            if (iFunctionTemplate == null) {
                this.printOut("ERROR : IFunctionTemplate is null. Could not create function " + string);
                this.logToErrorFile("ERROR", this.entity, "ERROR : IFunctionTemplate is null. Could not create function " + string);
                return null;
            }
            function = iFunctionTemplate.getFunction();
            return function;
        }
        catch (Exception exception) {
            this.printOut("ERROR : IFunctionTemplate is null. Could not create function " + string);
            this.logToErrorFile("ERROR", this.entity, "ERROR : IFunctionTemplate is null. Could not create function " + string);
            exception.printStackTrace();
            return null;
        }
    }

    protected boolean executeCommand(JCO.Client client) {
        try {
            JCO.ParameterList parameterList = JCO.createParameterList();
            JCO.ParameterList parameterList2 = JCO.createParameterList();
            parameterList2.addInfo("ECHOTEXT", 0, 255);
            parameterList2.addInfo("RESPTEXT", 0, 255);
            client.execute("STFC_CONNECTION", parameterList, parameterList2);
            this.setInstanceNameForValidation(this.collectInstanceName());
            this.printOut("Executed command");
            return true;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception in executeCommand method : " + exception.toString());
            return false;
        }
    }

    protected void runThread(JFnThread jFnThread, String string) throws Exception {
        this.runThread(jFnThread, string, 50L);
    }

    protected void runThread(JFnThread jFnThread, String string, long l) throws Exception {
        jFnThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        long l4 = System.currentTimeMillis() - l2;
        while (jFnThread.isAlive() && l4 < this.comm_Timeout) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string2 = "";
        if (jFnThread.isAlive()) {
            this.printOut("Thread " + string + " is still it is alive.");
            if (jFnThread.status == -1) {
                bl = true;
                string2 = " timed out with exception : " + jFnThread.errMsg;
            } else {
                bl = true;
                string2 = " timed out.";
            }
        } else {
            this.printOut("Thread " + string + " completed successfully in " + l4 + " ms.");
            if (jFnThread.status != 1) {
                if (jFnThread.status == -1) {
                    bl = true;
                    string2 = " got done with exception : " + jFnThread.errMsg;
                } else {
                    this.logToErrorFile("ERROR : ", this.entity, "Thread aborted without exception. " + string);
                    bl = true;
                    string2 = "aborted without exception";
                }
            }
        }
        if (bl) {
            jFnThread.interrupt();
            this.printOut("DEBUG : Thread " + string + " is interrupted. Total thread execution time is = " + l4);
            this.logToErrorFile("DEBUG : ", this.entity, "Thread " + string + " is interrupted. Total thread execution time is = " + l4);
            long l5 = System.currentTimeMillis();
            try {
                Thread.yield();
                long l6 = 0L;
                boolean bl2 = false;
                long l7 = Math.round((double)(this.measurePeriod * 1000L - l4) * 0.8);
                long l8 = 86001L;
                if (l7 < l8 && l7 > 0L) {
                    l6 = l7;
                } else if (l8 <= l7) {
                    l6 = l8;
                } else {
                    this.printOut("ERROR : " + this.entity + " Cannot caluclate checkTime. So default to 40 sec wait");
                    this.logToErrorFile("ERROR : ", this.entity, "Cannot caluclate checkTime. So default to 40 sec wait");
                    l6 = 40000L;
                }
                long l9 = System.currentTimeMillis();
                while (jFnThread.isAlive() && !bl2) {
                    long l10 = System.currentTimeMillis();
                    long l11 = l10 - l9;
                    if (l11 > l6) {
                        bl2 = true;
                        this.printOut("ERROR : Long running thread found. Thread total time=" + l11 + " ms check time=" + l6 + " ms");
                        this.logToErrorFile("ERROR : ", this.entity, "Long running thread found. Thread total time=" + l11 + " ms check time=" + l6 + " ms");
                    }
                    if (bl2) continue;
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.printOut("Error: Thread " + string + " with status " + string2 + " itself got interrupted when joining monitored thread and waiting for it to get completed for " + (System.currentTimeMillis() - l5) + " ms.");
                this.logToErrorFile("ERROR", this.entity + " : " + this.reportingName, "Error: Thread " + string + " with status " + string2 + " itself got interrupted when joining monitored thread and waiting for it to get completed for " + (System.currentTimeMillis() - l5) + " ms.");
                throw new Exception("Thread " + string + " " + string2 + " and could not terminate after " + (System.currentTimeMillis() - l5) + " ms.");
            }
            this.printOut("Error: Thread " + string + " " + string2 + " Thread state = " + jFnThread.isAlive());
            this.logToErrorFile("ERROR", this.entity, "Thread " + string + string2 + " Thread state = " + jFnThread.isAlive());
            if (jFnThread.excpn != null) {
                this.printOut("Exception stack trace : " + EgInstallInfo.getStackTraceAsString(jFnThread.excpn));
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, EgInstallInfo.getStackTraceAsString(jFnThread.excpn));
            }
            throw new Exception("Thread " + string + " " + string2);
        }
    }

    protected void executeFunction(JCO.Function function, JCO.Client client, boolean bl) throws Exception {
        if (client != null) {
            String string = function.getName();
            long l = System.currentTimeMillis();
            this.runThread(new JFnThread(function, client, bl), string);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 > 50L) {
                this.printOut("Time taken to execute function " + string + " is " + (System.currentTimeMillis() - l) + " ms.");
            }
        } else {
            this.printOut("ERROR : Cannot execute monitored Bapi function as client connection is null");
            this.logToErrorFile("ERROR", this.entity, "Cannot execute monitored Bapi function as client connection is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getSystemTimestamp() {
        Calendar calendar = null;
        Long l = null;
        long l2 = 0L;
        long l3 = 0L;
        Date date = null;
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = null;
        String string3 = this.thisServer;
        synchronized (string3) {
            calendar = (Calendar)ht_SapTimeCal.get(this.thisServer);
            l = (Long)ht_QueryTimeMillis.get(this.thisServer);
            if (calendar == null) {
                calendar = Calendar.getInstance();
                ht_SapTimeCal.put(this.thisServer, calendar);
                this.printOut("DEBUG : Creating calendar object for component id " + this.thisServer);
            }
            long l4 = System.currentTimeMillis();
            long l5 = 0L;
            long l6 = 0L;
            if (l != null) {
                l3 = l;
            }
            if ((l6 = l4 - l3) > 86400000L) {
                this.printOut("diffQueryMillis is " + l6 + ". Connecting to SAP to refresh system time");
                JCO.Client client = null;
                try {
                    client = this.getConnection();
                }
                catch (Exception exception) {
                    this.printOut("ERROR : Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
                    this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
                    return null;
                }
                JCO.Function function = this.createFunction("MSS_GET_SY_DATE_TIME");
                if (function == null) {
                    return null;
                }
                try {
                    this.executeFunction(function, client, false);
                }
                catch (Exception exception) {
                    this.printOut("Error : Exception while executing MSS_GET_SY_DATE_TIME : " + exception.toString());
                    this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while executing RFM MSS_GET_SY_DATE_TIME : " + exception.toString());
                    exception.printStackTrace();
                    this.releaseClient(client);
                    return null;
                }
                string = function.getExportParameterList().getString("SAPDATE");
                string = this.removeString(string, "-");
                string2 = function.getExportParameterList().getString("SAPTIME");
                string2 = this.removeString(string2, ":");
                this.printOut("Got SAP system date time : " + string + " " + string2);
                try {
                    date = this.timestampSDF.parse(string + " " + string2);
                }
                catch (Exception exception) {
                    this.printOut("Exception while parsing SAP system timestamp '" + string + " " + string2 + "' : " + exception.toString());
                    this.logToErrorFile("ERROR", this.entity + " " + this.reportingName, "Exception while parsing SAP system timestamp '" + string + " " + string2 + "' : " + exception.toString());
                    return null;
                }
                this.releaseClient(client);
                calendar.setTime(date);
                ht_QueryTimeMillis.put(this.thisServer, new Long(l4));
            } else {
                l = (Long)ht_GetTimeMillis.get(this.thisServer);
                l2 = l;
                l5 = l4 - l2;
                calendar.add(14, (int)l5);
                date = calendar.getTime();
                String string4 = this.timestampSDF.format(date);
                int n = string4.indexOf(" ");
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
            ht_GetTimeMillis.put(this.thisServer, new Long(l4));
        }
        arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    protected ArrayList getEndAndStartTimestamps(long l) {
        return this.getEndAndStartTimestamps(l, false);
    }

    protected ArrayList getEndAndStartTimestamps(long l, boolean bl) {
        ArrayList<String> arrayList = this.getSystemTimestamp();
        if (arrayList == null) {
            return null;
        }
        Date date = null;
        try {
            try {
                date = this.timestampSDF.parse((String)arrayList.get(0) + " " + (String)arrayList.get(1));
            }
            catch (NumberFormatException numberFormatException) {
                this.printOut("Error : Exception while parsing date " + date.toString() + " : " + numberFormatException.toString());
                this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Error : Exception while parsing date " + date.toString() + " : " + numberFormatException.toString());
                return null;
            }
        }
        catch (ParseException parseException) {
            this.printOut("Error : Exception while parsing date " + date.toString() + " : " + parseException.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Error : Exception while parsing date " + date.toString() + " : " + parseException.toString());
            return null;
        }
        arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        string = this.dateOnlySDF.format(date);
        string2 = this.timeOnlySDF.format(date);
        arrayList.add(string);
        arrayList.add(string2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (!bl) {
            long l2 = l / 1000L;
            this.printOut("Measure period or CuttOff in seconds is " + l2);
            calendar.add(13, (int)(-l2));
        } else {
            calendar.add(10, (int)(-l));
        }
        Date date2 = calendar.getTime();
        string = this.dateOnlySDF.format(date2);
        string2 = this.timeOnlySDF.format(date2);
        this.printOut("Converted start date and start time are " + string + " and " + string2);
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    protected ArrayList getEndAndStartTimestamps() {
        return this.getEndAndStartTimestamps(this.measurePeriod);
    }

    protected long getDateDiff(ArrayList arrayList, String string, String string2) {
        return this.getDateDiff((String)arrayList.get(0), (String)arrayList.get(1), string, string2);
    }

    protected long getDateDiff(String string, String string2, String string3, String string4) {
        Date date = null;
        try {
            date = this.timestampSDF.parse(string + " " + string2);
        }
        catch (ParseException parseException) {
            this.printOut("ERROR: could not parse system timestamp '" + string + " " + string2 + "' : " + parseException.toString());
            return Long.MAX_VALUE;
        }
        Date date2 = null;
        try {
            date2 = this.timestampSDF.parse(string3 + " " + string4);
        }
        catch (ParseException parseException) {
            this.printOut("ERROR: could not parse date2 timestamp '" + string3 + " " + string4 + "' : " + parseException.toString());
            return Long.MAX_VALUE;
        }
        long l = date.getTime() - date2.getTime();
        return l;
    }

    protected void addToSortedList(ArrayList arrayList, int n, ArrayList arrayList2) {
        this.addToSortedList(arrayList, n, arrayList2, 3);
    }

    protected void addToSortedList(ArrayList arrayList, int n, ArrayList arrayList2, int n2) {
        try {
            Double d = (Double)arrayList2.get(n);
            Double d2 = null;
            ArrayList arrayList3 = null;
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList3 = (ArrayList)arrayList.get(i);
                d2 = (Double)arrayList3.get(n);
                if (!(d > d2)) continue;
                arrayList.set(i, arrayList2);
                this.addToSortedList(arrayList, n, arrayList3, n2);
                bl = true;
                break;
            }
            if (!bl) {
                if (n2 > 0) {
                    if (arrayList.size() < n2) {
                        arrayList.add(arrayList2);
                    }
                } else {
                    arrayList.add(arrayList2);
                }
            }
            if (n2 > 0 && arrayList.size() > n2) {
                arrayList.remove(n2);
            }
        }
        catch (Exception exception) {
            this.printOut("ERROR : Error in addToSortedList method : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "ERROR : Error in addToSortedList method : " + exception.toString());
        }
    }

    private void testGetDateDiff() {
        ArrayList arrayList = this.getSystemTimestamp();
        long l = 0L;
        l = this.getDateDiff(arrayList, "20130923", "143000");
        this.printOut("Millis Diff for 20130923 143000 = " + l);
        l = this.getDateDiff(arrayList, "20130923", "160000");
        this.printOut("Millis Diff for 20130923 160000 = " + l);
        if (l == Long.MAX_VALUE) {
            this.printOut("Millis Diff = found to be incorrect");
        } else {
            this.printOut("Millis Diff  = " + l);
        }
    }

    protected boolean isClassifiedActive(ArrayList arrayList, String string, long l) {
        if (arrayList == null) {
            return false;
        }
        Object var5_4 = null;
        Date date = null;
        long l2 = this.getDateDiff(arrayList, (String)arrayList.get(0), string);
        if (l2 < 0L) {
            ArrayList arrayList2 = (ArrayList)arrayList.clone();
            try {
                date = this.timestampSDF.parse((String)arrayList2.get(0) + " " + string);
            }
            catch (ParseException parseException) {
                this.printOut("ERROR: could not parse timestamp '" + (String)arrayList.get(0) + " " + string + "' : " + parseException.toString());
                return false;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -1);
            this.printOut("Subtracted 1 day from user time");
            String string2 = this.dateOnlySDF.format(date);
            l2 = this.getDateDiff(arrayList, string2, string);
        }
        long l3 = l2 / 60000L;
        return l3 <= l;
    }

    public int findNumProcessors() {
        int n = 1;
        try {
            String string = System.getProperty("os.name");
            this.printOut("INFO : Agent Os = " + string);
            if (this.targetOS == null || this.targetOS.trim().length() == 0 || this.targetOS.equalsIgnoreCase("none")) {
                this.targetOS = string;
            }
            n = this.targetOS.trim().toLowerCase().indexOf("win") != -1 ? this.getNumProcessorsInWindows(this.targetOS, this.meAgentless) : (this.targetOS.trim().toLowerCase().indexOf("hpux") != -1 ? this.getNumProcessorsInHPUX() : this.getNumProcessorsInUnix());
        }
        catch (Exception exception) {
            this.printOut("Exception raised inside findNumofProcessors");
            this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, "Exception raised inside findNumOfProcessors  method " + exception.toString());
        }
        if (n < 1) {
            return 1;
        }
        this.printOut("Num Processors : " + n);
        return n;
    }

    private int getNumProcessorsInWindows(String string, boolean bl) {
        try {
            if (string != null) {
                string = string.trim().toLowerCase();
            }
            int n = 0;
            String[] stringArray = null;
            if (string.indexOf("2008") > -1 || string.indexOf("2012") > -1 || string.indexOf("win7") > -1 || string.indexOf("win8") > -1) {
                stringArray = bl ? EgJNIUtil.discoverPdhInstances((String)"Processor Information", (String)this.appSrvr) : EgJNIUtil.discoverInstances((String)"Processor Information", (boolean)false);
                if (stringArray != null && stringArray.length > 0) {
                    String string2 = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string2 = stringArray[i];
                        if (string2 == null || string2.trim().toLowerCase().indexOf("total") != -1) continue;
                        ++n;
                    }
                }
            } else if (string.indexOf("win") != -1 && (stringArray = bl ? EgJNIUtil.discoverPdhInstances((String)"Processor", (String)this.appSrvr) : EgJNIUtil.discoverInstances((String)"Processor", (boolean)false)) != null && stringArray.length > 0) {
                String string3 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = stringArray[i];
                    if (string3 == null || string3.trim().toLowerCase().indexOf("total") != -1) continue;
                    ++n;
                }
            }
            this.printOut("No of Processors  :" + n);
            this.printOut("agentless         :" + bl);
            if (n < 1) {
                return 1;
            }
            return n;
        }
        catch (Exception exception) {
            this.printOut("Exception raised inside findNumofProcessors (windows)");
            this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, "Exception raised inside findNumOfProcessors  method (windows) " + exception.toString());
            return 1;
        }
    }

    private int getNumProcessorsInHPUX() {
        try {
            ArrayList arrayList = this.egutil.getExecOutputLines("/usr/sbin/ioscan -fkn -C processor");
            if (arrayList == null || arrayList.size() < 2) {
                return 1;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return 1;
            }
            int n = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string = (String)arrayList2.get(i);
                if (!(string = string.toLowerCase()).startsWith("processor")) continue;
                ++n;
            }
            if (n == 0) {
                return 1;
            }
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public int getNumProcessorsInUnix() {
        try {
            String string = "cat /proc/cpuinfo | grep processor | wc -l";
            ArrayList arrayList = this.egutil.getExecOutputLines(string);
            if (arrayList == null || arrayList.size() < 2) {
                return 1;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return 1;
            }
            int n = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (string2 == null) continue;
                string2 = string2.trim();
                n = Integer.parseInt(string2);
            }
            if (n == 0) {
                return 1;
            }
            return n;
        }
        catch (Exception exception) {
            this.printOut("Exception raised inside findNumofProcessors (unix)");
            this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, "Exception raised inside findNumOfProcessors  method (unix) " + exception.toString());
            return 1;
        }
    }

    protected String convertTimeStampForEG(String string) {
        String string2 = "";
        if (string.trim().length() < 2) {
            this.printOut("Warning : Could not convert timestamp '" + string + "'");
            return string2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in convertTimeStampForEG()  :" + exception.toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in convertTimeStampForEG()  :" + exception.toString());
        }
        return string2;
    }

    protected String convertDateOnlyFormatEG(String string) {
        String string2 = "";
        if (string.trim().length() < 1) {
            this.printOut("Warning : Could not convert date '" + string + "'");
            return string2;
        }
        if (string.trim().equals("_")) {
            this.printOut("Warning : Got empty date for DD '" + string + "'");
            return "-";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in convertDateOnlyFormatEG()  :" + exception.toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in convertDateOnlyFormatEG()  :" + exception.toString());
        }
        return string2;
    }

    protected String convertTimeOnlyFormatEG(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        String string2 = "";
        if (string.length() < 2) {
            return string2;
        }
        if (string.trim().equals("_")) {
            this.printOut("Warning : Got empty time for DD '" + string + "'");
            return "-";
        }
        try {
            Date date = simpleDateFormat.parse(string);
            string2 = simpleDateFormat2.format(date);
            string2 = string2.substring("MM/dd/yyyy".length() + 1);
            string2 = string2.trim();
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in convertTimeOnlyFormatEG()  :" + exception.toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in convertTimeOnlyFormatEG()  :" + exception.toString());
        }
        return string2;
    }

    protected long timeStampToMillsecond(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        long l = this.timeStampToMillsecond(string, simpleDateFormat);
        simpleDateFormat = null;
        return l;
    }

    protected long timeStampToMillsecond(String string, SimpleDateFormat simpleDateFormat) {
        long l = 0L;
        try {
            Date date = simpleDateFormat.parse(string);
            l = date.getTime();
        }
        catch (Exception exception) {
            this.printOut(this.entity + " " + this.reportingName + "    Error  in timeStampToMillsecond()  :" + exception.getMessage().toString());
            this.logToErrorFile("Error  ", this.entity + " " + this.reportingName, "Error  in timeStampToMillsecond()  :" + exception.getMessage().toString());
        }
        return l;
    }

    public void printOut(String string) {
        System.out.println(" >> " + this.reportingName + " : " + this.entity + ": [ " + this.mySDF.format(new Date()) + " ] : >> " + string);
    }

    protected double roundDouble(double d, int n) {
        Object object;
        double d2 = 0.0;
        Object object2 = "";
        if (n <= 0) {
            object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
        } else {
            String string;
            object = "";
            if (d < 0.0) {
                object = (String)object + "-";
                d = -d;
            }
            if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                int n2 = (int)d;
                object = (String)object + n2;
                d -= (double)n2;
            } else {
                object = (String)object + "0";
            }
            if (d > 0.0) {
                String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                object = (String)object + "." + string2.substring(1);
            }
            object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
        }
        object = new Double((String)object2);
        d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        return d2;
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    protected String getDDStringFromTable(JCO.Table table, String string) {
        String string2 = table.getString(string);
        if (string2 == null) {
            return "-";
        }
        if ((string2 = string2.trim()).length() == 0) {
            return "-";
        }
        return string2;
    }

    protected int getIntFromTable(JCO.Table table, String string) {
        return this.getIntFromTable(table, string, -5);
    }

    protected int getIntFromTable(JCO.Table table, String string, int n) {
        int n2 = n;
        try {
            n2 = table.getInt(string);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not obtain field " + string + " from table " + table.getMetaData().getName() + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Could not obtain field " + string + " from table " + table.getMetaData().getName() + " : " + exception.toString());
            n2 = n;
        }
        return n2;
    }

    public String removePrefixSuffix(String string, String string2, boolean bl) {
        if ((string = string.trim()).length() == 2 * string2.length()) {
            if (bl) {
                return "-";
            }
            return "";
        }
        if (string.startsWith(string2)) {
            string = string.substring(1);
        }
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getTCodeDesc(String string) {
        String string2 = (String)ht_TCodeMap.get(string);
        return string2;
    }

    public static void main(String[] stringArray) {
        AsAbapJco2Base asAbapJco2Base;
        JCO.Client client;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        if ((client = (asAbapJco2Base = new AsAbapJco2Base(stringArray)).getConnection()) == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            asAbapJco2Base.printOut("Current System time is " + asAbapJco2Base.getSystemTimestamp());
            if (i == 2) {
                instanceSyncHashtable.put(asAbapJco2Base.reportingName, asAbapJco2Base.unknown_inst);
                System.out.println("instance name set to unknown");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            asAbapJco2Base.setInstanceName();
            System.out.println("instance name is " + asAbapJco2Base.getInstanceName());
        }
    }

    private String collectInstanceName() {
        System.out.println("Calling collectInstanceName method in Asabap base");
        String string = "TH_SERVER_LIST";
        JCO.Client client = null;
        try {
            client = this.getConnection();
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
            return this.unknown_inst;
        }
        JCO.Function function = this.createFunction(string);
        if (function == null) {
            this.releaseClient(client);
            return this.unknown_inst;
        }
        long l = System.currentTimeMillis();
        try {
            this.executeFunction(function, client, false);
        }
        catch (Exception exception) {
            this.printOut("Error : Exception while executing " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + " : " + this.thisServer, "Exception while executing " + string + " : " + exception.toString());
            this.releaseClient(client);
            exception.printStackTrace();
            return this.unknown_inst;
        }
        this.printOut("DEBUG : " + string + " successfully executed in " + (System.currentTimeMillis() - l) + " ms.");
        String string2 = this.unknown_inst;
        JCO.Table table = function.getTableParameterList().getTable("LIST");
        String string3 = null;
        if (table != null && table.getNumRows() == 0) {
            this.printOut("ERROR : main LIST table empty while trying to get instance list. Trying LIST_IPV6 table instead");
            this.logToErrorFile("ERROR", this.entity, "main LIST table empty while trying to get instance list. Trying LIST_IPV6 table instead");
            table = function.getTableParameterList().getTable("LIST_IPV6");
        }
        this.printOut("Table is :" + table);
        for (int i = 0; i < table.getNumRows(); ++i) {
            table.setRow(i);
            string3 = table.getString("NAME").trim();
            if (string3.indexOf(this.sysNo) <= -1) continue;
            string2 = string3;
            break;
        }
        this.printOut("DEBUG : Determined the instance name to be " + string2);
        this.releaseClient(client);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstanceName() {
        String string = this.getInstanceName();
        if (!(string == null || string.equalsIgnoreCase("none") || string.equalsIgnoreCase("default") || string.equalsIgnoreCase(this.unknown_inst))) {
            this.printOut("Instance name already set");
            return;
        }
        String string2 = instanceSyncString1;
        synchronized (string2) {
            String string3 = null;
            string3 = (String)instanceSyncHashtable.get(this.reportingName);
            String string4 = this.collectInstanceName();
            this.printOut("Calling setInstanceName method in Asabap base ");
            instanceSyncHashtable.put(this.reportingName, new String(string4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getInstanceName() {
        String string = null;
        System.out.println("Calling getInstanceName method in Asabap base ");
        String string2 = instanceSyncString1;
        synchronized (string2) {
            string = (String)instanceSyncHashtable.get(this.reportingName);
        }
        return string;
    }

    public String getErrorMsgForValidation() {
        return this.errorMsgForValidation;
    }

    public void setErrorMsgForValidation(String string) {
        this.errorMsgForValidation = string;
    }

    public String getInstanceNameForValidation() {
        return this.instanceNameForValidation;
    }

    public void setInstanceNameForValidation(String string) {
        this.instanceNameForValidation = string;
    }

    static {
        ht_CoreProps = new Hashtable();
        ht_SapTimeCal = new Hashtable();
        ht_GetTimeMillis = new Hashtable();
        ht_QueryTimeMillis = new Hashtable();
        ht_dbg_connTracker = new Hashtable();
        fieldSep = new String("");
        ht_NumCPUs = new Hashtable();
        errCodeTbl = new Hashtable();
        errCodeTbl.put("RA 334", "The specified alert ID is not defined");
        errCodeTbl.put("RA 335", "The specified alert ID is invalid");
        errCodeTbl.put("RA 336", "The C function that was ultimately called could not be exe-cuted");
        errCodeTbl.put("RA 337", "The method could not be executed due to communication problems (you should possibly check the network connection)");
        errCodeTbl.put("RA 338", "An internal problem occurred");
        errCodeTbl.put("RA 339", "The specified TID is not defined");
        errCodeTbl.put("RA 340", "The specified TID is invalid");
        errCodeTbl.put("RA 341", "An unknown problem occurred during the execution of the method");
        errCodeTbl.put("RA 342", "The underlying function call could not be performed (the func-tion parameters may be incorrectly set)");
        errCodeTbl.put("RA 343", "The required segment is not available");
        errCodeTbl.put("RA 344", "Could not expand the name of the MTE");
        errCodeTbl.put("RA 345", "The name of the MTE was note found");
        errCodeTbl.put("RA 346", "There was a problem accessing the database");
        errCodeTbl.put("RA 347", "The specified time range is invalid");
        errCodeTbl.put("RA 350", "No monitor sets were found");
        errCodeTbl.put("RA 351", "The name of the monitor set was not specified");
        errCodeTbl.put("RA 352", "The name of the monitor set is incorrect");
        errCodeTbl.put("RA 353", "The specified monitor set is empty or contains no monitors");
        errCodeTbl.put("RA 354", "The (display) properties could not be determined");
        errCodeTbl.put("RA 355", "The name of the monitor was not specified");
        errCodeTbl.put("RA 356", "The name of the monitor is invalid");
        errCodeTbl.put("RA 357", "The required data could not be read from the database");
        errCodeTbl.put("RA 361", "The monitor template is not defined");
        errCodeTbl.put("RA 362", "The monitoring tree could not be determined");
        errCodeTbl.put("RA 593", "The monitoring tree elements of the monitoring tree were not specified");
        errCodeTbl.put("RA 594", "One of the specified top nodes is invalid");
        errCodeTbl.put("RA 595", "The alert data could not be collected");
        errCodeTbl.put("RA 594", "One of the specified monitoring tree elements is invalid");
        errCodeTbl.put("RA 596", "No alerts were found");
        errCodeTbl.put("RA 377", "The requests for history data were not defined");
        errCodeTbl.put("RA 378", "An invalid type of history data was requested");
        errCodeTbl.put("RA 379", "An invalid time range was defined for history data");
        errCodeTbl.put("RA 380", "The time range was not defined");
        errCodeTbl.put("RA 381", "An error occurred while accessing another SAP R/3 System");
        errCodeTbl.put("RA 404", "The system ID was not specified");
        errCodeTbl.put("RA 405", "The name of the context was not specified");
        errCodeTbl.put("RA 406", "The specified variant is not defined");
        errCodeTbl.put("RA 407", "The specified user is not the owner of the variant");
        errCodeTbl.put("RA 408", "The Customizing settings of the specified system cannot be changed from this system");
        errCodeTbl.put("RA 409", "No data available for the MTE class of the MTE");
        errCodeTbl.put("RA 410", "No TID-specific data available for the MTE");
        errCodeTbl.put("RA 422", "The specified variant could not be created");
        errCodeTbl.put("RA 495", "You are not authorized to use the specified function");
        errCodeTbl.put("XM 048", "The name of the external user was not specified in the call. This name specifies which user started the method call in the external system");
        errCodeTbl.put("XM 031", "The method call was terminated due to an error in the SAP R/3 XMI logging system");
        errCodeTbl.put("XM 028", "The external system management tool did not log on to the CCMS XMI interface. The method call was therefore termi-nated");
        ht_TCodeMap.put("RFC", "RFC - Remote Function Call");
    }

    class JFnThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;
        JCO.Client thisClient = null;
        final JCO.Function jFn;
        String errMsg;
        Exception excpn;
        boolean checkErr = true;

        JFnThread(JCO.Function function, JCO.Client client, boolean bl) {
            this.jFn = function;
            this.thisClient = client;
            this.checkErr = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            try {
                this.thisClient.execute(this.jFn);
                if (this.checkErr) {
                    JCO.Structure structure = this.jFn.getExportParameterList().getStructure("RETURN");
                    String string = structure.getString("TYPE").trim();
                    if (string.length() > 0 && !string.equals("S") && !string.equals("I")) {
                        String string2 = structure.getString("ID") + " " + structure.getString("NUMBER");
                        if (string2.equals("RA 340")) {
                            this.status = 1;
                        } else {
                            String string3;
                            this.errMsg = string3 = structure.getString("MESSAGE") + "." + (String)errCodeTbl.get(string2);
                            AsAbapJco2Base.this.printOut("ERROR : BAPI method " + this.jFn.getName() + " did not execute successfully : " + string3);
                            this.status = -1;
                        }
                    } else {
                        this.status = 1;
                    }
                } else {
                    this.status = 1;
                }
            }
            catch (Exception exception) {
                AsAbapJco2Base.this.printOut("Exception while executing JCO function " + this.jFn.toString() + " : " + exception.toString());
                AsAbapJco2Base.this.logToErrorFile("ERROR", AsAbapJco2Base.this.entity, " Exception while executing JCO function " + this.jFn.toString() + " : " + exception.toString());
                this.errMsg = "Exception while executing JCO function " + this.jFn.toString() + " : " + exception.toString() + " : ";
                this.excpn = exception;
                this.status = -1;
            }
            finally {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 > 5000L) {
                    AsAbapJco2Base.this.printOut("Function " + this.jFn.getName() + " took more than 5 seconds to execute. Actual time taken = " + l3 + " ms.");
                }
            }
        }
    }
}

