/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class BatteryDetailsTest
extends EgSnmpGenericTest {
    private static String totalNoOfExternalBatteriesOid = ".1.3.6.1.4.1.318.1.1.1.2.2.5";
    private static String noOfBadExternalBatteriesOid = ".1.3.6.1.4.1.318.1.1.1.2.2.6";
    private static String batteryNominalVoltageOid = ".1.3.6.1.4.1.318.1.1.1.2.2.7";
    private static String batteryActualVoltageOid = ".1.3.6.1.4.1.318.1.1.1.2.2.8";
    private static String batteryCurrentOid = ".1.3.6.1.4.1.318.1.1.1.2.2.9";
    private static String batteryDcCurrentOid = ".1.3.6.1.4.1.318.1.1.1.2.2.10";
    private static int numMeasures = 6;

    public BatteryDetailsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
            if (d < 0.0) {
                d = -5.0;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "BatteryDetailsTest Exception occured in getValue() for " + this.targetHost, exception.toString());
            d = -5.0;
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        if (this.runSnmpCmdForOid(totalNoOfExternalBatteriesOid)) {
            d = this.getValue(0);
        }
        if (this.runSnmpCmdForOid(noOfBadExternalBatteriesOid)) {
            d2 = this.getValue(0);
        }
        if (this.runSnmpCmdForOid(batteryNominalVoltageOid)) {
            d3 = this.getValue(0);
        }
        if (this.runSnmpCmdForOid(batteryActualVoltageOid)) {
            d4 = this.getValue(0);
        }
        if (this.runSnmpCmdForOid(batteryCurrentOid)) {
            d5 = this.getValue(0);
        }
        if (this.runSnmpCmdForOid(batteryDcCurrentOid)) {
            d6 = this.getValue(0);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d6));
        System.out.println("MeasureList :  " + arrayList);
        this.addNewMeasure(arrayList);
    }
}

