/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CacheStatsBase
extends GenericTest {
    private static String syncFlag = "cache";
    private String deLimit = ":";
    private static Hashtable htLastTime = new Hashtable();
    private Hashtable instanceParams = new Hashtable();
    private String path = null;
    public static Hashtable htProcessTable = new Hashtable();
    public static Hashtable htSysTable = new Hashtable();
    public static Hashtable htResourceTable = new Hashtable();
    public static Hashtable htLocksTable = new Hashtable();
    private ArrayList sysList = new ArrayList();
    private ArrayList processList = new ArrayList();
    private ArrayList jobsList = new ArrayList();
    private ArrayList resourceList = new ArrayList();
    private ArrayList locksList = new ArrayList();

    public CacheStatsBase(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("instanceDirectory");
        if (string == null || string.equals("")) {
            this.logToErrorFile("ERROR", "CacheStatsBase", "Cache installed Directory is not configured");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(this.deLimit, 1);
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.instanceParams.put(string3, string4);
        }
    }

    public boolean computeStats() {
        Enumeration enumeration = this.instanceParams.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.instanceParams.get(string);
            if (string2 == null || string2.length() == 0) continue;
            String string3 = string2 + "/bin/cstat -s " + string2 + "/mgr  -e2 -m-1 -n3 -j5 -g1 -m3 -L1 -u-1 -v1 -p-1 -c-1 -q1 -w2 -S -1";
            ArrayList arrayList = new ArrayList();
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList = egUtilities.getExecOutputLines(string3);
            if (arrayList == null || arrayList.size() < 2) {
                return false;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null) {
                return false;
            }
            block1: for (int i = 0; i < arrayList2.size(); ++i) {
                String string4;
                String string5 = (String)arrayList2.get(i);
                if (string5 == null || string5.equals(" ")) continue;
                if ((string5 = string5.trim()).startsWith("job: ")) {
                    string4 = "";
                    while ((string4 = (String)arrayList2.get(i)) != null) {
                        string4 = string4.trim();
                        this.processList.add(string4);
                        if (string4.startsWith("Transaction(s)")) break;
                        ++i;
                    }
                }
                if (string5.startsWith("Global references (all)")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("Global update")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("Routine calls")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("Routine buffer loads and saves")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("Block i/o reads")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("Block i/o writes")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("WIJ i/o writes")) {
                    this.sysList.add(string5);
                }
                if (string5.startsWith("Logical block requests")) {
                    this.sysList.add(string5);
                }
                if ((string5 = string5.trim()).startsWith("RESOURCE STATS")) {
                    string4 = "";
                    while ((string4 = (String)arrayList2.get(i)) != null) {
                        if ((string4 = string4.trim()).startsWith(" ")) continue;
                        this.resourceList.add(string4);
                        if (string4.startsWith("RESOURCE % STATS")) break;
                        ++i;
                    }
                }
                if (!string5.startsWith("New Lock Table Structure (at level -1)")) continue;
                string4 = "";
                while ((string4 = (String)arrayList2.get(i)) != null) {
                    string4 = string4.trim();
                    this.locksList.add(string4);
                    if (string4.startsWith("Total lock entries")) continue block1;
                    ++i;
                }
            }
            htProcessTable.put(string, this.processList);
            htSysTable.put(string, this.sysList);
            htResourceTable.put(string, this.resourceList);
            htLocksTable.put(string, this.locksList);
            this.sysList = new ArrayList();
            this.processList = new ArrayList();
            this.resourceList = new ArrayList();
            this.locksList = new ArrayList();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectValues() {
        boolean bl = true;
        String string = syncFlag;
        synchronized (string) {
            long l;
            long l2 = System.currentTimeMillis();
            Long l3 = null;
            try {
                l3 = (Long)htLastTime.get(this.targetHost);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l4 = 0L;
            if (l3 != null) {
                l4 = l3;
            }
            if ((double)(l = l2 - l4) >= 0.9 * (double)this.measurePeriod) {
                l4 = l2;
                htLastTime.put(this.targetHost, new Long(l4));
                bl = this.computeStats();
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        CacheStatsBase cacheStatsBase = new CacheStatsBase(stringArray);
        cacheStatsBase.computeStats();
    }
}

