/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;

public class CiscoMemoryTest
extends EgSnmpTest {
    private String memPoolNames = ".1.3.6.1.4.1.9.9.48.1.1.1.2";
    private String validMemPoolNames = ".1.3.6.1.4.1.9.9.48.1.1.1.4";
    private String memPoolUsed = ".1.3.6.1.4.1.9.9.48.1.1.1.5";
    private String memPoolFree = ".1.3.6.1.4.1.9.9.48.1.1.1.6";
    private int pctMemoryUsedIndex = 0;
    private int memUsedIndex = 1;
    private int memFreeIndex = 2;
    private double pctMemoryUsed = 0.0;
    private double memUsed = 0.0;
    private double memFree = 0.0;
    private int reDiscoveryCount = 12;
    private int reRun = 0;
    private Hashtable validMemoryPoolNames;
    private Hashtable memoryUsed;
    private Hashtable memoryFree;
    public static boolean ft = true;
    private static int numMeasures = 1;

    public CiscoMemoryTest(String[] stringArray) {
        super(stringArray);
        if (ft) {
            ft = false;
            EgThresholdInfo egThresholdInfo = new EgThresholdInfo("agent");
            String[] stringArray2 = egThresholdInfo.getMeasurementsForTest("CiscoMemoryTest");
            if (stringArray2 != null) {
                numMeasures = stringArray2.length;
            }
            egThresholdInfo = null;
        }
        this.numOutputFields = numMeasures;
    }

    public static void main(String[] stringArray) {
        CiscoMemoryTest ciscoMemoryTest = new CiscoMemoryTest(stringArray);
        ciscoMemoryTest.executeTest();
    }

    public boolean executeTest() {
        this.initTest();
        if (this.reRun == 0) {
            this.findValidMemoryPools();
        }
        if (this.validMemoryPoolNames == null || this.validMemoryPoolNames.size() == 0) {
            this.updateAllResultSets();
            this.reRun = 0;
            return true;
        }
        ++this.reRun;
        if (this.reRun >= this.reDiscoveryCount) {
            this.reRun = 0;
        }
        this.findMemoryUsed();
        this.findMemoryFree();
        String string = null;
        Enumeration enumeration = this.validMemoryPoolNames.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            string = (String)this.validMemoryPoolNames.get(k);
            if (!this.memoryUsed.containsKey(k) || !this.memoryFree.containsKey(k)) continue;
            double d = Double.parseDouble((String)this.memoryUsed.get(k));
            double d2 = Double.parseDouble((String)this.memoryFree.get(k));
            double d3 = d / 1048576.0;
            double d4 = d2 / 1048576.0;
            double d5 = d + d2 == 0.0 ? 0.0 : d * 100.0 / (d + d2);
            string = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string;
            this.addValueToResultSet(string, this.pctMemoryUsedIndex, d5);
            if (this.numOutputFields > 1) {
                this.addValueToResultSet(string, this.memUsedIndex, d3);
            }
            this.addValueToResultSet(string, this.memFreeIndex, d4);
        }
        this.memoryUsed = null;
        this.memoryFree = null;
        this.updateAllResultSets();
        return true;
    }

    public void findValidMemoryPools() {
        int n;
        this.validMemoryPoolNames = new Hashtable();
        if (this.runSnmpCmdForOid(this.memPoolNames)) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.validMemoryPoolNames.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            return;
        }
        if (this.runSnmpCmdForOid(this.validMemPoolNames)) {
            for (n = 0; n < this.lhs.length; ++n) {
                if (this.rhs[n].equals("1")) continue;
                this.validMemoryPoolNames.remove(this.lhs[n]);
            }
        }
    }

    public void findMemoryUsed() {
        this.memoryUsed = new Hashtable();
        if (this.runSnmpCmdForOid(this.memPoolUsed)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                this.memoryUsed.put(this.lhs[i], this.rhs[i]);
            }
        }
    }

    public void findMemoryFree() {
        this.memoryFree = new Hashtable();
        if (this.runSnmpCmdForOid(this.memPoolFree)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                this.memoryFree.put(this.lhs[i], this.rhs[i]);
            }
        }
    }
}

