/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CtxXmlAccessTest
extends GenericTest {
    private static int numMeasures = 5;
    private String user;
    private String pass;
    private String domain;
    private int timeout = 60000;
    private String data;
    private String header;
    private int port;
    private int contentLen = 0;
    private boolean isSsl = false;
    private boolean checkFName = false;
    private String xmlPort = null;
    private String dctype = "NT";
    private long cmdSleepTime = 1000L;
    private int noOfTries = 1;

    public static void main(String[] stringArray) {
        CtxXmlAccessTest ctxXmlAccessTest = new CtxXmlAccessTest(stringArray);
        ctxXmlAccessTest.executeTest();
    }

    public CtxXmlAccessTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        this.setMeasureCount(numMeasures);
        this.user = this.getValueForParam("user");
        this.pass = this.getValueForParam("password");
        this.domain = this.getValueForParam("domain");
        this.xmlPort = this.getValueForParam("xmlPort");
        String string3 = this.getValueForParam("ssl");
        if (string3 != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
            this.isSsl = true;
        }
        if (this.domain.equalsIgnoreCase("none")) {
            this.domain = "";
        }
        this.dctype = this.getValueForParam("domainType");
        if (this.dctype == null) {
            this.dctype = "NT";
        }
        if ((string2 = this.getValueForParam("timeout")) != null) {
            try {
                this.timeout = Integer.parseInt(string2) * 1000;
            }
            catch (Exception exception) {
                this.errorMsg = "CtxXmlAccessTest catch block for TimeOut " + exception.toString();
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
            }
        }
        this.port = 80;
        try {
            this.port = Integer.parseInt(this.portNo);
        }
        catch (Exception exception) {
            this.errorMsg = "CtxXmlAccessTest catch block for portNo" + exception.toString();
            this.logToErrorFile("ERROR", this.entity, this.errorMsg);
        }
        String string4 = "UTF-16";
        String string5 = "4.2";
        String string6 = this.getValueForParam("encoding_format");
        String string7 = this.getValueForParam("nfuse_protocol_version");
        if (string6 != null && string6.length() > 0) {
            string4 = string6.toUpperCase().trim();
        }
        if (string7 != null && string7.length() > 0) {
            string5 = string7.trim();
        }
        this.data = "<?xml version=\"1.0\" encoding=\"" + string4 + "\"?>\n" + "<!DOCTYPE NFuseProtocol SYSTEM \"NFuse.dtd\">\n" + "<NFuseProtocol version=\"" + string5 + "\">\n" + "<RequestAppData>\n" + "<Scope traverse=\"onelevel\"></Scope>\n" + "<DesiredDetails>default</DesiredDetails>\n" + "<ServerType>all</ServerType>\n" + "<ClientType>all</ClientType>\n" + "<Credentials>\n" + "<UserName>" + this.user + "</UserName>\n" + "<Password encoding= \"cleartext\">" + this.pass + "</Password>\n" + "<Domain type=\"" + this.dctype + "\">" + this.domain + "</Domain>\n" + "</Credentials>\n" + "</RequestAppData>\n" + "</NFuseProtocol>\n";
        this.contentLen = this.data.length();
        String string8 = this.getValueForParam("Sleep_time");
        if (!(string8 == null || string8.length() <= 0 || string8.equalsIgnoreCase("None") && string8.equalsIgnoreCase("Null"))) {
            string8 = string8.trim();
            try {
                this.cmdSleepTime = Long.parseLong(string8);
                this.cmdSleepTime *= 1000L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!((string = this.getValueForParam("No_of_tries")) == null || string.length() <= 0 || string.equalsIgnoreCase("None") && string.equalsIgnoreCase("Null"))) {
            string = string.trim();
            try {
                this.noOfTries = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = null;
        try {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = -5.0;
            double d5 = -5.0;
            for (int i = 0; i < this.noOfTries; ++i) {
                ArrayList arrayList2;
                if (i != 0) {
                    try {
                        Thread.sleep(this.cmdSleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((arrayList2 = this.computeMeasuresReal()) == null || arrayList2.size() <= 0) continue;
                ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
                if (arrayList3 != null && arrayList3.size() >= 5) {
                    d = (Double)arrayList3.get(0);
                    d2 = (Double)arrayList3.get(1);
                    d3 = (Double)arrayList3.get(2);
                    d4 = (Double)arrayList3.get(3);
                    d5 = (Double)arrayList3.get(4);
                    if (!(d > 0.0) || !(d2 > 0.0) || !(d3 > 0.0)) continue;
                    break;
                }
                this.errorMsg = "CtxXmlAccessTest retrying to collect metrics for " + this.reportingName + "[ " + i + " ] time";
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
            }
            d4 = d4 >= 0.0 ? d4 : -5.0;
            d5 = d5 >= 0.0 ? d5 : -5.0;
            d3 = d2 <= 0.0 ? -5.0 : d3;
            arrayList = new ArrayList();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            System.out.println("[CtxXmlAccessTest] Exception occured to get retried values : " + exception);
            arrayList = new ArrayList<Double>();
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            this.addNewMeasure(arrayList);
        }
    }

    public ArrayList computeMeasuresReal() {
        Object object;
        Object object2;
        URL uRL;
        ArrayList<Double> arrayList;
        String string;
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = -5.0;
        double d2 = -5.0;
        Object var9_7 = null;
        if (this.isSsl) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string = null;
                try {
                    arrayList = new MyX509TrustManager();
                    uRL = null;
                    object2 = new TrustManager[]{arrayList};
                    object = SSLContext.getInstance("SSL");
                    ((SSLContext)object).init((KeyManager[])uRL, (TrustManager[])object2, new SecureRandom());
                    SSLSocketFactory sSLSocketFactory2 = ((SSLContext)object).getSocketFactory();
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                    HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                }
                catch (Exception exception) {
                    this.errorMsg = "CtxXmlAccessTest inner catch block for parsing " + exception.toString();
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                this.errorMsg = "CtxXmlAccessTest outer catch block for parsing " + exception.toString();
                this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                exception.printStackTrace();
            }
        }
        double d3 = System.currentTimeMillis();
        try {
            string = "";
            arrayList = this.xmlPort;
            if (arrayList == null) {
                arrayList = this.port + "";
            }
            string = this.isSsl ? "https://" + this.targetHost + ":" + (String)((Object)arrayList) + "/scripts/wpnbr.dll" : "http://" + this.targetHost + ":" + (String)((Object)arrayList) + "/scripts/wpnbr.dll";
            uRL = new URL(string);
            object2 = (HttpURLConnection)uRL.openConnection();
            ((HttpURLConnection)object2).setRequestMethod("POST");
            HttpURLConnection.setFollowRedirects(false);
            ((URLConnection)object2).setDoOutput(true);
            ((URLConnection)object2).setDoInput(true);
            ((URLConnection)object2).setRequestProperty("Content-Type", "text/xml");
            ((URLConnection)object2).setRequestProperty("Content-Length", this.contentLen + "");
            object = new CtxXmlHelper((HttpURLConnection)object2, this.data);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            do {
                this.suspendForPeriod(l2);
                if (!((CtxXmlHelper)object).done) continue;
                if (!((CtxXmlHelper)object).status || ((CtxXmlHelper)object).output == null || ((CtxXmlHelper)object).output.size() == 0) {
                    ArrayList<Double> arrayList3 = new ArrayList<Double>();
                    arrayList3.add(new Double(n));
                    arrayList3.add(new Double(n3));
                    arrayList3.add(new Double(n2));
                    arrayList3.add(new Double(d));
                    arrayList3.add(new Double(d2));
                    arrayList2.add(arrayList3);
                    return arrayList2;
                }
                if (((CtxXmlHelper)object).connectTime > 0L) {
                    n = 100;
                    d = ((double)((CtxXmlHelper)object).connectTime - d3) / 1000.0;
                } else {
                    d = -5.0;
                }
                d2 = ((CtxXmlHelper)object).finishTime > 0L ? ((double)((CtxXmlHelper)object).finishTime - d3) / 1000.0 : -5.0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = true;
                boolean bl4 = false;
                boolean bl5 = true;
                if (((CtxXmlHelper)object).output != null) {
                    int n4 = ((CtxXmlHelper)object).output.size();
                    if (n4 > 1) {
                        for (int i = 0; i < n4; ++i) {
                            String string2 = (String)((CtxXmlHelper)object).output.get(i);
                            if ((string2 = string2.toLowerCase()).indexOf("</nfuseprotocol>") >= 0) {
                                bl = true;
                            } else {
                                if (string2.indexOf("<nfuseprotocol") >= 0) {
                                    bl2 = true;
                                } else if (string2.indexOf("<errorid>") >= 0) {
                                    bl3 = false;
                                    if (string2.indexOf("account-locked-out") >= 0) {
                                        bl5 = false;
                                    }
                                } else if (string2.indexOf("<fname>") >= 0) {
                                    bl4 = true;
                                    this.checkFName = true;
                                }
                                if (string2.indexOf("failed-credentials") < 0) continue;
                                bl5 = false;
                            }
                            break;
                        }
                    } else if (n4 == 1) {
                        String string3 = (String)((CtxXmlHelper)object).output.get(0);
                        if ((string3 = string3.toLowerCase()).indexOf("</nfuseprotocol>") >= 0) {
                            bl = true;
                        }
                        if (string3.indexOf("<nfuseprotocol") >= 0) {
                            bl2 = true;
                        }
                        if (string3.indexOf("<errorid>") >= 0) {
                            bl3 = false;
                            if (string3.indexOf("account-locked-out") >= 0) {
                                bl5 = false;
                            }
                        }
                        if (string3.indexOf("<fname>") >= 0) {
                            bl4 = true;
                            this.checkFName = true;
                        }
                        if (string3.indexOf("failed-credentials") >= 0) {
                            bl5 = false;
                        }
                    }
                }
                if (!this.checkFName && !bl4) {
                    bl4 = true;
                }
                if (bl5) {
                    n3 = 100;
                }
                n2 = !bl || !bl2 || !bl4 || !bl5 ? 0 : 100;
                ArrayList<Double> arrayList4 = new ArrayList<Double>();
                arrayList4.add(new Double(n));
                arrayList4.add(new Double(n3));
                arrayList4.add(new Double(n2));
                arrayList4.add(new Double(d));
                arrayList4.add(new Double(d2));
                arrayList2.add(arrayList4);
                return arrayList2;
            } while ((l = System.currentTimeMillis() - l3) < (long)this.timeout);
            ((Thread)object).interrupt();
            Thread.yield();
            try {
                if (((CtxXmlHelper)object).uc != null) {
                    ((CtxXmlHelper)object).uc.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = null;
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            arrayList5.add(new Double(n));
            arrayList5.add(new Double(n3));
            arrayList5.add(new Double(n2));
            arrayList5.add(new Double(d));
            arrayList5.add(new Double(d2));
            arrayList2.add(arrayList5);
            return arrayList2;
        }
        catch (Exception exception) {
            this.errorMsg = "CtxXmlAccessTest catch block for connection " + exception.toString();
            this.logToErrorFile("ERROR", this.entity, this.errorMsg);
            exception.printStackTrace();
            arrayList = new ArrayList<Double>();
            arrayList.add(new Double(n));
            arrayList.add(new Double(n3));
            arrayList.add(new Double(n2));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList2.add(arrayList);
            return arrayList2;
        }
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

