/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;

public class Db2DPFLocksTest
extends GenericTest {
    private static final int MEASURES_COUNT = 8;
    public String user;
    public String password;
    private String dbName;
    private HashMap lastValues;
    private ArrayList activeDatabases;
    private double Db2Version = 0.0;
    private boolean validCheckDone = false;
    String query = "";

    public Db2DPFLocksTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(8);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
        this.lastValues = new HashMap();
    }

    public void computeMeasures(Hashtable hashtable) {
        HashMap hashMap = this.getLockStats();
        if (debug) {
            System.out.println("[Db2DPFLocksTest]stats====>" + hashMap);
        }
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                if (debug) {
                    System.out.println("[Db2DPFLockTest]strDbName======>" + string);
                    System.out.println("[Db2DPFLockTest]activeDatabases======>" + this.activeDatabases);
                }
                if (this.activeDatabases.contains(string)) {
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                this.addNewMeasure(string, this.getNotAvailableMeasures());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getLockStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap hashMap = new HashMap();
        DB2JdbcHelper dB2JdbcHelper = null;
        String string = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = -5.0;
        double d11 = -5.0;
        double d12 = -5.0;
        double d13 = -5.0;
        double d14 = -5.0;
        double d15 = -5.0;
        double d16 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        if (!this.validCheckDone) {
            this.Db2Version = this.getVersion();
        }
        if (this.Db2Version >= 9.1 && this.Db2Version <= 9.4) {
            this.query = "SELECT DBPARTITIONNUM,SUBSTR(DB_NAME,1,10) as DB_NAME,LOCKS_HELD,LOCK_ESCALS,X_LOCK_ESCALS,LOCK_TIMEOUTS,LOCK_WAITS,LOCK_WAIT_TIME,LOCKS_WAITING,APPLS_CUR_CONS,DEADLOCKS FROM table(SNAP_GET_DB_V91(CAST (NULL AS VARCHAR(128)))) DB order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.5 && this.Db2Version <= 9.6) {
            this.query = "SELECT DBPARTITIONNUM,SUBSTR(DB_NAME,1,10) as DB_NAME,LOCKS_HELD,LOCK_ESCALS,X_LOCK_ESCALS,LOCK_TIMEOUTS,LOCK_WAITS,LOCK_WAIT_TIME,LOCKS_WAITING,APPLS_CUR_CONS,DEADLOCKS FROM table(SNAP_GET_DB_V95(CAST (NULL AS VARCHAR(128)))) DB order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.7 && this.Db2Version <= 9.9) {
            this.query = "SELECT DBPARTITIONNUM,SUBSTR(DB_NAME,1,10) as DB_NAME,LOCKS_HELD,LOCK_ESCALS,X_LOCK_ESCALS,LOCK_TIMEOUTS,LOCK_WAITS,LOCK_WAIT_TIME,LOCKS_WAITING,APPLS_CUR_CONS,DEADLOCKS FROM table(SNAP_GET_DB_V97(CAST (NULL AS VARCHAR(128)))) DB order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 10.0) {
            this.query = "SELECT DBPARTITIONNUM,SUBSTR(DB_NAME,1,10) as DB_NAME,LOCKS_HELD,LOCK_ESCALS,X_LOCK_ESCALS,LOCK_TIMEOUTS,LOCK_WAITS,LOCK_WAIT_TIME,LOCKS_WAITING,APPLS_CUR_CONS,DEADLOCKS FROM table(SNAP_GET_DB(CAST (NULL AS VARCHAR(128)))) DB order by DBPARTITIONNUM";
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.query);
            if (debug) {
                System.out.println("[Db2DPFLocksTest]query====>" + this.query);
            }
            this.activeDatabases = new ArrayList();
            while (resultSet.next()) {
                String string2 = resultSet.getString("DBPARTITIONNUM");
                String string3 = resultSet.getString("DB_NAME");
                string = string3 + "_" + string2;
                d = resultSet.getDouble("LOCKS_HELD");
                d2 = resultSet.getDouble("LOCK_ESCALS");
                d3 = resultSet.getDouble("X_LOCK_ESCALS");
                d4 = resultSet.getDouble("LOCK_TIMEOUTS");
                d5 = resultSet.getDouble("LOCK_WAITS");
                d6 = resultSet.getDouble("LOCK_WAIT_TIME");
                d7 = resultSet.getDouble("LOCKS_WAITING");
                d8 = resultSet.getDouble("APPLS_CUR_CONS");
                d9 = resultSet.getDouble("DEADLOCKS");
                if (debug) {
                    System.out.println("[Db2DPFLocksTest]curr LOCK_ESCALS=====>" + d2 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]curr X_LOCK_ESCALS======>" + d3 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]curr LOCK_TIMEOUTS===>" + d4 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]curr LOCK_WAITS=====>" + d5 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]curr LOCK_WAIT_TIME====>" + d6 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]curr DEADLOCKS=====>" + d9 + "  info====>" + string);
                }
                this.activeDatabases.add(string);
                ArrayList<Double> arrayList = (ArrayList<Double>)this.lastValues.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Double>(6);
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d9));
                } else {
                    double d17 = (Double)arrayList.get(0);
                    double d18 = (Double)arrayList.get(1);
                    double d19 = (Double)arrayList.get(2);
                    double d20 = (Double)arrayList.get(3);
                    double d21 = (Double)arrayList.get(4);
                    double d22 = (Double)arrayList.get(5);
                    if (this.timeSinceLastTest > 0.0) {
                        d13 = (d5 - d20) / this.timeSinceLastTest;
                    }
                    d16 = d9 - d22;
                    d11 = d3 - d18;
                    d12 = d4 - d19;
                    d10 = d2 - d17;
                    double d23 = d6 - d21;
                    double d24 = d5 - d20;
                    d14 = d23 > 0.0 ? d24 / d23 : 0.0;
                    d15 = d8 > 0.0 ? d7 * 100.0 / d8 : 0.0;
                    if (debug) {
                        System.out.println("[Db2DPFLocksTest]prev LOCK_ESCALS=====>" + d17 + "  info====>" + string);
                        System.out.println("[Db2DPFLocksTest]prev X_LOCK_ESCALS====>" + d18 + "  info====>" + string);
                        System.out.println("[Db2DPFLocksTest]prev LOCK_TIMEOUTS===>" + d19 + "  info====>" + string);
                        System.out.println("[Db2DPFLocksTest]prev LOCK_WAITS====>" + d20 + "  info====>" + string);
                        System.out.println("[Db2DPFLocksTest]prev LOCK_WAIT_TIME====>" + d21 + "  info====>" + string);
                        System.out.println("[Db2DPFLocksTest]prev DEADLOCKS=====>" + d22 + "  info====>" + string);
                    }
                    arrayList.set(0, new Double(d2));
                    arrayList.set(1, new Double(d3));
                    arrayList.set(2, new Double(d4));
                    arrayList.set(3, new Double(d5));
                    arrayList.set(4, new Double(d6));
                    arrayList.set(5, new Double(d9));
                }
                if (debug) {
                    System.out.println("[Db2DPFLocksTest]DeadLocks=====>" + d16 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Exclusive_lock_escalations=====>" + d11 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Locks_held===>" + d + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Lock_timeouts====>" + d12 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Lock_escalations====>" + d10 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Pct_appl_in_lock_wait=====>" + d15 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Lock_waits=====>" + d13 + "  info====>" + string);
                    System.out.println("[Db2DPFLocksTest]Avg_lock_wait_time=====>" + d14 + "  info====>" + string);
                }
                this.lastValues.put(string, arrayList);
                ArrayList<Double> arrayList2 = new ArrayList<Double>(8);
                arrayList2.add(new Double(d16 < 0.0 ? -5.0 : d16));
                arrayList2.add(new Double(d11 < 0.0 ? -5.0 : d11));
                arrayList2.add(new Double(d < 0.0 ? -5.0 : d));
                arrayList2.add(new Double(d12 < 0.0 ? -5.0 : d12));
                arrayList2.add(new Double(d10 < 0.0 ? -5.0 : d10));
                arrayList2.add(new Double(d15));
                arrayList2.add(new Double(d13 < 0.0 ? -5.0 : d13));
                arrayList2.add(new Double(d14 < 0.0 ? -5.0 : d14));
                hashMap.put(string, arrayList2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashMap;
    }

    private ArrayList getNotAvailableMeasures() {
        if (debug) {
            System.out.println("[Db2DPFLockTest]getNotAvailableMeasures........");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(8);
        for (int i = 0; i < 8; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getVersion() {
        DB2JdbcHelper dB2JdbcHelper;
        double d;
        String string;
        String string2;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block11: {
            connection = null;
            statement = null;
            resultSet = null;
            string2 = "";
            string = "";
            d = 9.1;
            dB2JdbcHelper = null;
            String string3 = "SELECT service_level FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO";
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
            if (debug) {
                System.out.println("[DB2ActivityTest] querystring Version=====>" + string2);
            }
            if (string2 != null && string2.trim().length() != 0) break block11;
            this.logToErrorFile("DB22ActivityTest:", "Query  select @@version returning null ", "");
            this.validCheckDone = true;
            double d2 = d;
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            return d2;
        }
        try {
            this.validCheckDone = true;
            string2 = string2.toUpperCase().trim();
            String string4 = "";
            String string5 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            if (n > 2) {
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                if (string4.indexOf("DB2 V") > -1) {
                    string4 = string4.substring(string4.indexOf("DB2 V") + 5);
                }
                if ((string = string4 + "." + string5) != null && string.length() > 0) {
                    d = Double.parseDouble(string);
                }
            } else {
                this.logToErrorFile("DB22ActivityTest:", "Version of Db2 is ", string2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                System.out.println("Exception occured in Db2DBFActivityTest " + exception);
                double d3 = d;
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                return d3;
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return d;
    }
}

