/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Db2DPFTransTest
extends GenericTest {
    private static final int MEASURES_COUNT = 3;
    private String user;
    private String password;
    private String dbName;
    private Hashtable lastValues;
    private ArrayList activeDatabases;
    private double Db2Version = 0.0;
    private boolean validCheckDone = false;
    String query = "";

    public Db2DPFTransTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(3);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
        this.lastValues = new Hashtable();
    }

    public static void main(String[] stringArray) {
        Db2DPFTransTest db2DPFTransTest = new Db2DPFTransTest(stringArray);
        db2DPFTransTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getTransactionStats();
        if (debug) {
            System.out.println("[Db2DPFTransTest]measureDt======>" + hashtable2);
        }
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (debug) {
                System.out.println("[Db2DPFTransTest]strDbName======>" + string);
                System.out.println("[Db2DPFTransTest]activeDatabases======>" + this.activeDatabases);
            }
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTransactionStats() {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        DB2JdbcHelper dB2JdbcHelper = null;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        if (!this.validCheckDone) {
            this.Db2Version = this.getVersion();
        }
        if (this.Db2Version >= 9.1 && this.Db2Version <= 9.4) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME, COMMIT_SQL_STMTS,INT_COMMITS,ROLLBACK_SQL_STMTS,INT_ROLLBACKS,INT_DEADLOCK_ROLLBACKS FROM TABLE(SNAP_GET_DB_V91(CAST (NULL AS VARCHAR(128)))) AS T order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.5 && this.Db2Version <= 9.6) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME, COMMIT_SQL_STMTS,INT_COMMITS,ROLLBACK_SQL_STMTS,INT_ROLLBACKS,INT_DEADLOCK_ROLLBACKS FROM TABLE(SNAP_GET_DB_V95(CAST (NULL AS VARCHAR(128)))) AS T order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.7) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME, COMMIT_SQL_STMTS,INT_COMMITS,ROLLBACK_SQL_STMTS,INT_ROLLBACKS,INT_DEADLOCK_ROLLBACKS FROM TABLE(SNAP_GET_DB_V97(CAST (NULL AS VARCHAR(128)))) AS T order by DBPARTITIONNUM";
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.query);
            if (debug) {
                System.out.println("[Db2DPFTransTest]query========>" + this.query);
            }
            this.activeDatabases = new ArrayList();
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string = resultSet.getString("DBPARTITIONNUM");
                String string2 = resultSet.getString("DB_NAME");
                String string3 = string2 + "_" + string;
                double d4 = resultSet.getDouble("COMMIT_SQL_STMTS");
                double d5 = resultSet.getDouble("INT_COMMITS");
                double d6 = resultSet.getDouble("ROLLBACK_SQL_STMTS");
                double d7 = resultSet.getDouble("INT_ROLLBACKS");
                double d8 = resultSet.getDouble("INT_DEADLOCK_ROLLBACKS");
                if (debug) {
                    System.out.println("[Db2DPFTransTest]curr COMMIT_SQL_STMTS===>" + d4 + "  info====>" + string3);
                    System.out.println("[Db2DPFTransTest]curr INT_COMMITS===>" + d5 + "  info====>" + string3);
                    System.out.println("[Db2DPFTransTest]curr ROLLBACK_SQL_STMTS===>" + d6 + "  info====>" + string3);
                    System.out.println("[Db2DPFTransTest]curr INT_ROLLBACKS===>" + d7 + "  info====>" + string3);
                    System.out.println("[Db2DPFTransTest]curr INT_DEADLOCK_ROLLBACKS===>" + d8 + "  info====>" + string3);
                }
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.lastValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(5);
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d8));
                } else {
                    double d9 = (Double)arrayList2.get(0);
                    double d10 = (Double)arrayList2.get(1);
                    double d11 = (Double)arrayList2.get(2);
                    double d12 = (Double)arrayList2.get(3);
                    double d13 = (Double)arrayList2.get(4);
                    d = this.timeSinceLastTest > 0.0 ? (d4 - d9 + (d5 - d10)) / this.timeSinceLastTest : -5.0;
                    d = d < 0.0 ? -5.0 : d;
                    d2 = this.timeSinceLastTest > 0.0 ? (d6 - d11 + (d7 - d12) + (d8 - d13)) / this.timeSinceLastTest : -5.0;
                    d2 = d2 < 0.0 ? -5.0 : d2;
                    d3 = this.timeSinceLastTest > 0.0 ? (d4 - d9 + (d6 - d11)) / this.timeSinceLastTest : -5.0;
                    double d14 = d3 = d3 < 0.0 ? -5.0 : d3;
                    if (debug) {
                        System.out.println("[Db2DPFTransTest]prev COMMIT_SQL_STMTS===>" + d9 + "  info====>" + string3);
                        System.out.println("[Db2DPFTransTest]prev INT_COMMITS===>" + d10 + "  info====>" + string3);
                        System.out.println("[Db2DPFTransTest]prev ROLLBACK_SQL_STMTS===>" + d11 + "  info====>" + string3);
                        System.out.println("[Db2DPFTransTest]prev INT_ROLLBACKS===>" + d12 + "  info====>" + string3);
                        System.out.println("[Db2DPFTransTest]prev INT_DEADLOCK_ROLLBACKS===>" + d13 + "  info====>" + string3);
                    }
                    arrayList2.set(0, new Double(d4));
                    arrayList2.set(1, new Double(d5));
                    arrayList2.set(2, new Double(d6));
                    arrayList2.set(3, new Double(d7));
                    arrayList2.set(4, new Double(d8));
                }
                if (debug) {
                    System.out.println("[Db2DPFTransTest]Commit_rate======>" + d + "  info===>" + string3);
                    System.out.println("[Db2DPFTransTest]Rollback_rate======>" + d2 + "  info====>" + string3);
                    System.out.println("[Db2DPFTransTest]Transaction_rate======>" + d3 + "  info=====>" + string3);
                }
                this.lastValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(3);
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                hashtable.put(string3, arrayList);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                System.out.println("Exception occured in Db2DPFTransTest " + exception);
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        if (debug) {
            System.out.println("[Db2DPFTransTest]getNotAvailableMeasures........");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(3);
        for (int i = 0; i < 3; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getVersion() {
        DB2JdbcHelper dB2JdbcHelper;
        double d;
        String string;
        String string2;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block11: {
            connection = null;
            statement = null;
            resultSet = null;
            string2 = "";
            string = "";
            d = 9.1;
            dB2JdbcHelper = null;
            String string3 = "SELECT service_level FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO";
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
            if (debug) {
                System.out.println("[DB2ActivityTest] querystring Version=====>" + string2);
            }
            if (string2 != null && string2.trim().length() != 0) break block11;
            this.logToErrorFile("DB22ActivityTest:", "Query  select @@version returning null ", "");
            this.validCheckDone = true;
            double d2 = d;
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            return d2;
        }
        try {
            this.validCheckDone = true;
            string2 = string2.toUpperCase().trim();
            String string4 = "";
            String string5 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            if (n > 2) {
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                if (string4.indexOf("DB2 V") > -1) {
                    string4 = string4.substring(string4.indexOf("DB2 V") + 5);
                }
                if ((string = string4 + "." + string5) != null && string.length() > 0) {
                    d = Double.parseDouble(string);
                }
            } else {
                this.logToErrorFile("DB22ActivityTest:", "Version of Db2 is ", string2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                System.out.println("Exception occured in Db2DBFActivityTest " + exception);
                double d3 = d;
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                return d3;
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return d;
    }
}

