/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DbLocksTest
extends DbBaseTest {
    String description = "DESCRIPTION";
    String descValue = "VALUE";
    String collisions = "collisions";
    String escalations = "escalations";
    String insRows = "inserted row";
    String insTables = "inserted table";
    String deadlocks = "deadlocks";
    String timeouts = "timeouts";
    String transHoldLocks = "TRANSACTIONS HOLDING     LOCKS";
    String transReqLocks = "TRANSACTIONS REQUESTING";
    String lockUser = "USERNAME";
    String lockDate = "LOCKDATE";
    String lockTime = "LOCKTIME";
    String lockMode = "LOCKMODE";
    String lockState = "LOCKSTATE";
    String tableName = "TABLENAME";
    String applProcId = "APPLPROCESS";
    String processId = "PROCESS";
    String applNode = "APPLNODE";
    String lockId = "LOCK_HANDLE";
    String omsLockMode = "LOCK_MODE";
    String reqTimeout = "REQ_TIMEOUT";
    String session = "SESSION";
    String omsLockUser = "USERNAME";
    String applNodeId = "APPLNODEID";
    String reqMode = "REQ_MODE";
    String termId = "TERMID";
    ArrayList ddLockResults = null;
    ArrayList ddOmsLockResults = null;
    double prevCollisions = -5.0;
    double prevEscalations = -5.0;
    double prevInsRows = -5.0;
    double prevInsTables = -5.0;
    double prevDeadlocks = -5.0;
    double prevReqTimeouts = -5.0;
    double prevReqLocks = -5.0;

    public DbLocksTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(10);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList;
        ArrayList arrayList2;
        int n;
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList arrayList4 = this.getOutput("select session, username, date as lockdate, time as locktime, lockmode, lockstate, termid, applnode, tablename, process, applprocess from locks");
        ArrayList arrayList5 = this.parseLockOutput(arrayList4);
        if (arrayList5 == null || arrayList5.size() == 0) {
            arrayList3.add(new Double(0.0));
        } else {
            arrayList3.add((Double)arrayList5.get(0));
        }
        ArrayList arrayList6 = this.getOutput("select description, value from lockliststatistics");
        ArrayList arrayList7 = this.parseOutput(arrayList6);
        if (arrayList7 == null || arrayList7.size() == 0) {
            for (n = 0; n < 2; ++n) {
                arrayList3.add(new Double(-5.0));
            }
        } else {
            for (n = 0; n < 2; ++n) {
                arrayList3.add((Double)arrayList7.get(n));
            }
        }
        if ((arrayList2 = this.parseOmsLockOutput(arrayList = this.getOutput("select process, session, username, termid, applprocess, applnodeid, lock_handle, lock_mode, req_mode, req_timeout from oms_lockobj_info"))) == null || arrayList2.size() == 0) {
            arrayList3.add(new Double(0.0));
        } else {
            arrayList3.add((Double)arrayList2.get(0));
        }
        ArrayList arrayList8 = this.getOutput("select description, value from monitor_lock");
        ArrayList arrayList9 = this.parseOutput(arrayList8);
        if (arrayList9 == null) {
            for (int i = 0; i < 6; ++i) {
                arrayList3.add(new Double(-5.0));
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                arrayList3.add((Double)arrayList9.get(i));
            }
        }
        System.out.println("al:" + arrayList3);
        this.addNewMeasure(arrayList3);
    }

    public static void main(String[] stringArray) {
        DbLocksTest dbLocksTest = new DbLocksTest(stringArray);
        dbLocksTest.computeMeasures(new Hashtable());
    }

    private ArrayList parseOutput(ArrayList arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            hashtable = (Hashtable)arrayList.get(i);
            if (hashtable == null || hashtable.size() <= 0) {
                return null;
            }
            double d = -5.0;
            Enumeration enumeration = hashtable.keys();
            if (enumeration.hasMoreElements() && (string3 = (String)enumeration.nextElement()) == null || (string = (String)hashtable.get(string3)) == null || string.length() <= 0 || enumeration.hasMoreElements() && (string3 = (String)enumeration.nextElement()) == null || (string2 = (String)hashtable.get(string3)) == null || string2.length() <= 0) continue;
            if (string.indexOf(this.deadlocks) >= 0) {
                d = this.getMeasurePrevValue(string2, this.deadlocks);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.collisions) >= 0) {
                d = this.getMeasurePrevValue(string2, this.collisions);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.escalations) >= 0) {
                d = this.getMeasurePrevValue(string2, this.escalations);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.insRows) >= 0) {
                d = this.getMeasurePrevValue(string2, this.insRows);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.insTables) >= 0) {
                d = this.getMeasurePrevValue(string2, this.insTables);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.timeouts) >= 0) {
                d = this.getMeasurePrevValue(string2, this.timeouts);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.transHoldLocks) >= 0) {
                d = this.getValue(string2);
                arrayList2.add(new Double(d));
                continue;
            }
            if (string.indexOf(this.transReqLocks) < 0) continue;
            d = this.getMeasurePrevValue(string2, this.transReqLocks);
            arrayList2.add(new Double(d));
        }
        return arrayList2;
    }

    private ArrayList parseLockOutput(ArrayList arrayList) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = "-";
        this.ddLockResults = new ArrayList();
        ArrayList<Double> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        int n = arrayList.size();
        arrayList2.add(new Double(n));
        for (int i = 0; i < n; ++i) {
            hashtable = (Hashtable)arrayList.get(i);
            if (hashtable == null || hashtable.size() <= 0) {
                return null;
            }
            arrayList3 = new ArrayList<String>();
            string = this.getMeasureValue(hashtable, this.session);
            string2 = this.getMeasureValue(hashtable, this.lockUser);
            string3 = this.getMeasureValue(hashtable, this.lockDate);
            string4 = this.getMeasureValue(hashtable, this.lockTime);
            string5 = this.getMeasureValue(hashtable, this.lockMode);
            string6 = this.getMeasureValue(hashtable, this.lockState);
            string7 = this.getMeasureValue(hashtable, this.tableName);
            string10 = this.getMeasureValue(hashtable, this.termId);
            string11 = this.getMeasureValue(hashtable, this.applNode);
            string9 = this.getMeasureValue(hashtable, this.processId);
            string8 = this.getMeasureValue(hashtable, this.applProcId);
            arrayList3.add(string);
            arrayList3.add(string2);
            arrayList3.add(string3 + string12 + string4);
            arrayList3.add(string5);
            arrayList3.add(string6);
            arrayList3.add(string7);
            arrayList3.add(string10);
            arrayList3.add(string9);
            arrayList3.add(string11);
            arrayList3.add(string8);
            this.ddLockResults.add(arrayList3);
        }
        System.out.println("ddLockresults:" + this.ddLockResults);
        return arrayList2;
    }

    private ArrayList parseOmsLockOutput(ArrayList arrayList) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        this.ddOmsLockResults = new ArrayList();
        ArrayList<Double> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        int n = arrayList.size();
        arrayList2.add(new Double(n));
        for (int i = 0; i < n; ++i) {
            hashtable = (Hashtable)arrayList.get(i);
            if (hashtable == null || hashtable.size() <= 0) {
                return null;
            }
            arrayList3 = new ArrayList<String>();
            string8 = this.getMeasureValue(hashtable, this.lockId);
            string4 = this.getMeasureValue(hashtable, this.omsLockMode);
            string3 = this.getMeasureValue(hashtable, this.reqTimeout);
            string = this.getMeasureValue(hashtable, this.session);
            string7 = this.getMeasureValue(hashtable, this.processId);
            string2 = this.getMeasureValue(hashtable, this.omsLockUser);
            string6 = this.getMeasureValue(hashtable, this.applNodeId);
            string5 = this.getMeasureValue(hashtable, this.termId);
            string9 = this.getMeasureValue(hashtable, this.applProcId);
            string10 = this.getMeasureValue(hashtable, this.reqMode);
            arrayList3.add(string);
            arrayList3.add(string7);
            arrayList3.add(string2);
            arrayList3.add(string8);
            arrayList3.add(string4);
            arrayList3.add(string10);
            arrayList3.add(string3);
            arrayList3.add(string5);
            arrayList3.add(string9);
            arrayList3.add(string6);
            this.ddOmsLockResults.add(arrayList3);
        }
        System.out.println("ddOmsLockresults:" + this.ddOmsLockResults);
        return arrayList2;
    }

    private double getMeasurePrevValue(String string, String string2) {
        double d = -5.0;
        double d2 = this.getValue(string);
        if (d2 >= 0.0) {
            double d3 = -5.0;
            if (string2.indexOf(this.collisions) >= 0) {
                d3 = this.prevCollisions;
            } else if (string2.indexOf(this.escalations) >= 0) {
                d3 = this.prevEscalations;
            } else if (string2.indexOf(this.insRows) >= 0) {
                d3 = this.prevInsRows;
            } else if (string2.indexOf(this.insTables) >= 0) {
                d3 = this.prevInsTables;
            } else if (string2.indexOf(this.deadlocks) >= 0) {
                d3 = this.prevDeadlocks;
            } else if (string2.indexOf(this.timeouts) >= 0) {
                d3 = this.prevReqTimeouts;
            } else if (string2.indexOf(this.transReqLocks) >= 0) {
                d3 = this.prevReqLocks;
            }
            d = d3 >= 0.0 ? d2 - d3 : -5.0;
            double d4 = d = d >= 0.0 ? d : -5.0;
            double d5 = d3 < 0.0 ? d2 : (d3 = d >= 0.0 ? d2 : -5.0);
            if (string2.indexOf(this.collisions) >= 0) {
                this.prevCollisions = d3;
            } else if (string2.indexOf(this.escalations) >= 0) {
                this.prevEscalations = d3;
            } else if (string2.indexOf(this.insRows) >= 0) {
                this.prevInsRows = d3;
            } else if (string2.indexOf(this.insTables) >= 0) {
                this.prevInsTables = d3;
            } else if (string2.indexOf(this.deadlocks) >= 0) {
                this.prevDeadlocks = d3;
            } else if (string2.indexOf(this.timeouts) >= 0) {
                this.prevReqTimeouts = d3;
            } else if (string2.indexOf(this.transReqLocks) >= 0) {
                this.prevReqLocks = d3;
            }
        }
        return d;
    }

    private String getMeasureValue(Hashtable hashtable, String string) {
        String string2 = null;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
        }
        return string2;
    }

    private double getValue(String string) {
        double d;
        if (string == null) {
            return -5.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }
}

