/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class DbSessCacheTest
extends DbBaseTest {
    private static String sessionId = "SESSIONID";
    private static String cacheAccess = "ACCESSCOUNT";
    private static String successAccess = "SUCCESSFULACCESSCOUNT";
    double prevAccess = -5.0;
    double prevSuccessAccess = -5.0;
    ArrayList ddCacheResults = null;

    public DbSessCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
    }

    public void freeTest() {
        this.ddCacheResults = new ArrayList();
    }

    public static void main(String[] stringArray) {
        DbSessCacheTest dbSessCacheTest = new DbSessCacheTest(stringArray);
        dbSessCacheTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getOutput("select sessionid, accesscount, successfulaccesscount from cachestatistics where SESSIONID is not null");
        ArrayList arrayList2 = this.parseHitOutput(arrayList);
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        if (arrayList2 == null || arrayList2.size() == 0) {
            arrayList3.add(new Double(-5.0));
        } else {
            arrayList3.add((Double)arrayList2.get(0));
        }
        System.out.println("alhit:" + arrayList2);
        this.addNewMeasure(arrayList3);
    }

    private ArrayList parseHitOutput(ArrayList arrayList) {
        double d = -5.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string = null;
        ArrayList<Double> arrayList2 = null;
        ArrayList<Object> arrayList3 = null;
        this.ddCacheResults = new ArrayList();
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        for (int i = 0; i < arrayList.size(); ++i) {
            hashtable = (Hashtable)arrayList.get(i);
            if (hashtable == null || hashtable.size() <= 0) {
                return null;
            }
            arrayList3 = new ArrayList<Object>();
            string = (String)hashtable.get(sessionId);
            if (string == null) continue;
            arrayList3.add(string);
            d2 = this.getMeasurePrevValue(hashtable, cacheAccess);
            if (d2 > 0.0) {
                d3 += d2;
            }
            arrayList3.add(new Double(d2));
            d4 = this.getMeasurePrevValue(hashtable, successAccess);
            if (d4 > 0.0) {
                d5 += d4;
            }
            arrayList3.add(new Double(d4));
            if (d2 > 0.0) {
                arrayList3.add(new Double(d4 / d2 * 100.0));
            } else {
                arrayList3.add(new Double(0.0));
            }
            this.ddCacheResults.add(arrayList3);
        }
        d = d5 / d3 * 100.0;
        arrayList2.add(new Double(d));
        System.out.println("cacheresults:" + this.ddCacheResults);
        return arrayList2;
    }

    private double getMeasurePrevValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        double d2 = -5.0;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
            double d3 = -5.0;
            if (d >= 0.0) {
                if (string.equalsIgnoreCase(cacheAccess)) {
                    d3 = this.prevAccess;
                } else if (string.equalsIgnoreCase(successAccess)) {
                    d3 = this.prevSuccessAccess;
                }
                d2 = d3 >= 0.0 ? d - d3 : d;
                double d4 = d2 = d2 >= 0.0 ? d2 : -5.0;
                double d5 = d3 < 0.0 ? d : (d3 = d2 >= 0.0 ? d : -5.0);
            }
            if (string.equalsIgnoreCase(cacheAccess)) {
                this.prevAccess = d3;
            } else if (string.equalsIgnoreCase(successAccess)) {
                this.prevSuccessAccess = d3;
            }
        }
        return d2;
    }

    private double getValue(String string) {
        double d;
        if (string == null) {
            return -5.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }
}

