/*
 * Decompiled with CFR 0.152.
 */
public class DominoMemTest
extends EgSnmpTest {
    public static final boolean verbose = false;
    private int totalMemAllocatedIndex = 0;
    private int memAllocProcessIndex = 1;
    private int memAllocSharedIndex = 2;
    private double totalMemAllocated = -1.0;
    private double memAllocProcess = -1.0;
    private double memAllocShared = -1.0;
    private String totalMemAllocatedOid = ".1.3.6.1.4.1.334.72.1.1.9.1";
    private String memAllocProcessOid = ".1.3.6.1.4.1.334.72.1.1.9.2";
    private String memAllocSharedOid = ".1.3.6.1.4.1.334.72.1.1.9.3";

    public DominoMemTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 3;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: DominoMemTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (++i < stringArray.length) {
                        this.portNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoMemTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-snmpPort")) {
                    if (++i < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoMemTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-snmpCommunity")) continue;
                if (++i < stringArray.length) {
                    this.community = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: DominoMemTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.40", "-port", "25", "-snmpPort", "161", "-snmpCommunity", "public"};
        DominoMemTest dominoMemTest = new DominoMemTest(stringArray2);
        try {
            for (int i = 0; i < 5; ++i) {
                dominoMemTest.executeTest();
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean executeTest() {
        this.initTest();
        String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        this.totalMemAllocated = this.getMeasure(this.totalMemAllocatedOid) / 1048576.0;
        this.memAllocProcess = this.getMeasure(this.memAllocProcessOid) / 1048576.0;
        this.memAllocShared = this.getMeasure(this.memAllocSharedOid) / 1048576.0;
        if (this.timeSinceLastTest < 0.0) {
            this.addValueToResultSet(string, this.memAllocProcessIndex, -1.0);
            this.addValueToResultSet(string, this.memAllocSharedIndex, -1.0);
            this.addValueToResultSet(string, this.totalMemAllocatedIndex, -1.0);
            this.updateAllResultSets();
        } else {
            this.addValueToResultSet(string, this.memAllocProcessIndex, this.memAllocProcess);
            this.addValueToResultSet(string, this.memAllocSharedIndex, this.memAllocShared);
            this.addValueToResultSet(string, this.totalMemAllocatedIndex, this.totalMemAllocated);
            this.updateAllResultSets();
        }
        return true;
    }

    private double getMeasure(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            return Double.parseDouble(string2);
        }
        return -1.0;
    }
}

