/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.MimeBase64Encoder;

public class EgLdap {
    private static boolean attr = false;
    private static int ref = 0;
    private static int scope = 2;
    private static int size = 0;
    private static int time = 0;
    private static int verbose = 0;
    private static Vector Sort = new Vector();
    private static boolean sortOnServer = false;
    protected static int port = 389;
    protected static String bind = null;
    protected static String host = "localhost";
    protected static int debugLevel = 0;
    protected static int hopLimit = 10;
    protected static boolean referrals = true;
    protected static LDAPConnection client = null;
    protected static boolean mjs = false;
    protected static boolean mverb = false;
    protected static boolean ordinary = false;
    protected static LDAPControl pControl = null;
    protected static String passwd = null;
    protected static int version = 3;
    private static boolean tempFile = false;
    private static int befCount = 0;
    private static String[] m_attrs = null;
    private static String base = "o=ace industry,c=us";
    private static String filter = null;
    private static String sep = ":";
    private static int Tokens = 0;
    private static String Search = null;
    private static boolean fold = true;
    private static final int MAX_LINE = 77;
    private static PrintWriter mpw = new PrintWriter(System.out);
    private static int aftCount = 0;
    private static int ind = 0;
    private static int count = 0;

    public static void main(String[] stringArray) {
        EgLdap.getParameters(stringArray);
        if (!mjs) {
            try {
                client = new LDAPConnection();
                client.connect(host, port);
            }
            catch (Exception exception) {
                System.err.println("Error: client connection failed!");
                System.exit(0);
            }
            if (bind != null && passwd != null) {
                try {
                    client.authenticate(version, bind, passwd);
                }
                catch (Exception exception) {
                    System.err.println(exception.toString());
                    System.exit(0);
                }
            }
            EgLdap.search();
            mpw.flush();
            mpw.close();
            try {
                client.disconnect();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("usage: EgLdapTest -b basedn [options] filter [attributes...]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -t            write values to files");
        System.err.println("  -A            retrieve attribute names only");
        System.err.println("  -F sep        print 'sep' instead of '=' between attribute names and values");
        System.err.println("  -S attr       sort the results by attribute 'attr'");
        System.err.println("  -s scope      one of base, one, or sub (search scope)");
        System.err.println("  -a deref      one of never, always, search, or find (alias dereferencing)");
        System.err.println("  -l timelimit  time limit (in seconds) for search");
        System.err.println("  -T            do not fold (wrap) long lines (default is to fold)");
        System.err.println("  -x            perform sorting on server");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -z sizelimit  size limit (in entries) for search");
        System.err.println("  -G before:after:index:count | before:after:value where 'before' and 'after' are the number of entries surrounding 'index'. 'count' is the content count, 'value' is the search value.");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    protected static void getParameters(String[] stringArray) {
        Object object;
        String string = "HATtxvna:b:F:l:s:S:z:G:";
        GetOpt getOpt = EgLdap.getParameters(string, stringArray);
        if (getOpt.hasOption('H')) {
            EgLdap.usage();
            System.exit(0);
        }
        if (getOpt.hasOption('A')) {
            attr = true;
        }
        if (getOpt.hasOption('x')) {
            sortOnServer = true;
        }
        if (getOpt.hasOption('t')) {
            tempFile = true;
        }
        if (getOpt.hasOption('F')) {
            sep = getOpt.getOptionParam('F');
        }
        if (getOpt.hasOption('a')) {
            object = getOpt.getOptionParam('a');
            if (((String)object).equalsIgnoreCase("never")) {
                ref = 0;
            } else if (((String)object).equalsIgnoreCase("search")) {
                ref = 1;
            } else if (((String)object).equalsIgnoreCase("find")) {
                ref = 2;
            } else if (((String)object).equalsIgnoreCase("always")) {
                ref = 3;
            } else {
                System.err.println("Error: alias deref option should be never, search, find, or always.");
            }
        }
        if (getOpt.hasOption('b')) {
            base = getOpt.getOptionParam('b');
        }
        if (getOpt.hasOption('S')) {
            Sort.addElement(getOpt.getOptionParam('S'));
        }
        if (getOpt.hasOption('l')) {
            try {
                time = Integer.parseInt(getOpt.getOptionParam('l'));
            }
            catch (NumberFormatException numberFormatException) {
                time = 0;
            }
        }
        if (getOpt.hasOption('s')) {
            object = getOpt.getOptionParam('s');
            if (((String)object).equalsIgnoreCase("base")) {
                scope = 0;
            } else if (((String)object).equalsIgnoreCase("one")) {
                scope = 1;
            } else if (((String)object).equalsIgnoreCase("sub")) {
                scope = 2;
            } else {
                System.err.println("Error: scope should be base, one or sub.");
            }
        }
        if (getOpt.hasOption('z')) {
            try {
                size = Integer.parseInt(getOpt.getOptionParam('z'));
            }
            catch (NumberFormatException numberFormatException) {
                size = 0;
            }
        }
        if (getOpt.hasOption('T')) {
            fold = false;
        }
        EgLdap.parselv(getOpt);
        object = getOpt.getParameters().elements();
        Vector vector = new Vector();
        while (object.hasMoreElements()) {
            vector.addElement(object.nextElement());
        }
        int n = vector.size();
        if (n <= 0) {
            System.err.println("Error: must supply filter string!");
            EgLdap.usage();
            System.exit(0);
        }
        if (n == 1) {
            filter = (String)vector.elementAt(0);
            if (mverb) {
                System.err.println("filter pattern: " + filter);
            }
            m_attrs = null;
            if (mverb) {
                System.err.println("returning: ALL");
                System.err.println("filter is: (" + filter + ")");
            }
        }
        if (n > 1) {
            filter = (String)vector.elementAt(0);
            if (mverb) {
                System.err.println("filter pattern: " + filter);
                System.err.print("returning:");
            }
            m_attrs = new String[n];
            for (int i = 1; i < n; ++i) {
                EgLdap.m_attrs[i - 1] = (String)vector.elementAt(i);
                if (!mverb) continue;
                System.err.print(" " + m_attrs[i - 1]);
            }
            if (mverb) {
                System.err.println();
                System.err.println("filter is: (" + filter + ")");
            }
        }
    }

    private static void parselv(GetOpt getOpt) {
        if (getOpt.hasOption('G')) {
            String string = getOpt.getOptionParam('G');
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            Tokens = stringTokenizer.countTokens();
            if (Tokens < 3) {
                EgLdap.usage();
                System.exit(0);
            }
            try {
                befCount = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                befCount = 0;
            }
            try {
                aftCount = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                aftCount = 0;
            }
            if (Tokens == 3) {
                Search = (String)stringTokenizer.nextElement();
            } else if (Tokens > 3) {
                try {
                    ind = Integer.parseInt((String)stringTokenizer.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    ind = 0;
                }
                try {
                    count = Integer.parseInt((String)stringTokenizer.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    count = 0;
                }
            }
        }
    }

    private static void search() {
        String[] stringArray;
        LDAPSearchResults lDAPSearchResults;
        Object[] objectArray = null;
        try {
            LDAPVirtualListControl lDAPVirtualListControl;
            lDAPSearchResults = new Vector();
            stringArray = null;
            if (sortOnServer && Sort.size() > 0) {
                lDAPVirtualListControl = new LDAPSortKey[Sort.size()];
                for (int i = 0; i < ((LDAPSortKey[])lDAPVirtualListControl).length; ++i) {
                    lDAPVirtualListControl[i] = new LDAPSortKey((String)Sort.elementAt(i));
                }
                stringArray = new LDAPSortControl((LDAPSortKey[])lDAPVirtualListControl, true);
                lDAPSearchResults.addElement(stringArray);
            }
            if (stringArray == null && Tokens >= 3) {
                System.err.println("Server-side sorting is required for virtual list option");
                EgLdap.usage();
                System.exit(0);
            }
            lDAPVirtualListControl = null;
            if (Tokens == 3) {
                lDAPVirtualListControl = new LDAPVirtualListControl(Search, befCount, aftCount);
            } else if (Tokens > 3) {
                lDAPVirtualListControl = new LDAPVirtualListControl(ind, befCount, aftCount, count);
            }
            if (lDAPVirtualListControl != null) {
                lDAPSearchResults.addElement(lDAPVirtualListControl);
            }
            if (pControl != null) {
                lDAPSearchResults.addElement(pControl);
            }
            if (ordinary) {
                LDAPControl lDAPControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
                lDAPSearchResults.addElement(lDAPControl);
            }
            if (lDAPSearchResults.size() > 0) {
                objectArray = new LDAPControl[lDAPSearchResults.size()];
                lDAPSearchResults.copyInto(objectArray);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(0);
        }
        lDAPSearchResults = null;
        try {
            stringArray = client.getSearchConstraints();
            stringArray.setServerControls(objectArray);
            stringArray.setDereference(ref);
            stringArray.setMaxResults(size);
            stringArray.setTimeLimit(time);
            stringArray.setReferrals(referrals);
            if (referrals) {
                EgLdap.setDefaultReferralCredentials((LDAPConstraints)stringArray);
            }
            stringArray.setHopLimit(hopLimit);
            lDAPSearchResults = client.search(base, scope, filter, m_attrs, attr, (LDAPSearchConstraints)stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        if (Sort.size() > 0 && !sortOnServer) {
            stringArray = new String[Sort.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)Sort.elementAt(i);
            }
            lDAPSearchResults.sort((LDAPEntryComparator)new LDAPCompareAttrNames(stringArray));
        }
        EgLdap.printResults(lDAPSearchResults);
        EgLdap.getControls(client.getResponseControls());
    }

    private static void printResults(LDAPSearchResults lDAPSearchResults) {
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPAttributeSet lDAPAttributeSet;
                LDAPEntry lDAPEntry = null;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (LDAPReferralException lDAPReferralException) {
                    lDAPAttributeSet = lDAPReferralException.getURLs();
                    System.err.println("Referral entries: ");
                    for (int i = 0; i < ((LDAPUrl[])lDAPAttributeSet).length; ++i) {
                        System.err.println("\t" + lDAPAttributeSet[i].getUrl().toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception.toString());
                    continue;
                }
                String string = lDAPEntry.getDN();
                if (string != null) {
                    EgLdap.printString("dn" + sep + " " + string);
                } else {
                    EgLdap.printString("dn" + sep);
                }
                lDAPAttributeSet = lDAPEntry.getAttributeSet();
                Enumeration enumeration = lDAPAttributeSet.getAttributes();
                while (enumeration.hasMoreElements()) {
                    LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                    String string2 = lDAPAttribute.getName();
                    if (attr) {
                        EgLdap.printString(string2 + ":");
                        continue;
                    }
                    Enumeration enumeration2 = lDAPAttribute.getByteValues();
                    if (enumeration2 != null) {
                        while (enumeration2.hasMoreElements()) {
                            Object object;
                            if (tempFile) {
                                try {
                                    object = EgLdap.gettmpFile(string2);
                                    ((FileOutputStream)object).write((byte[])enumeration2.nextElement());
                                }
                                catch (Exception exception) {
                                    System.err.println("Error writing values of " + string2 + ", " + exception.toString());
                                    System.exit(1);
                                }
                                continue;
                            }
                            object = (byte[])enumeration2.nextElement();
                            String string3 = null;
                            if (LDIF.isPrintable((byte[])object)) {
                                string3 = new String((byte[])object, "UTF8");
                                EgLdap.printString(string2 + sep + " " + string3);
                                continue;
                            }
                            ByteBuf byteBuf = new ByteBuf((byte[])object, 0, ((Object)object).length);
                            ByteBuf byteBuf2 = new ByteBuf();
                            MimeBase64Encoder mimeBase64Encoder = new MimeBase64Encoder();
                            mimeBase64Encoder.translate(byteBuf, byteBuf2);
                            int n = byteBuf2.length();
                            if (n > 0) {
                                string3 = new String(byteBuf2.toBytes(), 0, n);
                                EgLdap.printString(string2 + ":: " + string3);
                                continue;
                            }
                            mpw.print(string2 + ": \n");
                        }
                        continue;
                    }
                    System.err.println("Failed to do string conversion for " + string2);
                }
                mpw.println();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(0);
        }
    }

    private static void printString(String string) {
        if (fold) {
            LDIF.breakString((PrintWriter)mpw, (String)string, (int)77);
        } else {
            mpw.print(string);
            mpw.print('\n');
        }
    }

    private static void getControls(LDAPControl[] lDAPControlArray) {
        int n;
        if (lDAPControlArray == null) {
            return;
        }
        LDAPSortControl lDAPSortControl = null;
        LDAPVirtualListResponse lDAPVirtualListResponse = null;
        for (n = 0; n < lDAPControlArray.length; ++n) {
            if (lDAPControlArray[n] instanceof LDAPSortControl) {
                lDAPSortControl = (LDAPSortControl)lDAPControlArray[n];
                continue;
            }
            if (!(lDAPControlArray[n] instanceof LDAPVirtualListResponse)) continue;
            lDAPVirtualListResponse = (LDAPVirtualListResponse)lDAPControlArray[n];
        }
        if (lDAPSortControl != null) {
            String string = lDAPSortControl.getFailedAttribute();
            int n2 = lDAPSortControl.getResultCode();
            if (n2 != 0) {
                System.err.println("Error code: " + n2);
                if (string != null) {
                    System.err.println("Offending attribute: " + string);
                } else {
                    System.err.println("No offending attribute returned");
                }
            } else {
                mpw.println("Server indicated results sorted OK");
            }
        }
        if (lDAPVirtualListResponse != null) {
            n = lDAPVirtualListResponse.getResultCode();
            if (n == 0) {
                mpw.println("Server indicated virtual list positioning OK");
                mpw.println("index " + lDAPVirtualListResponse.getFirstPosition() + " content count " + lDAPVirtualListResponse.getContentCount());
            } else {
                System.err.println("Virtual List Error: " + LDAPException.errorCodeToString((int)n));
            }
        }
    }

    private static FileOutputStream gettmpFile(String string) throws IOException {
        String string2;
        File file;
        int n = 0;
        do {
            string2 = string + '.' + n;
            file = new File(string2);
            ++n;
        } while (file.exists());
        EgLdap.printString(string + sep + " " + string2);
        return new FileOutputStream(file);
    }

    protected static GetOpt getParameters(String string, String[] stringArray) {
        GetOpt getOpt = new GetOpt("vnRMD:h:O:p:w:d:V:y:" + string, stringArray);
        if (getOpt.hasOption('n')) {
            mjs = true;
        }
        if (getOpt.hasOption('v')) {
            mverb = true;
        }
        if (getOpt.hasOption('R')) {
            referrals = false;
        }
        if (getOpt.hasOption('D')) {
            bind = getOpt.getOptionParam('D');
        }
        if (getOpt.hasOption('h')) {
            host = getOpt.getOptionParam('h');
        }
        if (getOpt.hasOption('p')) {
            try {
                port = Integer.parseInt(getOpt.getOptionParam('p'));
            }
            catch (NumberFormatException numberFormatException) {
                port = 389;
            }
        }
        if (getOpt.hasOption('O')) {
            try {
                hopLimit = Integer.parseInt(getOpt.getOptionParam('O'));
            }
            catch (NumberFormatException numberFormatException) {
                hopLimit = 10;
            }
        }
        if (getOpt.hasOption('d')) {
            try {
                debugLevel = Integer.parseInt(getOpt.getOptionParam('d'));
            }
            catch (NumberFormatException numberFormatException) {
                debugLevel = 0;
            }
        }
        if (getOpt.hasOption('V')) {
            try {
                version = Integer.parseInt(getOpt.getOptionParam('V'));
            }
            catch (NumberFormatException numberFormatException) {
                version = 3;
            }
        }
        if (getOpt.hasOption('w')) {
            passwd = getOpt.getOptionParam('w');
        }
        if (getOpt.hasOption('y')) {
            pControl = new LDAPProxiedAuthControl(getOpt.getOptionParam('y'), true);
        }
        if (getOpt.hasOption('M')) {
            ordinary = true;
        }
        return getOpt;
    }

    protected static void setDefaultReferralCredentials(LDAPConstraints lDAPConstraints) {
        LDAPRebind lDAPRebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String string, int n) {
                return new LDAPRebindAuth(client.getAuthenticationDN(), client.getAuthenticationPassword());
            }
        };
        lDAPConstraints.setReferrals(true);
        lDAPConstraints.setRebindProc(lDAPRebind);
    }
}

