/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import com.eg.IniFile;
import com.eg.JmxMBeanData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class EgManagementTest
extends EgManagementBase {
    private String whoami = "agent";
    private EgConfigInfo configInfo = new EgConfigInfo(this.whoami);
    private File managementFile;
    public IniFile managementFilePtr;
    private long lastModifiedTime = 0L;
    protected boolean fileModified = false;
    private Hashtable ddResults = null;
    private boolean isDDExits = false;
    private JMXServiceURL jmxService = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    ArrayList operations = new ArrayList();
    private ArrayList excludedAgents = null;

    public EgManagementTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.loadFile();
        this.setTestsWithOperations();
    }

    private void loadFile() {
        this.managementFile = new File(EgInstallInfo.getInstallDir() + "/agent/config/eg_management.ini");
        this.managementFilePtr = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_management.ini");
    }

    public boolean checkForUpdate() {
        long l = this.managementFile.lastModified();
        if (l > this.lastModifiedTime) {
            this.lastModifiedTime = l;
            this.loadFile();
            this.fileModified = true;
            return true;
        }
        return false;
    }

    private ArrayList tokenizeMeasure(String string) {
        ArrayList<String> arrayList = null;
        if (string == null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2.substring(0, string2.indexOf(":")));
        }
        return arrayList;
    }

    public void setTestsWithOperations() {
        String[] stringArray = this.managementFilePtr.getVariables("TEST_OPERATION");
        if (stringArray != null && stringArray.length > 0) {
            this.operations.addAll(Arrays.asList(stringArray));
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.checkForUpdate();
        this.ddResults = new Hashtable();
        String string = this.managementFilePtr.getValue("TEST_MBEAN", this.entity);
        if (string == null) {
            return;
        }
        String string2 = this.managementFilePtr.getValue("MBEAN_MEASURE", string);
        ArrayList arrayList = this.tokenizeMeasure(string2);
        if (this.connectToJVM()) {
            Object object;
            Object object2;
            Object object3;
            if (this.entity.equals("EgAgentInfoTest") && (object3 = this.getValueForParam("exclude_agents")) != null && ((String)(object3 = ((String)object3).trim())).length() > 0 && !((String)object3).equalsIgnoreCase("null") && !((String)object3).equalsIgnoreCase("none")) {
                this.excludedAgents = new ArrayList();
                object2 = new StringTokenizer((String)object3, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (((String)(object = ((String)object).trim())).length() <= 0 || ((String)object).equalsIgnoreCase("none")) continue;
                    this.excludedAgents.add(object);
                }
            }
            try {
                object3 = new JmxMBeanData(this.beanServerConn, "agent");
                object2 = EgManagementTest.replace(string, "#", "=");
                object = new ObjectName((String)object2 + ",*");
                Set<ObjectName> set = this.beanServerConn.queryNames((ObjectName)object, null);
                Iterator<ObjectName> iterator = set.iterator();
                boolean bl = false;
                if (set.size() > 1 || this.entity.equals("EgClusterInfoTest") || this.entity.equals("EgHelperProcessTest") || this.entity.equals("EgEXECProcessInfoTest")) {
                    bl = true;
                }
                while (iterator.hasNext()) {
                    Object object4;
                    Object object5;
                    ObjectName objectName = iterator.next();
                    String string3 = objectName.toString();
                    if (!this.patternMatch(string3, (String)object2 + "*")) continue;
                    String string4 = this.formatDescriptor(string3);
                    if (this.operations.contains(this.entity)) {
                        this.executeOperations(objectName);
                    }
                    ArrayList<Double> arrayList2 = new ArrayList<Double>(arrayList);
                    String string5 = ((JmxMBeanData)object3).toString(objectName);
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6;
                        object5 = stringTokenizer.nextToken().trim();
                        if (object5 != null && ((String)object5).startsWith("MBean:") || object5 == null || ((String)object5).length() <= 0 || ((String)object5).indexOf("=") <= 0 || (string6 = ((String)object5).substring(0, ((String)object5).indexOf("=")).trim()) == null) continue;
                        if (string6.startsWith("DetailDiagnosis")) {
                            ArrayList arrayList3;
                            if (bl) {
                                Hashtable hashtable2 = (Hashtable)this.beanServerConn.getAttribute(objectName, "DetailDiagnosis");
                                this.ddResults.put(string4, hashtable2);
                                continue;
                            }
                            this.ddResults = (Hashtable)this.beanServerConn.getAttribute(objectName, "DetailDiagnosis");
                            if (!string6.equals("DetailDiagnosis[Not_running_agents][0]") || !this.entity.equals("EgAgentInfoTest") || this.ddResults == null || !this.ddResults.containsKey("Not_running_agents") || this.excludedAgents == null || this.excludedAgents.isEmpty() || (arrayList3 = (ArrayList)this.ddResults.get("Not_running_agents")) == null || arrayList3.isEmpty()) continue;
                            arrayList3.removeAll(this.excludedAgents);
                            continue;
                        }
                        int n = arrayList.indexOf(string6);
                        if (n < 0) continue;
                        object4 = ((String)object5).substring(((String)object5).indexOf("=") + 1).trim();
                        try {
                            Serializable serializable;
                            if (this.entity.equals("EgAgentInfoTest") && string6.equals("NotRunningAgentsCount") && this.excludedAgents != null && !this.excludedAgents.isEmpty() && ((Hashtable)(serializable = (Hashtable)this.beanServerConn.getAttribute(objectName, "DetailDiagnosis"))).containsKey("Not_running_agents")) {
                                ArrayList arrayList4 = (ArrayList)((Hashtable)serializable).get("Not_running_agents");
                                arrayList4.removeAll(this.excludedAgents);
                                object4 = String.valueOf(arrayList4.size());
                            }
                            serializable = new Double((String)object4);
                            arrayList2.set(n, (Double)serializable);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (set.size() > 1 || this.entity.equals("EgClusterInfoTest") || this.entity.equals("EgHelperProcessTest") || this.entity.equals("EgEXECProcessInfoTest")) {
                        if (this.entity.equals("EgInfrastructureTest") && arrayList2.size() == 6) {
                            object5 = (Double)arrayList2.get(0);
                            double d = (Double)object5;
                            object4 = (Double)arrayList2.get(1);
                            double d2 = (Double)object4;
                            Double d3 = (Double)arrayList2.get(2);
                            double d4 = d3;
                            Double d5 = (Double)arrayList2.get(3);
                            double d6 = d5;
                            Double d7 = (Double)arrayList2.get(4);
                            double d8 = d7;
                            Double d9 = (Double)arrayList2.get(5);
                            double d10 = d9;
                            if (d == 0.0 && d2 == 0.0 && d4 == 0.0 && d6 == 0.0 && d8 == 0.0 && d10 == 0.0) continue;
                        }
                        this.addNewMeasure(string4, arrayList2);
                        continue;
                    }
                    if (this.entity.equals("EgTriggerInfoTest")) {
                        boolean bl2 = true;
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            Double d = (Double)arrayList2.get(i);
                            int n = d.intValue();
                            if (n == -5) continue;
                            bl2 = false;
                            break;
                        }
                        if (bl2) {
                            this.isNewDynamicInfoTest = true;
                            return;
                        }
                    }
                    this.addNewMeasure(arrayList2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return;
        }
        this.closeJVMConn();
    }

    private boolean patternMatch(String string, String string2) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!string2.startsWith("*")) {
            bl2 = true;
        }
        if (!string2.endsWith("*")) {
            bl3 = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        int n2 = stringTokenizer.countTokens();
        String string3 = new String(string);
        String[] stringArray = new String[n2];
        if (n2 <= 0) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        if (bl2 && !string3.startsWith(stringArray[0])) {
            return false;
        }
        if (bl3 && !string3.endsWith(stringArray[n2 - 1])) {
            return false;
        }
        String string4 = null;
        for (int i = 0; i < n2; ++i) {
            int n3 = stringArray[i].lastIndexOf(".");
            string4 = n3 >= 0 ? (stringArray[i].endsWith(".exe") || stringArray[i].endsWith(".scr") || stringArray[i].endsWith(".com") || stringArray[i].endsWith(".bat") || stringArray[i].endsWith(".pl") || stringArray[i].endsWith(".vbs") || stringArray[i].endsWith(".wsf") || stringArray[i].endsWith(".wav") || stringArray[i].endsWith(".prn") ? stringArray[i].substring(0, n3) : stringArray[i]) : stringArray[i];
            n = string3.indexOf(string4);
            if (n == -1) {
                return false;
            }
            bl = true;
            string3 = new String(string3.substring(n += string4.length()));
        }
        return bl;
    }

    private boolean connectToJVM() {
        String string;
        boolean bl = false;
        String string2 = this.getValueForParam("Jmx_Remote_Port");
        String string3 = this.getValueForParam("Jndi_Name");
        String string4 = this.getValueForParam("Jmx_user");
        String string5 = this.getValueForParam("Jmx_password");
        if (string3 == null || "None".equalsIgnoreCase(string3) || "Null".equalsIgnoreCase(string3)) {
            string3 = "jmxrmi";
        }
        if (string4 == null) {
            string = this.getValueForParam("user");
            string4 = string != null ? string : "none";
        }
        if (string5 == null) {
            string = this.getValueForParam("password");
            string5 = string != null ? string : "none";
        }
        string = IPV6Helper.getValidIPAddress(this.targetHost);
        String string6 = "service:jmx:rmi:///jndi/rmi://" + string + ":" + string2 + "/" + string3;
        try {
            String[] stringArray;
            this.jmxService = new JMXServiceURL(string6);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            boolean bl2 = false;
            if (string4.equalsIgnoreCase("none") || string5.equalsIgnoreCase("none")) {
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            } else {
                stringArray = new String[]{string4, string5};
                hashMap.put("jmx.remote.credentials", stringArray);
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                stringArray = new SslRMIClientSocketFactory();
                Registry registry = LocateRegistry.getRegistry(this.targetHost, Integer.parseInt(string2), (RMIClientSocketFactory)stringArray);
                RMIServer rMIServer = (RMIServer)registry.lookup(string3);
                this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                this.rmiConnector.connect(hashMap);
                this.beanServerConn = this.rmiConnector.getMBeanServerConnection();
            } else {
                this.beanServerConn = this.jmxConnector.getMBeanServerConnection();
            }
            if (this.beanServerConn == null) {
                System.out.println("connection to JVM is not established for " + this.entity + " for reportingHost " + this.reportingName);
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("connection to JVM is not established for " + this.entity + " for reportingHost " + this.reportingName);
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    public static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string.length();
        while ((n2 = string.lastIndexOf(string2, n2 - 1)) > -1) {
            stringBuffer.replace(n2, n2 + n, string3);
        }
        return stringBuffer.toString();
    }

    private void closeJVMConn() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public ArrayList getDDResults(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.ddResults != null && this.ddResults.size() > 0 && this.ddResults.containsKey(string)) {
            arrayList = (ArrayList)this.ddResults.get(string);
            if (this.excludedAgents != null && !this.excludedAgents.isEmpty() && this.entity.equals("EgAgentInfoTest") && string.equals("Not_running_agents")) {
                arrayList.removeAll(this.excludedAgents);
            }
        }
        return arrayList;
    }

    public ArrayList getDDResults(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        if (this.ddResults != null && this.ddResults.size() > 0 && this.ddResults.containsKey(string2)) {
            Hashtable hashtable = (Hashtable)this.ddResults.get(string2);
            if (hashtable != null && hashtable.size() > 0 && hashtable.containsKey(string)) {
                arrayList = (ArrayList)hashtable.get(string);
            }
        } else {
            arrayList = this.getDDResults(string);
        }
        return arrayList;
    }
}

