/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.IPV6Helper;
import com.eg.IniFile;
import com.eg.PortDiscovery;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class EgServerValidator {
    public String host = "";
    public String port = "";
    public String sid = "";
    public String sqlHost = "";
    public String sqlport = "";
    public String admin_host = "";
    public String admin_port = "";
    public String vCenterIp = "";
    public String app_port = "";
    public String connector_port = "";
    public boolean isUsingVC = false;
    public boolean isWebLogic = false;
    public boolean isWebSphere = false;
    private static File statusFile;
    private static String statusFileName;
    private static String testFileName;
    private static long statusIniUpdateFrequency;
    public static long lastModifiedTime;
    private static long lastSize;
    public IniFile egStatusIni = null;
    public IniFile testINI = null;
    public String syncFlag = "StatusUpdate";
    public String agentOS = System.getProperty("os.name");
    public final String NEW_LINE = System.getProperty("line.separator");
    public String ipStacktrace = "";
    public boolean isLogEnabled = false;
    public boolean isIPReachable = false;
    public boolean isPortOk = false;
    boolean isUpdateStatusFile = false;
    public PortDiscovery pd = null;
    public EgDateInfo dateInfo = null;
    public static Hashtable log_entries;

    public EgServerValidator(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = "";
                String string3 = "";
                int n = string.indexOf(":");
                if (n > 0) {
                    string2 = string.substring(0, n);
                    if (n + 1 <= string.length()) {
                        string3 = string.substring(n + 1);
                    }
                }
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-Database_Server")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-SQL_Port_number")) {
                    this.port = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-info")) continue;
                this.sid = string3;
            }
        }
        statusFile = new File(statusFileName);
        lastModifiedTime = statusFile.lastModified();
        lastSize = statusFile.length();
        this.egStatusIni = new IniFile(statusFileName, true);
        this.testINI = new IniFile(testFileName);
        this.pd = new PortDiscovery();
        this.dateInfo = new EgDateInfo();
        String string = this.testINI.getValue("AGENT_SETTINGS", "error_logging");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.isLogEnabled = true;
        }
    }

    public boolean checkForUpdate() {
        long l = statusFile.lastModified();
        long l2 = statusFile.length();
        if (l == lastModifiedTime && lastSize == l2) {
            return false;
        }
        l = statusFile.lastModified();
        l2 = statusFile.length();
        if (l == lastModifiedTime && lastSize == l2) {
            return false;
        }
        lastModifiedTime = statusFile.lastModified();
        lastSize = statusFile.length();
        this.egStatusIni = new IniFile(statusFileName);
        return true;
    }

    public boolean isIPReachable() {
        ArrayList arrayList;
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string = "";
        this.agentOS = this.agentOS.toLowerCase();
        if (this.isUsingVC) {
            this.host = this.vCenterIp;
        }
        if (this.isWebLogic) {
            this.host = this.admin_host;
        }
        if (this.agentOS != null && this.agentOS.indexOf("windows") > -1) {
            string = "cmd.exe /c  " + EgInstallInfo.getInstallDir() + "/bin/nfping " + this.host;
        } else if (this.agentOS != null && (this.agentOS.indexOf("linux") > -1 || this.agentOS.indexOf("sunos") > -1 || this.agentOS.indexOf("hpux") > -1 || this.agentOS.indexOf("aix") > -1 || this.agentOS.indexOf("osf1") > -1)) {
            boolean bl = IPV6Helper.validateIPV6(this.host);
            string = bl ? EgInstallInfo.getInstallDir() + "/bin/fping6 " + this.host : EgInstallInfo.getInstallDir() + "/bin/fping " + this.host;
        }
        ArrayList arrayList2 = egUtilities.getExecOutputLines(string);
        if (arrayList2 != null && !arrayList2.isEmpty() && (arrayList = (ArrayList)arrayList2.get(0)) != null && !arrayList.isEmpty()) {
            ArrayList arrayList3;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = ((String)arrayList.get(i)).toLowerCase();
                if (string2 == null || string2.length() <= 0 || string2.indexOf("alive") <= 0 && !string2.startsWith("reply")) continue;
                this.isIPReachable = true;
                break;
            }
            if (!this.isIPReachable && arrayList2.size() >= 2 && (arrayList3 = (ArrayList)arrayList2.get(1)) != null && !arrayList3.isEmpty()) {
                this.ipStacktrace = (String)arrayList3.get(0);
            }
        }
        return this.isIPReachable;
    }

    public boolean isPortReachable() {
        this.pd.setTimeOut(250);
        if (this.isWebLogic) {
            this.host = this.admin_host;
            this.port = this.admin_port;
        }
        if (this.isWebSphere) {
            this.port = this.app_port;
        }
        if (this.port != null && !this.port.equalsIgnoreCase("NULL")) {
            int n = Integer.parseInt(this.port);
            this.isPortOk = this.pd.doesSocketExist(this.host, n);
        }
        return this.isPortOk;
    }

    public boolean isConnectorPortReachable() {
        this.pd.setTimeOut(250);
        if (this.connector_port != null && !this.connector_port.equalsIgnoreCase("NULL")) {
            int n = Integer.parseInt(this.connector_port);
            this.isPortOk = this.pd.doesSocketExist(this.host, n);
        }
        return this.isPortOk;
    }

    public boolean isSpecificPortReachable(String string) {
        this.pd.setTimeOut(250);
        if (string != null && !string.equalsIgnoreCase("NULL")) {
            int n = Integer.parseInt(string);
            this.isPortOk = this.pd.doesSocketExist(this.host, n);
        }
        return this.isPortOk;
    }

    public boolean checkFileUpdationFlag(String string) {
        long l;
        long l2 = System.currentTimeMillis();
        if (log_entries != null && log_entries.containsKey(string) && l2 - (l = ((Long)log_entries.get(string)).longValue()) >= statusIniUpdateFrequency) {
            this.isUpdateStatusFile = true;
        }
        return this.isUpdateStatusFile;
    }

    public synchronized void logMsgToStatusFile(String string, String string2, String string3) {
        if (!this.isLogEnabled) {
            return;
        }
        System.out.println("logMsgToStatusFile subject " + string + " key " + string2 + " value " + string3);
        Vector vector = new Vector();
        Vector vector2 = this.egStatusIni.getVariables("WORKING_TESTS", true);
        Vector vector3 = this.egStatusIni.getVariables("ERROR_TESTS", true);
        Vector<String> vector4 = new Vector<String>();
        String string4 = string2.substring(string2.lastIndexOf("#") + 1, string2.indexOf(":"));
        if (string != null && string.equals("WORKING_TESTS")) {
            if (this.checkFileUpdationFlag(string2)) {
                if (vector3 != null && vector3.size() > 0) {
                    for (int i = 0; i < vector3.size(); ++i) {
                        String string5 = (String)vector3.get(i);
                        String string6 = string5.substring(0, string5.indexOf(":"));
                        String string7 = string5.substring(string5.lastIndexOf("#") + 1, string5.indexOf(":"));
                        if (!string7.equals(string4)) continue;
                        vector4.add(string5);
                    }
                    this.DeleteFromError(vector4);
                }
                this.egStatusIni.setValue(string, string2, string3);
                this.egStatusIni.saveFile(true);
                log_entries.put(string2, new Long(System.currentTimeMillis()));
            }
        } else if (string != null && string.equals("ERROR_TESTS") && this.checkFileUpdationFlag(string2)) {
            System.out.println("Block for error sets ");
            if (vector2 != null && vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    String string8 = (String)vector2.get(i);
                    String string9 = string8.substring(0, string8.indexOf(":"));
                    if (!string2.startsWith(string9)) continue;
                    vector4.add(string8);
                }
                this.DeleteFromSucess(vector4);
            }
            this.egStatusIni.setValue(string, string2, string3);
            this.egStatusIni.saveFile(true);
            log_entries.put(string2, new Long(System.currentTimeMillis()));
        }
    }

    public void DeleteFromSucess(Vector vector) {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                this.egStatusIni.deleteValue("WORKING_TESTS", string);
            }
            this.egStatusIni.saveFile(true);
        }
    }

    public void DeleteFromError(Vector vector) {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                this.egStatusIni.deleteValue("ERROR_TESTS", string);
            }
            this.egStatusIni.saveFile(true);
        }
    }

    public String getStackTraceAsString(Throwable throwable) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            String string = stringWriter.toString();
            printWriter.close();
            return string;
        }
        catch (Exception exception) {
            return throwable.toString();
        }
    }

    public String getCurrentTime() {
        long l = this.dateInfo.egetUTCDate(true);
        String string = this.dateInfo.egetDate(l);
        return string;
    }

    static {
        statusFileName = EgInstallInfo.getInstallDir() + "/agent/config/eg_status.ini";
        testFileName = EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini";
        statusIniUpdateFrequency = 10L * EgConfigInfo.msecPerMin;
        lastSize = 0L;
        log_entries = new Hashtable();
    }
}

