/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.eg.apm.EgLogbackManager;
import com.eg.org.slf4j.Logger;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ElasticSearchBase
extends GenericTest {
    public ElasticSearchInfo esInfo = null;
    boolean isItAgentLessComp = false;
    private static final int ELASTIC_SEARCH_DEFAULT_PORT = 9200;
    private static final String ELASTIC_SEARCH_DEFAULT_IP = "127.0.0.1";
    private static final String ELASTIC_SEARCH_DEFAULT_PROTOCOL = "http";
    private static final String ELASTICSEARCH_TEST_URL_MAPPING_SUB = "ELASTICSEARCH_TEST_URL_MAPPING";
    public static String installDir = EgInstallInfo.getInstallDir();
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    public static final Logger logger = EgLogbackManager.getInstance().getLogger("ELASTIC_SEARCH_LOGGER");
    protected String logPrefix = " [" + this.reportingName + ":" + this.portNo + "] [" + this.entity + "] ";

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    public ElasticSearchBase(String[] args) {
        super(args);
        try {
            logger.info(String.valueOf(this.logPrefix) + "Initializing ElasticSearchBase ...");
            this.esInfo = new ElasticSearchInfo(this.reportingName);
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info(String.valueOf(this.logPrefix) + " targetHost is null or empty or none : " + this.targetHost);
                logger.info(String.valueOf(this.logPrefix) + " Using Default targetHost :" + ELASTIC_SEARCH_DEFAULT_IP);
                this.esInfo.setElasticSearchIp(ELASTIC_SEARCH_DEFAULT_IP);
            } else {
                logger.info(String.valueOf(this.logPrefix) + " Using targetHost :" + this.targetHost);
                this.esInfo.setElasticSearchIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info(String.valueOf(this.logPrefix) + " portNo is null or empty or none : " + this.portNo);
                logger.info(String.valueOf(this.logPrefix) + " Using Default portNo :" + 9200);
                this.esInfo.setElasticSearchPort(9200);
            } else {
                try {
                    int elasticsearch_Port = Integer.parseInt(this.portNo);
                    logger.info(String.valueOf(this.logPrefix) + " Using portNo :" + elasticsearch_Port);
                    this.esInfo.setElasticSearchPort(elasticsearch_Port);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info(String.valueOf(this.logPrefix) + " Invalid portNo : " + this.portNo + " Using Default portNo :" + 9200);
                    this.esInfo.setElasticSearchPort(9200);
                }
            }
            this.isItAgentLessComp = this.isSSH && this.alos != null && this.alos.equalsIgnoreCase("LINUX");
            String elasticsearch_UserName = this.readInputParameters("elasticsearch_UserName", "Elastic_Search_user", "none");
            String elasticsearch_Password = this.readInputParameters("elasticsearch_Password", "Elastic_Search_password", "none");
            String ssl_Enabled = this.readInputParameters("ssl_Enabled", "ssl", "false");
            String elasticsearch_RemoteHost = this.readInputParameters("elasticsearch_RemoteHost", "Cloud_Instance_URL", "none");
            String elasticsearch_Protocol = ELASTIC_SEARCH_DEFAULT_PROTOCOL;
            if (ssl_Enabled.trim().equalsIgnoreCase("true") || ssl_Enabled.trim().equalsIgnoreCase("yes")) {
                elasticsearch_Protocol = "https";
            }
            this.esInfo.setItAgentLessComp(this.isItAgentLessComp);
            this.esInfo.setElasticSearchUser(elasticsearch_UserName);
            this.esInfo.setElasticSearchPass(elasticsearch_Password);
            this.esInfo.setElasticSearchProtocol(elasticsearch_Protocol);
            this.esInfo.setElasticSearchRemoteHost(elasticsearch_RemoteHost);
        }
        catch (Exception initException) {
            logger.error(String.valueOf(this.logPrefix) + " Exception while initializing ElasticSearchBase", (Throwable)initException);
        }
    }

    protected String readInputParameters(String displayString, String parameterKey, String defaultValue) {
        if (parameterKey == null) {
            return null;
        }
        String parameterValue = this.getValueForParam(parameterKey);
        if (parameterValue == null || parameterValue.length() <= 0 || parameterValue.equalsIgnoreCase("none")) {
            logger.debug(String.valueOf(this.logPrefix) + displayString + " is null or empty or none or false or disabled : " + parameterValue);
            parameterValue = defaultValue;
            logger.info(String.valueOf(this.logPrefix) + "Using default " + displayString + " as " + parameterValue);
        } else if (parameterKey.contains("pass") || parameterKey.contains("password") || parameterKey.contains("pwd")) {
            logger.info(String.valueOf(this.logPrefix) + "Given " + displayString + " is succesfully entered");
        } else {
            logger.info(String.valueOf(this.logPrefix) + "Given " + displayString + " is " + parameterValue);
        }
        return parameterValue;
    }

    public ArrayList finalMeasures(int size) {
        ArrayList<Double> measure = new ArrayList<Double>();
        int z = 0;
        while (z < size) {
            measure.add(new Double(-5.0));
            ++z;
        }
        logger.debug(String.valueOf(this.logPrefix) + " [finalMeasures] creating and initializing the measure list ");
        return measure;
    }

    public Hashtable getElasticSearchNamesMappingTable(String subject) {
        Hashtable<String, String> keyValueMapingTable = new Hashtable<String, String>();
        try {
            IniFile egMeasure = new IniFile(String.valueOf(installDir) + iniFilePath);
            String[] keyVariables = egMeasure.getVariables(subject);
            int j = 0;
            while (j < keyVariables.length) {
                String name = egMeasure.getValue(subject, keyVariables[j]);
                if (name.contains("~!~")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(name, "~!~");
                    while (stringTokenizer.hasMoreTokens()) {
                        String versionBasedNameing = stringTokenizer.nextToken();
                        keyValueMapingTable.put(versionBasedNameing, keyVariables[j]);
                    }
                } else {
                    keyValueMapingTable.put(name, keyVariables[j]);
                }
                ++j;
            }
        }
        catch (Exception nameMapingException) {
            logger.error(String.valueOf(this.logPrefix) + " [getElasticSearchNamesMappingTable] Exception Occured while mapping the ke value of table for the subject :" + subject, (Throwable)nameMapingException);
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getElasticSearchNamesMappingTable] returning the table of Elastic Search key value pair for the " + subject + " in keyValueMapingTable : " + keyValueMapingTable);
        return keyValueMapingTable;
    }

    public Hashtable getElasticSearchIndexMappingTable(String subject) {
        Hashtable<String, String> indexMappingTable = new Hashtable<String, String>();
        try {
            IniFile egMeasure = new IniFile(String.valueOf(installDir) + iniFilePath);
            String[] esIndexTable = egMeasure.getVariables(subject);
            int i = 0;
            while (i < esIndexTable.length) {
                indexMappingTable.put(esIndexTable[i], egMeasure.getValue(subject, esIndexTable[i]));
                ++i;
            }
        }
        catch (Exception indexMappingException) {
            logger.error(String.valueOf(this.logPrefix) + " [getElasticSearchIndexMappingTable] Exception Occured while mapping the key value of table for the subject :" + subject, (Throwable)indexMappingException);
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getElasticSearchIndexMappingTable] returning the table of INI name and index of the Subject " + subject + " in indexMappingTable : " + indexMappingTable);
        return indexMappingTable;
    }

    public ArrayList getRestURLs(String subject) {
        ArrayList<String> list = new ArrayList<String>();
        Hashtable mappingTable = this.getElasticSearchNamesMappingTable(ELASTICSEARCH_TEST_URL_MAPPING_SUB);
        Iterator names = (Iterator)((Object)mappingTable.keys());
        while (names.hasNext()) {
            String name = (String)names.next();
            String nameKey = (String)mappingTable.get(name);
            if (!nameKey.equals(subject)) continue;
            list.add(name);
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getRestURLs] returning the list of ElasticSearch URL of the Subject " + subject + " in ElasticSearchURLList : " + list);
        return list;
    }

    public String formValidElasticsearchRestURL() {
        String elasticRestURL = "";
        String remoteHost = this.esInfo.getElasticSearchRemoteHost();
        String host = this.esInfo.getElasticSearchIp();
        elasticRestURL = remoteHost.equalsIgnoreCase("none") || remoteHost == null ? String.valueOf(this.esInfo.getElasticSearchProtocol()) + "://" + this.esInfo.getElasticSearchIp() + ":" + this.esInfo.getElasticSearchPort() : String.valueOf(this.esInfo.getElasticSearchProtocol()) + "://" + this.esInfo.getElasticSearchRemoteHost();
        logger.debug(String.valueOf(this.logPrefix) + " [formValidElasticsearchRestURL] The host URL of the component is : " + elasticRestURL);
        return elasticRestURL;
    }

    public String getElasticsearchVersion() {
        String version = "5.0";
        String elasticRestURL = this.formValidElasticsearchRestURL();
        String jsonData = this.getElasticsearchJSONData(elasticRestURL);
        try {
            if (jsonData == null || jsonData.equals("") || jsonData.equalsIgnoreCase("Null")) {
                logger.warn(String.valueOf(this.logPrefix) + " [getElasticsearchVersion] JSON data is NULL or Empty.  jsonData : " + jsonData);
                return version;
            }
            version = (String)JsonPath.read((String)jsonData, (String)"$['version']['number']", (Predicate[])new Predicate[0]);
            version = version.substring(0, version.lastIndexOf("."));
        }
        catch (PathNotFoundException versionException) {
            logger.warn(String.valueOf(this.logPrefix) + " [getElasticsearchVersion] $['version'] not found, Using default version number {}", (Object)version);
        }
        catch (Exception versionException) {
            logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchVersion] Exception Occured while fetching the version :", (Throwable)versionException);
            logger.warn(String.valueOf(this.logPrefix) + " [getElasticsearchVersion] Using default version number {}", (Object)version);
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getElasticsearchVersion] The version of the component is : " + version);
        return version;
    }

    public String getElasticSearchRestURLForTest(String subject) {
        String elasticRestURL = this.formValidElasticsearchRestURL();
        Double esVersionTemp = 5.0;
        try {
            esVersionTemp = Double.parseDouble(this.getElasticsearchVersion()) >= 5.0 ? 5.0 : 2.0;
            logger.debug(String.valueOf(this.logPrefix) + " [getElasticSearchRestURLForTest] Assigning Version {} API URLs to this component ", (Object)esVersionTemp);
        }
        catch (NumberFormatException e) {
            logger.debug(String.valueOf(this.logPrefix) + " [getElasticSearchRestURLForTest] Unable to parse ElasticsearchVerson due to " + e.getMessage());
        }
        String elasticVersion = "v." + esVersionTemp;
        ArrayList urlList = this.getRestURLs(subject);
        int i = 0;
        while (i < urlList.size()) {
            String value = (String)urlList.get(i);
            String iniVersion = value.substring(0, value.indexOf(":"));
            if (iniVersion.equals(elasticVersion)) {
                subject = value.substring(value.indexOf(":") + 1);
                String urlName = "";
                String elasticRestURL1 = "";
                if (subject.contains("(*)")) {
                    StringTokenizer tokenizer = new StringTokenizer(subject, "(*)");
                    while (tokenizer.hasMoreTokens()) {
                        urlName = tokenizer.nextToken();
                        elasticRestURL1 = String.valueOf(elasticRestURL1) + elasticRestURL + urlName + "(~!~)";
                    }
                    elasticRestURL = elasticRestURL1;
                } else {
                    elasticRestURL = String.valueOf(elasticRestURL) + subject;
                }
            }
            ++i;
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getElasticSearchRestURLForTest] The test URL is : " + elasticRestURL);
        return elasticRestURL;
    }

    /*
     * Loose catch block
     */
    public String getElasticsearchJSONData(String elasticRestURL) {
        String JSONData;
        block24: {
            JSONData = null;
            CloseableHttpResponse response = null;
            SSLContextBuilder builder = new SSLContextBuilder();
            String user = this.esInfo.getElasticSearchUser() != null ? this.esInfo.getElasticSearchUser() : "";
            String pass = this.esInfo.getElasticSearchPass() != null ? this.esInfo.getElasticSearchPass() : "";
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            try {
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
                HttpGet httpGet = new HttpGet(elasticRestURL);
                CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
                if (user != null || user.length() > 0 || pass != null || pass.length() > 0) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, pass);
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                    httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
                }
                response = httpclient.execute((HttpUriRequest)httpGet);
            }
            catch (HttpHostConnectException connectionException) {
                logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Unable to connect Elasticsearch server : ", (Throwable)connectionException);
                try {
                    if (response != null) {
                        JSONData = String.valueOf(EntityUtils.toString((HttpEntity)response.getEntity()));
                        response.close();
                    }
                    break block24;
                }
                catch (Exception jsonException) {
                    logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + jsonException);
                }
                break block24;
            }
            catch (SocketTimeoutException connectionException) {
                logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Unable to connect Elasticsearch server due to Socket Timed out ", (Throwable)connectionException);
                break block24;
            }
            catch (Exception connectionException) {
                logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Exception occured while fetching the connection with the component ", (Throwable)connectionException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (response != null) {
                        JSONData = String.valueOf(EntityUtils.toString((HttpEntity)response.getEntity()));
                        response.close();
                    }
                    break block24;
                }
                catch (Exception jsonException) {
                    logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + jsonException);
                }
                break block24;
            }
            {
                finally {
                    try {
                        if (response != null) {
                            JSONData = String.valueOf(EntityUtils.toString((HttpEntity)response.getEntity()));
                            response.close();
                        }
                    }
                    catch (Exception jsonException) {
                        logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + jsonException);
                    }
                }
            }
            try {
                if (response != null) {
                    JSONData = String.valueOf(EntityUtils.toString((HttpEntity)response.getEntity()));
                    response.close();
                }
            }
            catch (Exception jsonException) {
                logger.error(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + jsonException);
            }
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getElasticsearchJSONData] URL " + elasticRestURL + "\n The JSON data of the component is : " + JSONData);
        return JSONData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable getValueForKeyFromJSON_NonInfoBased(String JSONData, String testJSONPathSub) {
        if (JSONData == null) {
            return null;
        }
        Hashtable jsonTable = this.getElasticSearchNamesMappingTable(testJSONPathSub);
        Hashtable<String, Object> finalmeasureTable = new Hashtable<String, Object>();
        Iterator jsonNames = (Iterator)((Object)jsonTable.keys());
        try {
            while (jsonNames.hasNext()) {
                String json = (String)jsonNames.next();
                String jsonName = (String)jsonTable.get(json);
                try {
                    Object finalValue = JsonPath.read((String)JSONData, (String)json, (Predicate[])new Predicate[0]);
                    if (finalValue == null) continue;
                    finalmeasureTable.put(jsonName, finalValue);
                }
                catch (PathNotFoundException e) {
                    logger.debug(String.valueOf(this.logPrefix) + " [getValueForKeyFromJSON_NonInfoBased] Path {} not found in JsonData {}", (Object)json, (Object)JSONData);
                }
            }
        }
        catch (Exception jsonException) {
            logger.error(String.valueOf(this.logPrefix) + " [getValueForKeyFromJSON_NonInfoBased] Exception occured while mapping the values from testTable ", (Throwable)jsonException);
        }
        logger.debug(String.valueOf(this.logPrefix) + " [getValueForKeyFromJSON_NonInfoBased] The Name and Value table  of the component is : " + finalmeasureTable);
        return finalmeasureTable;
    }

    public Hashtable jsonBuilder(String JSONData, String testJSONPathSub, ArrayList discriptor) {
        Hashtable jsonTable = this.getElasticSearchNamesMappingTable(testJSONPathSub);
        Hashtable measureTable = new Hashtable();
        try {
            int i = 0;
            while (i < discriptor.size()) {
                Hashtable<String, String> finalmeasureTable = new Hashtable<String, String>();
                String disc = (String)discriptor.get(i);
                String json = null;
                String jsonName = null;
                Iterator jsonNames = (Iterator)((Object)jsonTable.keys());
                while (jsonNames.hasNext()) {
                    json = (String)jsonNames.next();
                    jsonName = (String)jsonTable.get(json);
                    json = String.valueOf(disc) + json;
                    finalmeasureTable.put(jsonName, json);
                }
                if (disc.equalsIgnoreCase("$['_all']")) {
                    measureTable.put("Summary", finalmeasureTable);
                } else {
                    measureTable.put(disc.substring(disc.indexOf("]") + 3, disc.length() - 2), finalmeasureTable);
                }
                ++i;
            }
        }
        catch (Exception jsonException) {
            logger.error(String.valueOf(this.logPrefix) + " [jsonBuilder] Exception occured while mapping the values from testTable ", (Throwable)jsonException);
        }
        logger.debug(String.valueOf(this.logPrefix) + " [jsonBuilder] The Name and Value table  of the component is : " + measureTable);
        return measureTable;
    }

    public String getMoreThanOneJson(String elasticRestURL) {
        String jsonData = "";
        if (elasticRestURL.contains("(~!~)")) {
            StringTokenizer stringTokenizer = new StringTokenizer(elasticRestURL, "(~!~)");
            while (stringTokenizer.hasMoreTokens()) {
                jsonData = String.valueOf(jsonData) + this.getElasticsearchJSONData(stringTokenizer.nextToken()) + "|*|";
            }
        }
        jsonData = jsonData.substring(0, jsonData.length() - 3);
        return jsonData;
    }

    public ArrayList updateMeasureIndex(Hashtable finalmeasureTable, String testJSONIndexSub, int measureCount) {
        ArrayList measure = this.finalMeasures(measureCount);
        Hashtable iniJSONIndexTable = this.getElasticSearchIndexMappingTable(testJSONIndexSub);
        Iterator jsonNames = (Iterator)((Object)finalmeasureTable.keys());
        while (jsonNames.hasNext()) {
            String key = (String)jsonNames.next();
            String value = finalmeasureTable.get(key).toString();
            if (!iniJSONIndexTable.containsKey(key)) continue;
            int index = Integer.parseInt(iniJSONIndexTable.get(key).toString());
            try {
                double finalValue = Double.parseDouble(value);
                measure.set(index, finalValue);
            }
            catch (Exception parseException) {
                measure.set(index, value);
            }
        }
        logger.debug(String.valueOf(this.logPrefix) + " [updateMeasureIndex] The measure list after filling the values in the respective index : " + this.measures);
        return measure;
    }
}

