/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class EndecaPerfTest
extends GenericTest {
    private String perfStatURL = "";
    private double[] prevPerfSummaryStatsTotal;
    private double[] prevPerfSummarySamplesCount;

    public static void main(String[] stringArray) {
        EndecaPerfTest endecaPerfTest = new EndecaPerfTest(stringArray);
        endecaPerfTest.computeMeasures(null);
    }

    public EndecaPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
        this.perfStatURL = this.getValueForParam("perfStatURL");
        this.prevPerfSummaryStatsTotal = new double[8];
        this.prevPerfSummarySamplesCount = new double[8];
        for (int i = 0; i < 8; ++i) {
            this.prevPerfSummaryStatsTotal[i] = -5.0;
            this.prevPerfSummarySamplesCount[i] = -5.0;
        }
        this.perfStatURL = this.perfStatURL + "/admin?op=stats";
    }

    public void computeMeasures(Hashtable hashtable) {
        EndecaStatsParser endecaStatsParser = new EndecaStatsParser();
        endecaStatsParser.parse(this.perfStatURL);
        double[] dArray = endecaStatsParser.getPerfSummaryStatsTotal();
        double[] dArray2 = endecaStatsParser.getPerfSummarySamplesCount();
        ArrayList<Double> arrayList = new ArrayList<Double>(9);
        arrayList.add(new Double(endecaStatsParser.getThroughputValue()));
        for (int i = 0; i < 8; ++i) {
            if (this.prevPerfSummaryStatsTotal[i] < 0.0 || this.prevPerfSummarySamplesCount[i] < 0.0) {
                this.prevPerfSummaryStatsTotal[i] = dArray[i];
                this.prevPerfSummarySamplesCount[i] = dArray2[i];
                arrayList.add(new Double(-5.0));
                continue;
            }
            double d = dArray[i] - this.prevPerfSummaryStatsTotal[i];
            double d2 = dArray2[i] - this.prevPerfSummarySamplesCount[i];
            if (d2 == 0.0) {
                arrayList.add(new Double(0.0));
            } else if (d2 > 0.0) {
                double d3 = d / d2;
                if (i >= 3 && i <= 6) {
                    d3 /= 1000.0;
                }
                if (d3 >= 0.0) {
                    arrayList.add(new Double(d3));
                } else {
                    arrayList.add(new Double(-5.0));
                }
            } else {
                arrayList.add(new Double(-5.0));
            }
            this.prevPerfSummaryStatsTotal[i] = dArray[i];
            this.prevPerfSummarySamplesCount[i] = dArray2[i];
        }
        this.addMeasures(arrayList);
    }
}

