/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class ExtBatteryInfoTest
extends EgSnmpGenericTest {
    private static String startOid = ".1.3.6.1.4.1.318.1.1.1.2.2";
    private static int numMeasures = 3;

    public ExtBatteryInfoTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue(String string) {
        if (string == null || string.length() == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            int n = string.indexOf(":");
            int n2 = string.length();
            string = string.substring(n + 1, n2);
            string = string.trim();
            d = Double.parseDouble(string);
            if (d < 0.0) {
                d = -5.0;
            }
            System.out.println("[UpsStatusTest] D value is ==>" + d);
            return d;
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "ExtBatteryInfoTest Exception occured in getValue() for " + this.targetHost, exception.toString());
            d = -5.0;
            return d;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        boolean bl = false;
        try {
            bl = this.runSnmpCmdForOid(startOid);
            if (!bl) {
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.lhs[i].startsWith("1.0")) {
                    d = this.getValue(this.rhs[i]);
                    continue;
                }
                if (this.lhs[i].startsWith("2.0")) {
                    d2 = this.getValue(this.rhs[i]);
                    continue;
                }
                if (!this.lhs[i].startsWith("4.0")) continue;
                d3 = Double.parseDouble(this.rhs[i]);
                if (d3 < 0.0) {
                    d3 = -5.0;
                }
                if (d3 == 2.0) {
                    d3 = 0.0;
                    continue;
                }
                if (d3 != 1.0) continue;
                d3 = 100.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            System.out.println("MeasureList  :" + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ExtBatteryInfoTest extBatteryInfoTest = new ExtBatteryInfoTest(stringArray);
        extBatteryInfoTest.computeMeasures(new Hashtable());
    }
}

