/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class GitHubTest
extends GenericTest {
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    private static final String DEFAULT_SERVICE_URL = "https://api.github.com";
    private String user = "";
    private String password = "";
    private String encodedAuth = "";
    private String login = "";
    public Hashtable ddHashtable = new Hashtable();
    public Hashtable dataHash = new Hashtable();
    private final String DEFAULT_URI_SUFFIX = "";

    public GitHubTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        String string = this.getValueForParam("username");
        String string2 = this.getValueForParam("password");
        if (string != null && !string.equalsIgnoreCase("none")) {
            this.user = string;
        }
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            this.password = string2;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            this.encodedAuth = new String(Base64.encode((String)(this.user + ":" + this.password)));
            this.ddHashtable = new Hashtable();
            this.dataHash = new Hashtable();
            String string = "https://api.github.com/users/" + this.user + "/followers";
            String string2 = "https://api.github.com/users/" + this.user + "/following";
            Hashtable hashtable2 = this.getGitHubUserDetails();
            if (hashtable2 != null && hashtable2.size() > 0) {
                Set set = hashtable2.keySet();
                for (String string3 : set) {
                    ArrayList arrayList = (ArrayList)hashtable2.get(string3);
                    if (arrayList == null && arrayList.size() == 0) continue;
                    this.addNewMeasure(string3, arrayList);
                }
            }
            this.getGitHubFollowDD(string);
            this.getGitHubFollowDD(string2);
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Exception :", "[ " + this.entity + " ] Exception occured in computeMeasures for ", this.targetHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getGitHubUserDetails() {
        String string;
        String string2 = "/user";
        String string3 = "";
        Hashtable hashtable = new Hashtable();
        ClientResponse clientResponse = null;
        try {
            string3 = DEFAULT_SERVICE_URL + string2;
            Client client2 = Client.create();
            string = client2.resource(string3);
            clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)string.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string4 = (String)clientResponse.getEntity(String.class);
            if (n == 401) {
                this.logToErrorFile("ERROR :", "[ " + this.entity + " ] Invalid Username or Password. Failed to get GitHub account details for ", this.targetHost);
                Hashtable hashtable2 = hashtable;
                return hashtable2;
            }
            if ((n == 201 || n == 200) && string4 != null && string4.trim().length() > 0) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                JSONParser jSONParser = new JSONParser();
                Object object = jSONParser.parse(string4.toString());
                JSONObject jSONObject = (JSONObject)object;
                if (jSONObject != null) {
                    double d = ((Long)jSONObject.get((Object)"public_repos")).longValue();
                    double d2 = ((Long)jSONObject.get((Object)"public_gists")).longValue();
                    double d3 = ((Long)jSONObject.get((Object)"total_private_repos")).longValue();
                    double d4 = ((Long)jSONObject.get((Object)"private_gists")).longValue();
                    double d5 = ((Long)jSONObject.get((Object)"collaborators")).longValue();
                    double d6 = ((Long)jSONObject.get((Object)"followers")).longValue();
                    double d7 = ((Long)jSONObject.get((Object)"following")).longValue();
                    Long l = (Long)jSONObject.get((Object)"disk_usage");
                    JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"plan");
                    Long l2 = (Long)jSONObject2.get((Object)"space");
                    double d8 = ((Long)jSONObject2.get((Object)"collaborators")).longValue();
                    double d9 = ((Long)jSONObject2.get((Object)"private_repos")).longValue();
                    this.login = (String)jSONObject.get((Object)"login");
                    double d10 = (double)l.longValue() / 1024.0;
                    long l3 = 0x100000L;
                    double d11 = l2 / l3;
                    double d12 = d10 / d11 * 100.0;
                    double d13 = d11 - d10;
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d10));
                    arrayList.add(new Double(d12));
                    arrayList.add(new Double(d11));
                    arrayList.add(new Double(d8));
                    arrayList.add(new Double(d9));
                    arrayList.add(new Double(d13));
                    hashtable.put(this.login, arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
        finally {
            if (clientResponse != null) {
                System.out.println("[" + this.entity + "] cLOSING THE Connection ");
                clientResponse.close();
                clientResponse = null;
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGitHubFollowDD(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        ClientResponse clientResponse = null;
        try {
            if (string.indexOf("followers") > -1) {
                string2 = "followers";
            } else if (string.indexOf("following") > -1) {
                string2 = "following";
            }
            Client client2 = Client.create();
            WebResource webResource = client2.resource(string);
            clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string3 = (String)clientResponse.getEntity(String.class);
            if (n == 401) {
                this.logToErrorFile("ERROR :", "[ " + this.entity + " ] Invalid Username or Password. Failed to get GitHub Accounts details for ", this.targetHost);
            }
            if ((n == 201 || n == 200) && string3 != null && string3.trim().length() > 0) {
                JSONParser jSONParser = new JSONParser();
                JSONArray jSONArray = (JSONArray)jSONParser.parse(string3);
                for (JSONObject jSONObject : jSONArray) {
                    if (jSONObject == null) continue;
                    String string4 = (String)jSONObject.get((Object)"login");
                    Long l = (Long)jSONObject.get((Object)"id");
                    String string5 = (String)jSONObject.get((Object)"html_url");
                    String string6 = (String)jSONObject.get((Object)"type");
                    String string7 = string4 + "~!~" + l + "~!~" + string6 + "~!~" + string5;
                    arrayList.add(string7);
                }
                this.dataHash.put(string2, arrayList);
                this.ddHashtable.put(this.login, this.dataHash);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string8 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string8);
        }
        finally {
            if (clientResponse != null) {
                System.out.println("[" + this.entity + "] getGitHubFollowDD closing the connection");
                clientResponse.close();
                clientResponse = null;
            }
        }
    }
}

